<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


if(!defined('VALID_RUN')){
	header("HTTP/1.1 404 Not Found");
	exit;
}

System::admin()->AddSubTitle('Web-');

if(!System::user()->CheckAccess2('forms', 'forms')){
	System::admin()->AccessDenied();
}

include_once System::config('inc_dir').'forms.inc.php';

if(isset($_GET['a'])){
	$action = $_GET['a'];
}else{
	$action = 'main';
}

TAddToolLink('Web-', 'main', 'forms');
TAddToolLink(' ', 'add', 'forms&a=add');
TAddToolLink('', 'config', 'forms&a=config');
TAddToolBox($action);

switch($action){
	case 'main': AdminFormsMain();
		break;
	case 'add':
	case 'edit': AdminFormsEditor();
		break;
	case 'del': AdminFormsDelete();
		break;
	case 'editsave': AdminFormsSave();
		break;
	case 'addsave': AdminFormsSave();
		break;
	case 'fields': AdminFormsFields();
		break;
	case 'addfield': AdminFormsFieldSave();
		break;
	case 'editfield': AdminFormsEditFields();
		break;
	case 'delfield': AdminFormsDelField();
		break;
	case 'changestatus': AdminFormsChangeStatus();
		break;
	case 'posts': AdminFormsViewPosts(false);
		break;
	case 'newposts': AdminFormsViewPosts(true);
		break;
	case 'delpost': AdminFormsDeletePost();
		break;
	case 'checkall': AdminFormsCheckAll();
		break;
	case 'config':
		System::admin()->AddCenterBox('  "Web-"');
		if(isset($_GET['saveok'])){
			System::admin()->Highlight(' .');
		}
		System::admin()->ConfigGroups('forms');
		System::admin()->AddConfigsForm(ADMIN_FILE.'?exe=forms&a=configsave');
		break;
	case 'configsave':
		System::admin()->SaveConfigs('forms');
		Audit('Web-:   ');
		GO(ADMIN_FILE.'?exe=forms&a=config&saveok');
		break;
	default: AdminFormsMain();
}


//  
function AdminFormsMain(){
	$forms = System::database()->Select('forms', '');
	SortArray($forms, 'new_answ', true);
	$text = '';
	$text .= '<table cellspacing="0" cellpadding="0" class="cfgtable">';
	$text .= '<tr>
		<th></th>
		<th> </th>
		<th> </th>
		<th></th>
		<th> </th>
		<th></th>
		<th></th>
	</tr>';
	foreach($forms as $form){
		$id = SafeDB($form['id'], 11, int);
		$vi = ViewLevelToStr(SafeDB($form['view'], 1, int));

		$status = System::admin()->SpeedStatus('', '', ADMIN_FILE.'?exe=forms&a=changestatus&id='.$id, $form['active'], 'images/bullet_green.png', 'images/bullet_red.png');
		$answ = (SafeDB($form['answ'], 11, int) > 0 ? '<b>'.SafeDB($form['answ'], 11, int).'</b> / <a href="'.ADMIN_FILE.'?exe=forms&a=posts&id='.$id.'"></a>' : SafeDB($form['answ'], 11, int));
		$new_answ = (SafeDB($form['new_answ'], 11, int) > 0 ? '<b>'.SafeDB($form['new_answ'], 11, int).'</b> / <a href="'.ADMIN_FILE.'?exe=forms&a=newposts&id='.$id.'"></a>' : SafeDB($form['new_answ'], 11, int));

		$link_go = Ufu('index.php?name=forms&formlink='.SafeDB($form['link'], 255, str), 'forms:form');

		$func = '';
		$func .= System::admin()->SpeedButton('    ', $link_go, 'images/link_go.png', false, false, 'target="_blank"');
		$func .= System::admin()->SpeedButton(' ', ADMIN_FILE.'?exe=forms&a=edit&id='.$id, 'images/admin/edit.png');
		$func .= System::admin()->SpeedButton(' ', ADMIN_FILE.'?exe=forms&a=fields&id='.$id, 'images/admin/config.png');
		$func .= System::admin()->SpeedConfirm(' ', ADMIN_FILE.'?exe=forms&a=del&id='.$id, 'images/admin/delete.png', ' ?');

		$text .= '<tr>
		<td><b>'.System::admin()->Link(SafeDB($form['hname'], 255, str), ADMIN_FILE.'?exe=forms&a=edit&id='.$id).'</a></b></td>
		<td>'.$new_answ.'</td>
		<td>'.$answ.'</td>
		<td>'.SafeDB($form['numfields'], 11, int).'</td>
		<td>'.$vi.'</td>
		<td>'.$status.'</td>
		<td>'.$func.'</td>
		</tr>
		';
	}
	$text .= '</table><br />';
	AddTextBox('Web-', $text);
}

//   -    -  
function AdminFormsEditor(){
	$name = '';
	$hname = '';
	$link = '';
	$desc = '';
	$form_action = '';
	$email = '';
	$send_ok_msg = '';
	$view = 4;
	$active = true;
	if(!isset($_GET['id'])){
		$action = 'addsave';
		$top = ' ';
		$cap = '';
	}else{
		$id = SafeEnv($_GET['id'], 11, int);
        System::database()->Select('forms', "`id`='$id'");
		$form = System::database()->FetchRow();
		$hname = SafeDB($form['hname'], 255, str);
		$name = SafeDB($form['name'], 255, str);
		$link = SafeDB($form['link'], 255, str);
		$desc = SafeDB($form['desc'], 0, str, false);
		$view = SafeDB($form['view'], 1, int);
		$active = SafeDB($form['active'], 1, bool);
		$form_action = SafeDB($form['action'], 250, str);
		$email = SafeDB($form['email'], 250, str);
		$send_ok_msg = SafeDB($form['send_ok_msg'], 0, str, false);
		$action = 'editsave&id='.$id;
		$top = ' ';
		$cap = ' ';
	}

	FormRow('', System::site()->Edit('hname', $hname, false, 'maxlength="250" style="width:400px;" class="autofocus"'));
	FormRow('', System::site()->Edit('link', $link, false, 'style="width:400px;"'));

	FormRow(' html', System::site()->Edit('name', $name, false, 'maxlength="250" style="width:400px;"'));
	FormTextRow('', System::site()->HtmlEditor('desc', $desc, 600, 200));
	FormRow('    ', System::site()->Edit('send_ok_msg', $send_ok_msg, false, 'maxlength="250" style="width:400px;"'));
	FormRow('  (  ,    )', System::site()->Edit('action', $form_action, false, 'maxlength="250" style="width:400px;"'));
	FormRow('Email (    e-mail)', System::site()->Edit('email', $email, false, 'maxlength="50" style="width:400px;"'));
	FormRow(' ', System::site()->Select('view', GetUserTypesFormData($view)));
	FormRow('', System::site()->Select('active', GetEnData($active, '', '')));
	AddCenterBox($top);
	AddForm('<form action="'.ADMIN_FILE.'?exe=forms&a='.$action.'" method="post">', System::site()->Button('', 'onclick="history.go(-1)"').System::site()->Submit($cap));
}

//  
function AdminFormsSave(){
	$hname = SafeEnv($_POST['hname'], 255, str);
	$link = SafeEnv($_POST['link'], 255, str);
	if($link == ''){
		$link = SafeEnv(UfuLink($_POST['hname']), 255, str);
	}
	$name = SafeEnv($_POST['name'], 255, str);
	$desc = SafeEnv($_POST['desc'], 0, str);
	$form_action = SafeEnv($_POST['action'], 250, str);
	$email = SafeEnv($_POST['email'], 50, str);
	$msg_ok = SafeEnv($_POST['send_ok_msg'], 0, str);
	$view = ViewLevelToInt($_POST['view']);
	$active = EnToInt($_POST['active']);
	if(isset($_GET['id'])){
		$set = "`hname`='$hname',`link`='$link',`name`='$name',`desc`='$desc',`view`='$view',`active`='$active',`action`='$form_action',`email`='$email',`send_ok_msg`='$msg_ok'";
		$id = SafeEnv($_GET['id'], 11, int);
		System::database()->Update('forms', $set, "`id`='$id'");
		Audit('Web-:   "'.$name.'"');
		GO(ADMIN_FILE.'?exe=forms');
	}else{
		$form_data = serialize(array());
		$values = Values('', $hname, $name, $link, $desc, 0, 0, 0, $form_data, $active, $view, $form_action, $email, $msg_ok);
		System::database()->Insert('forms', $values);
		Audit('Web-:   "'.$name.'"');
		GO(ADMIN_FILE.'?exe=forms');
	}
}

//   
function AdminFormsFieldEditor( $action ){
	global $cl_plugins, $cs_plugins;
	if(!isset($_GET['id'])){
		GO(ADMIN_FILE.'?exe=forms');
	}
	$id = SafeEnv($_GET['id'], 11, int);
	$collsd = array();
	for($i = 1; $i < 11; $i++){
		System::site()->DataAdd($collsd, $i, $i);
	}
	$getfuncdata = array();
	System::site()->DataAdd($getfuncdata, '', '');
	foreach($cl_plugins as $pl){
		System::site()->DataAdd($getfuncdata, $pl[0], $pl[0]);
	}
	$savefuncdata = array();
	System::site()->DataAdd($savefuncdata, '', '');
	foreach($cs_plugins as $pl){
		System::site()->DataAdd($savefuncdata, $pl[0], $pl[0]);
	}
	$controls = array();
	System::site()->DataAdd($controls, 'edit', ' ');
	System::site()->DataAdd($controls, 'text', ' ');
	System::site()->DataAdd($controls, 'combo', ' ');
	System::site()->DataAdd($controls, 'list', ' ()');
	System::site()->DataAdd($controls, 'check', '');
	System::site()->DataAdd($controls, 'radio', '');
	//System::site()->DataAdd($controls,'file','');
	$datatypes = array();
	System::site()->DataAdd($datatypes, 'int', '');
	System::site()->DataAdd($datatypes, 'float', '');
	System::site()->DataAdd($datatypes, 'string', '');
	System::site()->DataAdd($datatypes, 'bool', '');
	//System::site()->DataAdd($datatypes,'file','');
	if($action == 'add'){
		$hname = '';
		$name = '';
		$width = '';
		$height = '';
		$length = '0';
		$values = '';
		$cp = '';
		$edit = false;
		System::admin()->FormTitleRow(' ');
	}else{
		$index = SafeEnv($_GET['index'], 11, int);
        System::database()->Select('forms', "`id`='$id'");
		$form = System::database()->FetchRow();
		$fields = unserialize($form['form_data']);
		$field = $fields[$index];
		$hname = $field['hname'];
		$name = $field['name'];
		$stype = FormsParseParams(explode(':', $field['kind']));
		$width = $stype['width'];
		$height = $stype['height'];
		$cols = $stype['cols'];
		$controls['selected'] = $stype['control'];
		$collsd['selected'] = $cols;
		$vv = explode(':', $field['values']);
		if(count($vv) == 2 && FormsConfigCheck2Func($vv[0], $vv[1])){
			$getfuncdata['selected'] = $vv[1];
			$values = '';
		}else{
			$values = $field['values'];
		}
		if(function_exists($field['savefunc'])){
			$savefuncdata['selected'] = $field['savefunc'];
		}
		$type = explode(',', $field['type']);
		$datatypes['selected'] = $type[1];
		$length = $type[0];
		$cp = ' ';
		$edit = true;
	}
	FormRow('', System::site()->Edit('hname', $hname, false, 'maxlength="250" style="width:400px;" class="autofocus"'));
	FormRow(' HTML (   )', System::site()->Edit('name', $name, false, 'maxlength="250" style="width:400px;"'));
	FormRow('  (      : %, px)',
		'<table>'
		.'<tr><td colspan="2" style="border:none; padding: 2px;">'.System::site()->Select('control', $controls).'<td></tr>'
		.'<tr><td style="border:none; padding: 2px;">:</td>'.'<td style="border:none; padding: 2px;">'.System::site()->Edit('cwidth', $width, false, 'style="width:100px;"').'</td></tr>'
		.'<tr><td style="border:none; padding: 2px;">:</td>'.'<td style="border:none; padding: 2px;">'.System::site()->Edit('cheight', $height, false, 'style="width:100px;"').'</td></tr>'
		.'<tr><td style="border:none; padding: 2px;">:</td>'.'<td style="border:none; padding: 2px;">'.System::site()->Select('ccols', $collsd).'</td></tr>'
		.'</table>'
	);
	FormTextRow('  (: name:,name:, ....    .)', System::site()->TextArea('values', $values, 'style="width:600px;height:100px;"'));
	FormRow('  ', System::site()->Select('valuesfunc', $getfuncdata));
	FormRow(' ', System::site()->Select('savefunc', $savefuncdata));
	FormRow(' ', System::site()->Select('datatype', $datatypes));
	FormRow(' (  ., 0 - )', System::site()->Edit('maxlength', $length, false, 'style="width:60px;" maxlength="11"'));
	AddForm(System::site()->FormOpen(ADMIN_FILE.'?exe=forms&a=addfield&id='.$id.($edit ? '&index='.$index : '')), ($edit ? System::site()->Button('', 'onclick="history.go(-1);"') : '').System::site()->Submit($cp));
}

function AdminFormsFields(){
	if(!isset($_GET['id'])){
		GO(ADMIN_FILE.'?exe=forms');
	}
	$id = SafeEnv($_GET['id'], 11, int);
    System::database()->Select('forms', "`id`='$id'");
	$form = System::database()->FetchRow();
	$fields = unserialize($form['form_data']);
	$cnt = count($fields);
	AddCenterBox('  "'.$form['hname'].'"');
	$text = '';
	$text .= '<table cellspacing="0" cellpadding="0" class="cfgtable">';
	$text .= '<tr><th></th><th> HTML</th><th></th><th></th><th> </th><th> </th><th></th></tr>';
	if($cnt > 0){
		for($i = 0; $i < $cnt; $i++){
			$func = '';
			$func .= System::admin()->SpeedButton('', ADMIN_FILE.'?exe=forms&a=editfield&id='.SafeDB($form['id'], 11, int).'&index='.$i, 'images/admin/edit.png');
			$func .= System::admin()->SpeedConfirm('', ADMIN_FILE.'?exe=forms&a=delfield&id='.SafeDB($form['id'], 11, int).'&index='.$i, 'images/admin/delete.png', '?');

			$type = explode(',', $fields[$i]['type']);
			$text .= '<tr><td>'.SafeDB($fields[$i]['hname'], 255, str).'</td><td>'.SafeDB($fields[$i]['name'], 255, str).'</td><td>'.FormsGetControl($fields[$i]['name'], '', $fields[$i]['kind'], $fields[$i]['type'], $fields[$i]['values']).'</td><td>'.SafeDB($type[1], 50, str).'</td><td>'.SafeDB($type[0], 11, int).'</td><td>'.$fields[$i]['kind'].'</td><td>'.$func.'</td></tr>';
		}
	}else{
		$text .= '<tr><td colspan="7" style="text-align: left;">    .</td></tr>';
	}
	$text .= '</table>';
	AddText($text);
	AdminFormsFieldEditor('add');
}

function AdminFormsFieldSave(){
	if(!isset($_GET['id'])){
		GO(ADMIN_FILE.'?exe=forms');
	}
	$id = SafeEnv($_GET['id'], 11, int);
    System::database()->Select('forms', "`id`='$id'");
	if(System::database()->NumRows() == 0){
		GO(ADMIN_FILE.'?exe=forms');
	}
	$form = System::database()->FetchRow();
	$fields = unserialize($form['form_data']);
	$cnt = count($fields);
	$hname = SafeEnv($_POST['hname'], 250, str);
	$name = SafeEnv($_POST['name'], 250, str);
	$kind = '';
	$values = '';
	$savefunc = '';
	$type = '';
	// kind
	$control = SafeEnv($_POST['control'], 25, str);
	$kind .= $control;
	$width = SafeEnv($_POST['cwidth'], 11, str);
	$height = SafeEnv($_POST['cheight'], 11, str);
	$cols = SafeEnv($_POST['ccols'], 11, int);
	if($width != '' && $width != 0){
		$kind .= ':w'.$width;
	}
	if($height != '' && $height != 0){
		$kind .= ':h'.$height;
	}
	if($cols > 1){
		$kind .= ':c'.$cols;
	}
	//  values
	$getfunc = SafeEnv($_POST['valuesfunc'], 255, str);
	if($getfunc == '' || !function_exists(CONF_GET_PREFIX.$getfunc)){
		$values = SafeEnv($_POST['values'], 0, str);
	}else{
		$values = 'function:'.$getfunc;
	}
	//  Savefunc
	if(function_exists(CONF_GET_PREFIX.$_POST['savefunc'])){
		$savefunc = SafeEnv($_POST['savefunc'], 255, str);
	}else{
		$savefunc = '';
	}
	//  type
	$maxlenght = SafeEnv($_POST['maxlength'], 11, int);
	if($control == 'file'){
		$type = 'file';
	}else{
		$type = SafeEnv($_POST['datatype'], 255, str);
	}
	$striptags = 'true';
	$type = $maxlenght.','.$type.','.$striptags;
	if(isset($_GET['index'])){
		$fields[SafeEnv($_GET['index'], 11, int)] = array('hname'=>$hname, 'name'=>$name, 'kind'=>$kind, 'values'=>$values, 'savefunc'=>$savefunc, 'type'=>$type);
		Audit('Web-:   "'.$hname.'"   "'.$form['hname'].'"');
	}else{
		$fields[] = array('hname'=>$hname, 'name'=>$name, 'kind'=>$kind, 'values'=>$values, 'savefunc'=>$savefunc, 'type'=>$type);
		Audit('Web-:   "'.$hname.'"   "'.$form['hname'].'"');
	}
	$cnt = count($fields);
	$fields = serialize($fields);
	System::database()->Update('forms', "`numfields`='$cnt',`form_data`='$fields'", "`id`='$id'");
	GO(ADMIN_FILE.'?exe=forms&a=fields&id='.$id);
}

function AdminFormsEditFields(){
	AddCenterBox(' ');
	AdminFormsFieldEditor('edit');
}

function AdminFormsDelField(){
	if(!isset($_GET['id']) || !isset($_GET['index'])){
		return;
	}
	$id = SafeEnv($_GET['id'], 11, int);
	$index = SafeEnv($_GET['index'], 11, int);
	System::database()->Select('forms', "`id`='$id'");
	if(System::database()->NumQueries == 0){
		return;
	}
	$form = System::database()->FetchRow();
	$fields = unserialize($form['form_data']);

	Audit('Web-:   "'.$fields['hname'].'"   "'.$form['hname'].'"');

	unset($fields[$index]);
	$fields2 = array();
	foreach($fields as $field){
		$fields2[] = $field;
	}
	$cnt = count($fields2);
	$fields = serialize($fields2);
	System::database()->Update('forms', "`numfields`='$cnt',`form_data`='$fields'", "`id`='$id'");
	GO(ADMIN_FILE.'?exe=forms&a=fields&id='.$id);
}

function AdminFormsDelete(){
	if(isset($_GET['id'])){
		$id = SafeEnv($_GET['id'], 11, int);
		System::database()->Select('forms', "`id`='$id'");
		$form = System::database()->FetchRow();
		System::database()->Delete('forms', "`id`='$id'");
		System::database()->Delete('forms_data', "`form_id`='$id'");
		Audit('Web-:   "'.$form['hname'].'"');
	}
	GO(ADMIN_FILE.'?exe=forms');
}

function AdminFormsChangeStatus(){
	System::database()->Select('forms', "`id`='".SafeEnv($_GET['id'], 11, int)."'");
	if(System::database()->NumRows() > 0){
		$r = System::database()->FetchRow();
		if(SafeDB($r['active'], 1, int) == 1){
			$en = '0';
		}else{
			$en = '1';
		}
		System::database()->Update('forms', "active='$en'", "`id`='".SafeEnv($_GET['id'], 11, int)."'");
		Audit('Web-:    "'.$r['hname'].'"');
	}
	exit('OK');
}

function AdminFormsViewPosts( $new ){
	if(!isset($_GET['id'])){
		return;
	}
	$id = SafeEnv($_GET['id'], 11, int);
	System::database()->Select('forms', "`id`='$id'");
	$form = System::database()->FetchRow();
	$box_title = $form['hname'];
	if($new){
		$moderated = " and `moderated`='0'";
	}else{
		$moderated = '';
	}
	$posts = System::database()->Select('forms_data', "`form_id`='$id'".$moderated);
	if(count($posts) == 0){
		System::admin()->AddCenterBox(' c  "'.$box_title.'"');
		System::admin()->Highlight('  ');
		return;
	}
	$text = '';
	foreach($posts as $post){
		$time = TimeRender(SafeDB($post['time'], 11, int));
		if($post['user_id'] > 0){
			$user_info = GetUserInfo(SafeDB($post['user_id'], 11, int));
			$user_name = '<a href="'.'index.php?name=user&op=userinfo&user='.$user_info['id'].'">'.$user_info['name'].'</a>';
		}else{
			$user_name = '-';
		}
		$ip = SafeDB($post['user_ip'], 20, str);
		$data_rows = unserialize($post['data']);
		$post_text = '';
		foreach($data_rows as $row){
			$post_text .= '<b>'.SafeDB($row[0], 255, str).':</b><br />'.SafeDB($row[1], 0, str).'<br />';
		}
		$delfunc = System::admin()->SpeedConfirm('  ', ADMIN_FILE.'?exe=forms&a=delpost&id='.$id.'&pid='.SafeDB($post['id'], 11, int).'&ok=0'.($new ? '&new=1' : ''), 'images/admin/delete.png', '?');
		//'<a href="'.ADMIN_FILE.'?exe=forms&a=delpost&id='.$id.'&pid='.SafeDB($post['id'], 11, int).'&ok=0&new=1"><img src="images/admin/delete.png" title="  " /></a>';
		$text .= '<table cellspacing="0" cellpadding="0" border="0" class="cfgtable">';
		$text .= '<tr><th>: '.$time.'</td><th>: '.$user_name.'</td><th>IP: '.$ip.'</td><th width="30">'.$delfunc.'</td></tr>';
		$text .= '<tr><td colspan="4" style="text-align:left;padding-left:10px;">'.$post_text.'</td></tr>';
		$text .= '</table>';
	}
	if($new){
		$text .= '<div style="text-align: right;">'.System::admin()->SpeedButton('   ', ADMIN_FILE.'?exe=forms&a=checkall&id='.$id, '', true, true).'</div>';
	}
	AddTextBox(' c  "'.$box_title.'"', $text);
}

function AdminFormsDeletePost(){
	if(!isset($_GET['pid']) || !isset($_GET['id'])){
		GO(ADMIN_FILE.'?exe=forms');
	}
	$post_id = SafeEnv($_GET['pid'], 11, int);
	$form_id = SafeEnv($_GET['id'], 11, int);

	System::database()->Select('forms_data', "`id`='$post_id'");
	$forms_data = System::database()->FetchRow();

	System::database()->Delete('forms_data', "`id`='$post_id'");

	System::database()->Select('forms', "`id`='$form_id'");
	$form = System::database()->FetchRow();

	if($forms_data['moderated'] == '1'){
		$value1 = (int)$form['new_answ'];
	}else{
		$value1 = (int)$form['new_answ'] - 1;
	}
	$value2 = (int)$form['answ'] - 1;
	System::database()->Update('forms', "`new_answ`='$value1',`answ`='$value2'", "`id`='$form_id'");

	Audit('Web-:    "'.$form['hname'].'"');

	GO(ADMIN_FILE.'?exe=forms'.(isset($_GET['new']) ? '&a=newposts&id='.SafeEnv($_GET['id'], 11, int) : '&a=posts&id='.SafeEnv($_GET['id'], 11, int)));
}

function AdminFormsCheckAll(){
	if(!isset($_GET['id'])){
		GO(ADMIN_FILE.'?exe=forms');
	}
	$form_id = SafeEnv($_GET['id'], 11, int);
	System::database()->Select('forms', "`id`='$form_id'");
	$form = System::database()->FetchRow();
	System::database()->Update('forms_data', "moderated='1'", "`form_id`='$form_id'");
	System::database()->Update('forms', "new_answ='0'", "`id`='$form_id'");
	Audit('Web-:        "'.$form['hname'].'"');
	GO(ADMIN_FILE.'?exe=forms');
}
