<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


if(!defined('VALID_RUN')){
	header("HTTP/1.1 404 Not Found");
	exit;
}

System::admin()->AddSubTitle('');

if(!System::user()->CheckAccess2('forum', 'forum')){
	System::admin()->AccessDenied();
}

global $admin_forum_url, $forum_lang;
$admin_forum_url = ADMIN_FILE.'?exe=forum';

include MOD_DIR.'lib/functions.php';
include MOD_DIR.'lib/forum_lang.php';

if(isset($_GET['a'])) {
	$action = $_GET['a'];
}else {
	$action = 'main';
}

if(!$config['forum']['basket'] && $config['forum']['del_auto_time']){
	Forum_Basket_RestoreBasketAll();
}

TAddToolLink(' ', 'main', 'forum');
TAddToolLink(' ', 'forum_editor', 'forum&a=forum_editor');
TAddToolLink('', 'config', 'forum&a=config');
TAddToolBox($action);
if($config['forum']['basket']){
	System::admin()->SideBarAddMenuItem(' ', 'exe=forum&a=forum_basket_topics', 'forum_basket_topics');
	System::admin()->SideBarAddMenuItem(' ', 'exe=forum&a=forum_basket_posts', 'forum_basket_posts');
	System::admin()->SideBarAddMenuBlock('', $action);
}

switch($action) {
	case 'main':
	case 'ajaxtree':
		AdminForumMain();
		break;
	case 'changestatus':
		AdminForumChangeStatus();
		break;
	case 'forum_editor':
		AdminForumEditor();
		break;
	case 'forum_save':
		AdminForumSave();
		break;
	case 'delete':
		AdminForumDelete();
		break;
	case 'move':
		AdminForumMove();
		break;
	//  //////////////////////////////
	case 'config':
		System::admin()->AddCenterBox('  ""');
		if(CheckGet('saveok')){
			System::admin()->Highlight(' .');
		}
		System::admin()->ConfigGroups('forum');
		System::admin()->AddConfigsForm(ADMIN_FILE.'?exe=forum&a=configsave');
		break;
	case 'configsave':
		System::admin()->SaveConfigs('forum');
		Audit(':   ');
		GO(ADMIN_FILE.'?exe=forum&a=config&saveok');
		break;
	////////////////////////////////////////////
	//  ////////////////////////////////////
	case 'forum_basket_posts':
	case 'forum_basket_topics':
	case 'forum_basket':
		TAddSubTitle(' > ');
		switch($action) {
			////////////////// 
			case 'forum_basket_posts':
				AdminForumBasket();
				break;
			case 'forum_basket_topics':
				AdminForumBasket('forum_basket_topics');
				break;
			default:
				AdminForumBasket();
		}
		return true;
		break;
	case 'basket_restore':
		AdminForumBasketRestore();
		break;
	case 'update_user_counts':
		ForumUpdateUserCounts();
		break;
	default:
		AdminForumMain();
}

function AdminForumGetOrder( $parent_id ){
	System::database()->Select('forums', "`parent_id`='$parent_id'");
	return System::database()->NumRows();
}

function AdminForumGetElement( &$forum, &$forums, $level = 1 ){
	global $forum_lang;
	$id = SafeDB($forum['id'], 11, int);
	$editlink = ADMIN_FILE.'?exe=forum&a=forum_editor&id='.$id;
	$func = '';
	$func .= System::admin()->SpeedButton(' ', ADMIN_FILE.'?exe=forum&a=forum_editor&parent='.$id, 'images/admin/folder_add.png');
	$func .= '&nbsp;';
	$func .= System::admin()->SpeedStatus('', '', ADMIN_FILE.'?exe=forum&a=changestatus&id='.$id, $forum['status'] == '1');
	$func .= '&nbsp;';
	$func .= System::admin()->SpeedButton('', $editlink, 'images/admin/edit.png');
	$func .= System::admin()->SpeedConfirmJs(
		'',
		'$(\'#tree_container\').treeview(\'deleteNode\', '.$id.');',
		'images/admin/delete.png',
		'  ,    -  .    ?'
	);
	$view = ViewLevelToStr(SafeDB($forum['view'], 1, int));
	$description = SafeDB($forum['description'], 255, str);
	if(trim($description) == '') $description = ' .';
	$topics = SafeDB($forum['topics'], 11, int);
	$posts = SafeDB($forum['posts'], 11, int);
	$discussion = $forum['close_topic'] == 1 ? $forum_lang['close_for_discussion_admin'] : $forum_lang['on_for_discussion'];
	$link_go = Ufu('index.php?name=forum&op=showforum&forum='.$id, 'forum/{forum}/');
	$link_go = "<a href=\"$link_go\" target=\"_blank\">/$link_go</a>";

	$info = "$description<br>
		<b></b>: $topics<br>
		<b></b>: $posts<br>
		<b></b>: $view<br>
		<b></b>: $discussion<br>
		<b></b>: $link_go
		";
	if($level == 1){
		$title = System::admin()->Link(SafeDB($forum['title'], 255, str), $editlink, '', true, 'style="color: #3300FF; font-weight: bold;"');
	}elseif($level == 2){
		$title = System::admin()->Link(SafeDB($forum['title'], 255, str), $editlink, '', true, 'style="color: #0080FF; font-weight: bold;"');
	}else{
		$title = '<b>'.System::admin()->Link(SafeDB($forum['title'], 255, str), $editlink).'</b>';
	}
	$element = array(
		'id'=>$id,
		'icon'=>'images/logo16.png',
		'title'=>$title,
		'info'=>$info,
		'func'=>$func,
		'isnode'=>isset($forums[$id]),
	);
	if($forum['parent_id']==0){
		$element['opened'] = true;
		$element['childs'] = array();
	}else{
		$element['child_url'] = 'admin.php?exe=forum&a=ajaxtree&parent='.$id;
	}
	return $element;
}

function AdminForumMain(){
	UseScript('jquery_ui_treeview');
	if(CheckGet('parent')){ //   
		$parent = SafeEnv($_GET['parent'], 11, int);
		$default_level = 0;
	}else{
		$parent = 0;
		$default_level = 1;
	}
	$forumsdb = System::database()->Select('forums');
	SortArray($forumsdb, 'order');
	$forums = array();
	foreach($forumsdb as $f){
		$forums[$f['parent_id']][] = $f;
	}
	$elements = array();
	if(isset($forums[$parent])){
		foreach($forums[$parent] as $forum){
			$element = AdminForumGetElement($forum, $forums, $default_level);
			if($parent == 0 && isset($forums[$forum['id']])){
				foreach($forums[$forum['id']] as $forum){
					$element['childs'][] = AdminForumGetElement($forum, $forums, 2);
				}
			}
			$elements[] = $element;
		}
	}elseif(!CheckGet('parent')){
		AddTextBox(' ', ' .');
		return;
	}
	if($parent == 0){
		$delete_url = ADMIN_FILE.'?exe=forum&a=delete';
		$move_url = ADMIN_FILE.'?exe=forum&a=move';
		System::admin()->AddOnLoadJS('$("#tree_container").treeview({move: "'.$move_url.'", del: "'.$delete_url.'", tree: '.JsonEncode($elements).'});');
		AddTextBox(' ', '<div id="tree_container"></div>');
	}else{
		echo JsonEncode($elements);
		exit;
	}
}

function AdminForumEditor() {
	$site = System::site();

	$f_title = '';
	$f_desc = '';
	if(CheckGet('parent')){
		$f_parent = SafeDB($_GET['parent'], 11, int);
	}else{
		$f_parent = 0;
	}
	$f_view = 4;
	$f_status = 1;

	$f_admin_theme_add = array(false, false);
	$f_new_message_email = array(false, true);
	$f_no_link_guest = array(false, false);
	$rang_access = 0;
	$rang_add_theme = 0;
	$rang_message = 0;
	$close_topic = array(false, false);

	if(isset($_GET['id'])) {
		// 
		$id = SafeDB($_GET['id'], 11, int);
		System::database()->Select('forums', "`id`='$id'");
		$forum = System::database()->FetchRow();
		$f_title = SafeDB($forum['title'], 255, str);
		$f_desc = SafeDB($forum['description'], 0, str);
		$f_parent = SafeDB($forum['parent_id'], 11, int);

		$f_admin_theme_add[(int)$forum['admin_theme_add']] = true;
		$f_new_message_email[(int)$forum['new_message_email']] = true;
		$f_no_link_guest[(int)$forum['no_link_guest']] = true;
		$rang_access= SafeDB($forum['rang_access'], 11, int);
		$rang_add_theme= SafeDB($forum['rang_add_theme'], 11, int);
		$rang_message= SafeDB($forum['rang_message'], 11, int);
		$close_topic[(int)$forum['close_topic']] = true;

		$f_view = SafeDB($forum['view'], 1, int);
		$f_status = SafeDB($forum['status'], 1, int);
		$id_param = '&id='.$id;
		$b_cap = ' ';
		if($f_parent == 0) {
			$c_cap = ' ';
		}else {
			$c_cap = ' ';
		}
	}else {
		// 
		$f_title = '';

		$f_admin_theme_add[0] = true;
		$f_new_message_email[1] = true;
		$f_no_link_guest[0] = true;
		$close_topic[0] = true;

		$id_param = '';
		$b_cap = '';
		if($f_parent == 0) {
			$c_cap = ' ';
		}else {
			$c_cap = ' ';
		}
	}
	FormRow('', $site->Edit('title', $f_title, false, 'style="width:400px;" maxlength="255" class="autofocus"'));
	if($f_parent != 0){
		$where = '';
		if(isset($_GET['id'])) {
			$where = " `id`<>'".SafeEnv($_GET['id'], 11, int)."'";
		}

		$forums = System::database()->Select('forums', $where);
		$cat = false;
		if(count($forums)==0) {
			$cat = false;
		}else{
			foreach($forums as $forum){
				if($forum['parent_id'] == 0)
				$cat = true;
			}
		}
		SortArray($forums, 'order');
		$tree = ForumTree::Instance($forums);
		$tree->NumItemsCaption = '';
		$tree->TopCatName = '  ';
		$data = array();
		if($cat){
			$data = $tree->GetCatsDataF($f_parent, true, true);
		} else {
			$site->DataAdd($data, 0, $tree->TopCatName, true);
		}
		FormRow(' ', $site->Select('sub_id', $data));
		FormTextRow('', $site->HtmlEditor('desc', $f_desc, 600, 200));
	}

	System::admin()->FormTitleRow(' ');
	$endata = array();
	$site->DataAdd($endata, '1', '', $f_admin_theme_add[1]);
	$site->DataAdd($endata, '0', '', $f_admin_theme_add[0]);
	FormRow('', '     : '.$site->Select('admin_theme_add', $endata));
	$endata = array();
	$site->DataAdd($endata, '1', '', $f_no_link_guest[1]);
	$site->DataAdd($endata, '0', '', $f_no_link_guest[0]);
	FormRow('', '   : '.$site->Select('no_link_guest', $endata));
	$endata = array();
	$site->DataAdd($endata, '1', '', $f_new_message_email[1]);
	$site->DataAdd($endata, '0', '', $f_new_message_email[0]);
	FormRow('', '        : '.$site->Select('new_message_email', $endata));
	$endata = array();
	$site->DataAdd($endata, '1', '', $close_topic[1]);
	$site->DataAdd($endata, '0', '', $close_topic[0]);
	FormRow('', '   (   ): '.$site->Select('close_topic', $endata));
	System::admin()->FormTitleRow('     ');
	FormRow(' (     )',ForumAdminGetUsersTypesComboBox('rang_access', $rang_access));
	FormRow('  (      )',ForumAdminGetUsersTypesComboBox('rang_add_theme',$rang_add_theme));
	FormRow('    (      )',ForumAdminGetUsersTypesComboBox('rang_message',$rang_message));

	System::admin()->FormTitleRow(' ');
	FormRow('', $site->Select('view', GetUserTypesFormData($f_view)));
	FormRow('', $site->Select('status', GetEnData($f_status, '', '')));

	FormRow('', '        .');
	AddCenterBox($c_cap);

	AddForm($site->FormOpen(ADMIN_FILE.'?exe=forum&a=forum_save'.$id_param), $site->Submit($b_cap));
}

function AdminForumSave(){
	$f_title = SafeDB($_POST['title'], 255, str);
	$f_view = ViewLevelToInt($_POST['view']);
	$f_status = EnToInt($_POST['status']);
	$f_admin_theme_add = 0;
	$f_new_message_email = 0;
	$f_no_link_guest = 0;
	$rang_access = 0;
	$rang_message = 0;
	$close_topic = 0;
	$rang_add_theme = 0;
	if(isset($_POST['admin_theme_add'])) $f_admin_theme_add= SafeEnv($_POST['admin_theme_add'], 1, int);
	if(isset($_POST['new_message_email'])) $f_new_message_email = SafeEnv($_POST['new_message_email'], 1, int);
	if(isset($_POST['no_link_guest'])) $f_no_link_guest= SafeEnv($_POST['no_link_guest'], 1, int);
	if(isset($_POST['rang_access'])) $rang_access=SafeEnv($_POST['rang_access'], 11, int);
	if(isset($_POST['rang_message'])) $rang_message=SafeEnv($_POST['rang_message'], 11, int);
	if(isset($_POST['rang_add_theme'])) $rang_add_theme=SafeEnv($_POST['rang_add_theme'], 11, int);
	if(isset($_POST['close_topic'])) $close_topic= SafeEnv($_POST['close_topic'], 1, int);
	if(isset($_POST['desc'])) {
		$f_desc = SafeEnv($_POST['desc'], 0, str);
	}else{
		$f_desc = '';
	}
	if(isset($_POST['parent_id'])) {
		$f_parent = SafeEnv($_POST['parent_id'], 11, int);
	}else {
		$f_parent = '0';
	}
	if(isset($_POST['sub_id'])){
		$f_parent2 = SafeEnv($_POST['sub_id'], 11, int);
		$f_parent =$f_parent2;
	}else{
		$f_parent2 = '0';
	}
	if(isset($_GET['id'])) {
		// 
		$id = SafeEnv($_GET['id'], 11, int);
		$set = "`parent_id`='$f_parent',`title`='$f_title',`description`='$f_desc',`view`='$f_view',`status`='$f_status',`admin_theme_add`='$f_admin_theme_add',`no_link_guest`='$f_no_link_guest',`new_message_email`='$f_new_message_email',`rang_access`='$rang_access',`rang_message`='$rang_message',`rang_add_theme`='$rang_add_theme',`close_topic`='$close_topic'";
		System::database()->Update('forums', $set, "`id`='$id'");
		Audit(':   "'.$f_title.'"');
	}else {
		// 
		$order = AdminForumGetOrder('0');
		$values = "'','$f_parent','$f_title','$f_desc','0','0','0','0','','','0','$order','$f_status','$f_view','$f_admin_theme_add','$f_no_link_guest','$f_new_message_email', '$rang_access', '$rang_message', '$rang_add_theme','$close_topic'";
		System::database()->Insert('forums', $values);
		Audit(':   "'.$f_title.'"');
	}
	ForumCacheClear();
	GO(ADMIN_FILE.'?exe=forum');
}

function AdminForumChangeStatus(){
	$id = SafeEnv($_GET['id'], 11, int);
	System::database()->Select('forums', "`id`='$id'");
	$r = System::database()->FetchRow();
	if($r['status'] == 1) {
		$en = '0';
	}else {
		$en = '1';
	}
	System::database()->Update('forums', "status='$en'", "`id`='$id'");
	Audit(':    "'.$r['title'].'"');
	ForumCacheClear();
	if(IsAjax()){
		exit("OK");
	}
	GO(ADMIN_FILE.'?exe=forum');
}

function AdminForumDelete(){
	if(!isset($_POST['id'])){
		exit("ERROR");
	}
	$id = SafeEnv($_POST['id'], 11, int);
	System::database()->Select('forums', "`id`='$id'");
	$forum = System::database()->FetchRow();
	ForumAdminDeleteForum($id);
	Audit(':   "'.$forum['title'].'"');
	ForumCacheClear();
	exit("OK");
}

function AdminForumMove(){
	$itemId = SafeEnv($_POST['item_id'], 11, int);
	$parentId = SafeEnv($_POST['target_id'], 11, int);
	$position = SafeEnv($_POST['item_new_position'], 11, int);

	//  
	System::database()->Select('forums',"`id`='$itemId'");
	if(System::database()->NumRows() == 0){
		// Error
		exit("ERROR");
	}
	$item = System::database()->FetchRow();
	//   ,  
	if($item['parent_id'] != $parentId){
		System::database()->Update('forums', "`parent_id`='$parentId'", "`id`='$itemId'");
	}
	//   
	$indexes = array(); //    id 
	$items = System::database()->Select('forums', "`parent_id`='$parentId'");
	if($position == -1){
		$position = count($items);
	}
	SortArray($items, 'order');
	$i = 0;
	foreach($items as $p){
		if($p['id'] == $itemId){
			$indexes[$p['id']] = $position;
		}else{
			if($i == $position) $i++;
			$indexes[$p['id']] = $i;
			$i++;
		}
	}
	//  
	foreach($indexes as $id=>$order){
		System::database()->Update('forums', "`order`='$order'", "`id`='$id'");
	}
	Audit(':   "'.$item['title'].'"');
	ForumCacheClear();
	exit("OK");
}

/***********************************/
function AdminForumBasket( $table = 'forum_basket_post' ){
	global $config, $site;

	if(isset($_GET['page'])) {
		$page = SafeEnv($_GET['page'],10,int);
	}else {
		$page = 1;
	}

	if($table == 'forum_basket_post'){
		$site->Title .= ' >  ';
		$caption =  ' ';
	}else{
		$site->Title .= ' >  ';
		$caption =  ' ';
	}

	$result = System::database()->Select($table);

	if(count($result)>20){
		$navigator = new Navigation($page);
		$navigator->GenNavigationMenu($result, 20, ADMIN_FILE.'?exe=forum&a='.$table);
		$nav = true;
	}else{
		$nav = false;

	}

	$mop = 'showtopic&topic=';

	if($table == 'forum_basket_post'){
		$table_caption = ' ()';
		if(count($result) > 0){
			$mposts = array();
			$where = '';
			foreach($result as $mpost){
				$where .= "`id`='".$mpost['obj_id']."' or ";
			}
			$where = substr($where, 0, strlen($where) - 3);
			$result_posts = System::database()->Select('forum_posts', $where);
			if(count($result_posts)>0){
				foreach($result_posts as $mpost){
					$mposts[$mpost['id']] = $mpost['object'];
					$mpostsm[$mpost['id']] = $mpost['message'];
				}
				foreach($result as $mpost){
					$mpost['obj_id2'] = $mposts[$mpost['obj_id']];
					$mpost['obj_id'] = $mpost['obj_id'] ;
					$mpost['date'] = $mpost['date'] ;
					$mpost['user'] =  $mpost['user'] ;
					$mpost['reason'] = $mpost['reason'] ;
					$mpost['message'] = $mpostsm[$mpost['obj_id']];
					$result2[] = $mpost;
				}
				$result = $result2;
			}
		}
	}else{
		$table_caption = ' ( )';
		if(count($result) > 0){
			$where = '';
			foreach($result as $mpost){
				$where .= "`id`='".$mpost['obj_id']."' or ";
			}
			$where = substr($where, 0, strlen($where) - 3);
			$result_topics = System::database()->Select('forum_topics', $where);
			if(count($result_topics)>0) {
				foreach($result_topics as $mtopic){
					$mtopics[$mtopic['id']] = $mtopic['title'];
				}
				foreach($result as $mtopic){
					$mpost['obj_id'] = $mtopic['obj_id'];
					$mpost['date'] = $mtopic['date'];
					$mpost['user'] = $mtopic['user'];
					$mpost['reason'] = $mtopic['reason'];
					$mpost['message'] = $mtopics[$mtopic['obj_id']];
					$result2[] = $mpost;
				}
				$result =  $result2;
			}
		}
	}

	$text = '<table cellspacing="0" cellpadding="0" class="cfgtable">';
	$text .= '<tr><th> </th><th> </th><th>  </th><th></th><th>  <BR>'. $table_caption.'</th><th></th></tr>';
	foreach($result as $basket){
		$mop = 'showtopic&topic='.($table == 'forum_basket_post' ? $basket['obj_id2'] : $basket['obj_id']);
		$restore_link = ADMIN_FILE.'?exe=forum&a=basket_restore&'.$table.'='.$basket['obj_id'];
		$ainfo = GetUserInfo($basket['user']);
		$text .= '<tr>
		<td>'.$ainfo['name'].'</td>
		<td>'.TimeRender($basket['date'], false, false).'</td>
		<td>'.TimeRender($basket['date']+(86400*$config['forum']['clear_basket_day']), false, false).'</td>
		<td>'.$basket['reason'].'</td>
		<td>'.(isset($basket['message']) ? $basket['message'] : '').'</td>
		<td><a href="'.$restore_link.'"></a>
		&nbsp;<a href="index.php?name=forum&op='.$mop.'" target="_blank"></a></td>
		</tr>';
	}
	$text .= '</table>';
	AddTextBox($caption , $text);
	if($nav){
		AddNavigation();
	}
}

function AdminForumBasketRestore(){
	ForumLoadFunction('restore_basket');
	if(isset($_GET['forum_basket_post'])){
		IndexForumRestoreBasketPost(SafeEnv($_GET['forum_basket_post'], 11, int));
		Audit(':    ');
	}elseif(isset($_GET['forum_basket_topics'])){
		IndexForumRestoreBasketTopic(SafeEnv($_GET['forum_basket_topics'], 11, int));
		Audit(':    ');
	}
}
