<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */

//     (,  ).

function IndexForumEditPosts(){
	global $forum_lang;
	if(!System::user()->isAdmin()){
		System::site()->AddTextBox($forum_lang['forum'], '<p align="center">'.$forum_lang['error_no_right_edit'].'.</p>');
		return;
	}
	if(!isset($_POST['posts'])){
		System::site()->AddTextBox($forum_lang['forum'], '<p align="center">'.$forum_lang['error_no_messages'].'</p><br><a href="javascript:history.go(-1)">'.System::site()->Button($forum_lang['back']).'</a>');
		return;
	}
	if(isset($_GET['ok']) && $_GET['ok'] == '1'){
		$posts_ids = SafeEnv(explode(',', $_POST['posts']), 11, int);
		$moderation_result = ForumModerationPosts($_GET['edit'], $posts_ids, true);
		if($moderation_result){
			if(isset($_GET['back'])){
				GoRefererUrl($_GET['back']);
			}
			else{
				GO($_POST['backurl']);
			}
		}
	}
	else{
		$posts_ids = array();
		foreach( array_keys($_POST['posts']) as $post_id ){
			$posts_ids[] = SafeEnv($post_id, 11, int);
		}

		$do = SafeDB($_POST['do'], 255, str);

		$form_url = 'index.php?name=forum&op=edit_posts&edit='.$do.'&ok=1';
		if(isset($_GET['back'])){
			$form_url .= '&back='.SafeDB($_GET['back'], 10, str);
		}

		$vars['lang_premoderation'] = $forum_lang['moderation_messages'];
		$vars['posts_count'] = count($posts_ids);
		$vars['form_action'] = $form_url;
		$vars['form_name'] = 'forum_delete';
		$vars['posts'] = implode(',', $posts_ids);
		$vars['backurl'] = $_SERVER['HTTP_REFERER'];
		$vars['reason'] = System::config('forum/basket') && $do == 'deleteposts';

		$vars['lang_do'] = ForumModerationPosts($do, $posts_ids, false);

		System::site()->AddTemplatedBox($vars['lang_do'], 'module/forum_moderation.html');
		System::site()->AddBlock('forum_moderation', true, false, 'mod');
		System::site()->SetVars('forum_moderation', $vars);
	}
}

function ForumModerationPosts( $do, $posts, $begin ){
	switch($do){
		case 'deleteposts': return ForumModerationDeletePosts($posts, $begin);
		case 'mergeposts': return ForumModerationMergePosts($posts, $begin);
	}
}

function ForumModerationDeletePosts( $posts, $begin ){
	global $forum_lang;
	if(!$begin){
		return $forum_lang['delete_posts'];
	}

	$posts = System::database()->Select('forum_posts', '`id`=\''.implode('\' or `id`=\'', $posts).'\'');

	$deleted_posts = 0;
	$topic_id = null;
	$forum_id = null;
	$topic = null;
	$forum = null;

	foreach( $posts as $post ){
		$post_id = SafeEnv($post['id'], 11, int);
		if($post['delete'] == '1'){ //  
			continue;
		}

		if(!isset($topic)){
			// 
			$topic_id = SafeEnv($post['object'], 11, int);
			System::database()->Select('forum_topics', "`id`='$topic_id'");
			if(System::database()->NumRows() == 0){
				System::site()->AddTextBox($forum_lang['error'], $forum_lang['error_no_topic']);
				return false;
			}
			$topic = System::database()->FetchRow();
			if($topic['delete'] == '1'){ //   
				System::site()->AddTextBox($forum_lang['error'], $forum_lang['topic_basket']);
				return false;
			}
			// 
			$forum_id = SafeEnv($topic['forum_id'], 11, int);
			System::database()->Select('forums', "`id`='$forum_id'");
			if(System::database()->NumRows() == 0){
				System::site()->AddTextBox($forum_lang['error'], $forum_lang['error_no_forum']);
				return false;
			}
			$forum = System::database()->FetchRow();
		}

		$deleted_posts++;

		//  
		if(System::config('forum/basket')){//    
			$reason = '';
			if(isset($_POST['text'])){
				$reason = SafeEnv($_POST['text'], 255, str);
			}
			Moderation_Do_Basket_Post($post_id, $reason);
		}else{
			ForumAdminDeletePost($post_id);
		}
	}

	if($deleted_posts > 0){
		//  
		$topic_posts = (int)$topic['posts'] - $deleted_posts;
		if($topic_posts < 0){
			$topic_posts = 0;
		}
		$topic_set = "`posts`='$topic_posts'";
		ForumSetLastPost($topic_id, $topic_set);

		//  
		$forum_posts = (int)$forum['posts'] - $deleted_posts;
		if($forum_posts < 0){
			$forum_posts = 0;
		}
		$forum_set = "`posts`='$forum_posts'";
		ForumSetLastTopic($forum_id, $forum_set);
	}
	ForumCacheClear();
	return true;
}

function ForumModerationMergePosts( $posts, $begin ){
	global $forum_lang;
	if(!$begin){
		return $forum_lang['merge_posts'];
	}

	$posts = System::database()->Select('forum_posts', '(`id`=\''.implode('\' or `id`=\'', $posts).'\') and `delete`=\'0\'');
	$merged_posts = count($posts);
	if($merged_posts < 2){
		return false;
	}
	SortArray($posts, 'public', false);
	$post = $posts[0];

	// 
	$topic_id = SafeEnv($post['object'], 11, int);
	System::database()->Select('forum_topics', "`id`='$topic_id'");
	if(System::database()->NumRows() == 0){
		System::site()->AddTextBox($forum_lang['error'], $forum_lang['error_no_topic']);
		return false;
	}
	$topic = System::database()->FetchRow();
	if($topic['delete'] == '1'){ //   
		System::site()->AddTextBox($forum_lang['error'], $forum_lang['topic_basket']);
		return false;
	}
	// 
	$forum_id = SafeEnv($topic['forum_id'], 11, int);
	System::database()->Select('forums', "`id`='$forum_id'");
	if(System::database()->NumRows() == 0){
		System::site()->AddTextBox($forum_lang['error'], $forum_lang['error_no_forum']);
		return false;
	}
	$forum = System::database()->FetchRow();

	//     
	$new_post_message = '';
	$where = '';
	foreach( $posts as $p ){
		if($new_post_message <> ''){
			$where .= "`id`='".SafeEnv($p['id'], 11, int)."' or ";
		}
		$new_post_message .= $p['message']."\r\n\r\n";
	}
	$new_post_message = SafeEnv($new_post_message, 0, str);
	$post_id = SafeEnv($post['id'], 11, int);
	System::database()->Update('forum_posts', "`message`='$new_post_message'", "`id`='$post_id'");
	$where = substr($where, 0, strlen($where) - 4);
	if($where <> ''){
		System::database()->Delete('forum_posts', $where);
	}

	if($merged_posts >= 2){
		//  
		$topic_posts = (int)$topic['posts'] - ($merged_posts - 1);
		if($topic_posts < 0){
			$topic_posts = 0;
		}
		$topic_set = "`posts`='$topic_posts'";
		ForumSetLastPost($topic_id, $topic_set);

		//  
		$forum_posts = (int)$forum['posts'] - ($merged_posts - 1);
		if($forum_posts < 0){
			$forum_posts = 0;
		}
		$forum_set = "`posts`='$forum_posts'";
		ForumSetLastTopic($forum_id, $forum_set);
	}

	ForumCacheClear();
	return true;
}
