<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */

//    

function IndexForumLastTopics(){
	global $forum_lang;

	$forums_tree = ForumTree::Instance();

	//    GET
	if(isset($_GET['forum'])){
		$forum_id = SafeEnv($_GET['forum'], 11, int);
		if(isset($forums_tree->IdCats[$forum_id])){ //       
			//$forum = $forums_tree->IdCats[$forum_id]; // 
			$forum_config = $forums_tree->GetForumConfigRecursive($forum_id); //   
			//  
			if(!$forum_config['access']){
				System::site()->AddTextBox($forum_lang['error'], $forum_config['access_reason']); //     
				return;
			}
		}else{
			System::site()->AddTextBox($forum_lang['error'], $forum_lang['error_no_forum']); //   
			return;
		}
	}else{
		$forum_id = 0;
	}

	//   ( )
	if(isset($_GET['day'])){
		$period_days = SafeDB($_GET['day'], 3, int);
		$str_time = (string)$period_days; //        (    )
		$period_start_time = IndexForumLastTopics_PeriodToTime($period_days); // timestamp    n 
		if(strlen($str_time) > 0){
			$str_time = $forum_lang['za'].$str_time.' '.$forum_lang['day'][$str_time[strlen($str_time)-1]]; //  N 
		}else{
			$str_time = $forum_lang['za'].' '.$forum_lang['day']['1'];//  1 
		}
	}else{
		$period_days = 1;
		$str_time = $forum_lang['za'].' '.$forum_lang['day'][$period_days];
		$period_start_time = IndexForumLastTopics_PeriodToTime(1);
	}

	//   
	if(isset($_GET['page'])){
		$page = SafeEnv($_GET['page'], 11, int);
	}else{
		$page = 1;
	}
	$topics_on_page = System::config('forum/topics_on_page');

	$function_title = $forum_lang['lasttopicstitle'].$str_time;

	//   
	System::site()->SetTitle($function_title.' - '.($page > 1 ? $forum_lang['page'].$page.' - ' : '').$forum_lang['forum']);

	//       
	$forum_url = Ufu(
		'index.php?name=forum&op=lasttopics'.($forum_id > 0 ? '&forum='.$forum_id : '').(isset($_GET['day']) ? '&day='.$period_days: ''),
		'forum/lasttopics/'.($forum_id > 0 ? '{forum}/' : '').(isset($_GET['day']) ? 'day{day}/': '')
	);
	$forum_nav_url = Ufu(
		'index.php?name=forum&op=lasttopics'.($forum_id > 0 ? '&forum='.$forum_id : '').(isset($_GET['day']) ? '&day='.$period_days: '').'&page='.$page,
		'forum/lasttopics/'.($forum_id > 0 ? '{forum}/' : '').(isset($_GET['day']) ? 'day{day}/': '').'page{page}',
		true
	);

	//  
	if($forum_id > 0){
		$forums_tree->BreadCrumbsF($forum_id);
	}
	System::site()->BreadCrumbAdd($function_title, $forum_url);

	//    
	$statistics = ForumStatistics::Instance();
	$online = ForumOnline::Instance('0', '0', true);

	//  
	$statistics->Initialize($forum_lang['statistics_cat']);

	$auth = System::user()->Auth;
	$user_id = System::user()->Get('u_id');
	$is_admin = System::user()->isAdmin();

	//      
	$basket = ForumBasketGetData('forum_basket_topics');

	//      $topics_data    ( )
	$topics_data = ForumCacheGetTopics(); //    (  )
	$topics = array(); //      
	$resolve_cats = $forums_tree->GetAllAccessForumId($forum_id); //       
	foreach($resolve_cats as $resolve_cat){
		if(!isset($topics_data[$resolve_cat])) continue;
		foreach($topics_data[$resolve_cat] as $topic){
			//     
			if($topic['start_date'] > $period_start_time){
				//    ,     
				$topic['status'] = '';
				$topic['show_delete'] = $is_admin;
				if($topic['delete'] && isset($basket[$topic['id']]) && $auth && ($is_admin || $topic['starter_id'] == $user_id)){
					//   - "  "
					$topic['status'] = ForumBasketRender($topic['id'], $topic['title'], $basket, false);
					$topic['show_delete'] = false;
				}elseif($topic['delete']){
					continue; //         
				}
				$statistics->hits += $topic['hits'];
				$statistics->AddTopicAuthor($topic['starter_id'], $topic['starter_name']);
				$statistics->topics_count += 1;
				$statistics->reply_count += $topic['posts'];
				$topics[] = $topic;
			}
		}
	}
	unset($topics_data);

	//  (, , )
	System::site()->AddBlock('statistik', true, false, 'stat');
	System::site()->SetVars('statistik', array('count_read' => ''));

	//   
	System::site()->AddBlock('topic_form', false, false, 'form');
	System::site()->AddBlock('topic_right', false, false, 'topic');
	System::site()->AddBlock('forum', false);
	System::site()->AddBlock('forum_guest_message', false);

	//  
	// ,          .
	$vars_is_forum_member = array();
	$vars_is_forum_member['url'] = '<a href="'.Ufu('index.php?name=forum&op=markread'.($forum_id > 0 ? '&forum='.$forum_id : ''), 'forum/markread/'.($forum_id > 0 ? '{forum}/' : '')).'">'.$forum_lang['mark_all_read'].'</a>';
	$vars_is_forum_member['viewnoreadurl'] = '<a href="'.Ufu('index.php?name=forum&op=viewnoread'.($forum_id > 0 ? '&forum='.$forum_id : ''), 'forum/viewnoread/'.($forum_id > 0 ? '{forum}/' : '')).'">'.$forum_lang['viewnoread'].'</a>';
	$vars_is_forum_member['forum_id'] = $forum_id;
	if(!System::site()->HasBlock('is_forum_member')){
		System::site()->AddBlock('is_forum_member', AccessIsResolved(2), false, 'mark');
	}
	System::site()->SetVars('is_forum_member', $vars_is_forum_member);

	//   
	System::site()->AddBlock('old', true, false, 'mark');
	$vars_old = array();
	$vars_old['lasttopics'] = '<a href="'.$forum_url.'">'.$forum_lang['lasttopics'].'</a>';
	System::site()->SetVars('old', $vars_old);

	//   
	System::site()->AddBlock('topics', true, true, 'topic');

	//   
	$navigation = new Navigation($page);
	$navigation->FrendlyUrl = System::config('general/ufu');

	//    
	if(count($topics) == 0){ //        
		System::site()->AddBlock('no_topics', true);
		$navigation->DisableNavigation();
	}else{
		//   
		$navigation->GenNavigationMenu($topics, $topics_on_page, $forum_nav_url);

		$visable_topics = false;

		//     
		$read_data = Forum_Marker_GetReadData();

		//        
		foreach($topics as $topic){

			$forum_config = $forums_tree->GetForumConfigRecursive($topic['forum_id']); //   

			//  
			$read = true; // 
			if($auth && (!isset($read_data[$topic['id']]) || $topic['last_post'] > $read_data[$topic['id']]['date'])){
				$read = false;
			}

			$topic = ForumTopicFilterData($topic); //   

			$topic['on'] = !$read;
			$topic['off'] = $read;

			if(!$topic['close']){
				$topic['close'] = $forum_config['close'];
				$topic['begin'] = !$forum_config['close'];
			}

			$topic['page'] = $page;

			$visable_topics = true;
			System::site()->AddSubBlock('topics', true, $topic);
		}
		System::site()->AddBlock('no_topics', !$visable_topics);
	}

	//  
	ModerationForumTopicsBlocks();

	//  
	System::site()->AddTemplatedBox('', 'module/forum_topics.html');

	//   
	$online->Render($forum_id, '0', ($forum_id == 0 ? $forum_lang['all_online'] : $forum_lang['current_category']), 'forum_topics_online');

	//  
	$statistics->Render('forum_topics_statistics');

	//     
	ForumQuickTransitionBox(0, $forum_lang['quick_transition'], IndexForumLastTopics_Periods($period_days, $forum_id));
}

/**
 *      .
 * @param type $int
 * @return type
 */
function IndexForumLastTopics_PeriodToTime( $int = 1 ){
	$int = intval($int);
	if($int > 0){
		return time() - ($int * Day2Sec);
	}else{
		return time() - Day2Sec;
	}
}

function IndexForumLastTopics_Periods( $day, $forum_id = -1 ) {
	global $forum_lang;
	$periods = array('1', '2', '3', '4', '5', '6', '7', '14', '21', '30', '60', '90', '120', '150', '180', '365');
	$select = '';
	foreach($periods as $p){
		$select .= '<option value="'.$p.'" '.($day == $p ? 'selected="selected"' : '').'>'.$forum_lang['viewlasttopics'.$p].'</option>';
	}
	$text = Indent('
		<div style="float:left;" class="forum_period">
			<table cellspacing="0" cellpadding="0" border="0">
			<tr>
				<th>:&nbsp;</th>
				<td>
					<form name="day" action="index.php?name=forum&op=lasttopics'.($forum_id > 0 ? '&forum='.$forum_id.'' : '').'" method="get">
						<input type="hidden" name="name" value="forum">
						'.($forum_id > 0 ? '<input type="hidden" name="forum" value="'.$forum_id.'">' : '').'
						<input type="hidden" name="op" value="lasttopics">
						<select name="day" onchange="this.form.submit();">
							'.$select.'
						</select>
					</form>
				</td>
			</tr>
			</table>
		</div>
	');
	return $text;
}
