<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


/**
 *   ,        .
 * @param int   $cat_id   
 * @global type $forum_lang
 * @return type
 */
function IndexForumMain( $cat_id = null, &$topics_data = null ){
	global $forum_lang;

	$forums_tree = ForumTree::Instance();

	if(isset($cat_id)){
		$parent = $forums_tree->IdCats[$cat_id]['parent_id']; //           
		$cat = $parent == 0; //      
		$main = false; //    (   )
	}else{
		$cat = true; //        (    )
		$cat_id = 0;
		$parent = 0; //      
		$main = true; //  
	}

	//  ,  
	if(!isset($forums_tree->Cats[$parent]) && $cat){
		System::site()->AddTextBox($forum_lang['forum'], $forum_lang['no_category']);
		return;
	}

	if($cat){ //       ( )

		//   
		if(!$main){
			System::site()->SetTitle(SafeDB($forums_tree->IdCats[$cat_id]['title'], 255, str).' - '.$forum_lang['forum']);
		}

		//    
		$statistics = ForumStatistics::Instance();
		$online = ForumOnline::Instance($cat_id, '0', true);

		//  
		$statistics->Initialize($forum_lang['statistics']);

		//      $topics_data    ( )
		$topics_data = ForumCacheGetTopics(); //    (  )
		$resolve_cats = array_keys($topics_data);
		foreach($resolve_cats as $resolve_cat){
			if(!isset($topics_data[$resolve_cat])) continue;
			foreach($topics_data[$resolve_cat] as $topic){
				$statistics->hits += $topic['hits'];
				$statistics->AddTopicAuthor($topic['starter_id'], $topic['starter_name']);
			}
		}

		//     
		$counters = $forums_tree->GetCountersRecursive($cat_id);
		$statistics->topics_count = $counters['files'];
		$statistics->reply_count = $counters['cats'];

		//   
		$forums_tree->BreadCrumbsF($cat_id);
		System::site()->BreadCrumbsLastUrl = true;

		// ,          .
		System::site()->AddBlock('is_forum_member', AccessIsResolved(2), false, 'mark');
		$vars_is_forum_member = array();
		$vars_is_forum_member['url'] = '<a href="'.Ufu('index.php?name=forum&op=markread', 'forum/markread/').'">'.$forum_lang['mark_all_read'].'</a>';
		$vars_is_forum_member['viewnoreadurl'] = '<a href="'.Ufu('index.php?name=forum&op=viewnoread', 'forum/viewnoread/').'">'.$forum_lang['viewnoread'].'</a>';
		System::site()->Blocks['is_forum_member']['vars'] = $vars_is_forum_member;

		//   
		System::site()->AddBlock('old', true, false, 'mark');
		$vars_old = array();
		$vars_old['lasttopics'] = '<a href="'.Ufu('index.php?name=forum&op=lasttopics', 'forum/lasttopics/').'">'.$forum_lang['lasttopics'].'</a>';
		System::site()->Blocks['old']['vars'] = $vars_old;
	}

	//     
	$read_data = Forum_Marker_GetReadData();
	$auth = System::user()->Auth;

	//  
	System::site()->AddBlock('forums', true, true, 'forum');
	System::site()->AddBlock('is_no_sub_forum', $cat, false); //      (  )

	$visable_cats = false; //       -     

	foreach($forums_tree->Cats[$parent] as $category){ // 
		if(!$main && ($category['id'] <> $cat_id || !isset($forums_tree->Cats[$category['id']]))){ //     
			continue;
		}

		//   
		$forum_config = $forums_tree->GetForumConfigRecursive($category['id']);

		//        
		if(!$forum_config['access']){
			continue;
		}

		$visable_cats = true;

		$category = IndexForumDataFilter($category, $forum_config);

		//  
		IndexForumCatOpen($category);
		IndexForumRender($category);

		//  
		foreach($forums_tree->Cats[$category['id']] as $forum){
			$forum_id = $forum['id'];
			$forum_config = $forums_tree->GetForumConfigRecursive($forum_id);

			//        
			if(!$forum_config['access']){
				continue;
			}

			$forum = IndexForumDataFilter($forum, $forum_config);

			//  
			$subforums = array();
			if(isset($forums_tree->Cats[$forum_id])){
				foreach($forums_tree->Cats[$forum_id] as $sforum){
					// ,        
					$read = true; // 
					if($auth){
						$childs_forums = $forums_tree->GetAllChildId($sforum['id']);
						foreach($childs_forums as $child_forum_id){
							if(!isset($topics_data[$child_forum_id])) continue;
							foreach($topics_data[$child_forum_id] as $topic){
								if(!isset($read_data[$topic['id']]) || $topic['last_post'] > $read_data[$topic['id']]['date']){
									$read = false; //  
									break;
								}
							}
							if(!$read) break;
						}
					}
					$sforum = IndexForumDataFilter($sforum);
					$sforum['read'] = $read;
					$subforums[] = $sforum;
				}
			}

			//   ""  
			$read = true; // 
			if($auth){
				$childs_forums = $forums_tree->GetAllChildId($forum_id);
				foreach($childs_forums as $child_forum_id){
					if(!isset($topics_data[$child_forum_id])) continue;
					foreach($topics_data[$child_forum_id] as $topic){
						if(!isset($read_data[$topic['id']]) || $topic['last_post'] > $read_data[$topic['id']]['date']){
							$read = false; //  
							break;
						}
					}
					if(!$read) break;
				}
			}

			//    
			IndexForumRender($forum, false, $read, $subforums);
		}
		//  
		IndexForumCatClose($category);
	}

	if($visable_cats){
		//   (   ,    PHP )
		System::site()->AddTemplatedBox('', 'module/forums.html');
	}

	if($cat){ //     ( + )

		if(!$visable_cats){
			System::site()->AddTextBox($forum_lang['forum'], $forum_lang['no_category']);
			return;
		}

		//   
		$online->Render($cat_id, '0', ($cat_id == 0 ? $forum_lang['all_online'] : $forum_lang['current_category']));

		//  
		$statistics->Render();

		//  
		if(!$cat){
			ForumQuickTransitionBox($cat_id, $forum_lang['quick_transition']);
		}
	}
}
