<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */

//  , ,  

function IndexForumShowForum(){
	global $forum_lang;

	$forums_tree = ForumTree::Instance();

	//    GET
	// $forum_id
	// $forum
	// $forum_config
	if(isset($_GET['forum'])){
		$forum_id = SafeEnv($_GET['forum'], 11, int);
		if(isset($forums_tree->IdCats[$forum_id])){ //       
			$forum = $forums_tree->IdCats[$forum_id]; // 
			$forum_config = $forums_tree->GetForumConfigRecursive($forum_id); //   
		}else{
			System::site()->AddTextBox($forum_lang['error'], $forum_lang['error_no_forum']); //   
			return;
		}
	}else{
		System::site()->AddTextBox($forum_lang['error'], $forum_lang['error_no_forum']); //  
		return;
	}

	//  
	if(!$forum_config['access']){
		System::site()->AddTextBox($forum_lang['error'], $forum_config['access_reason']); //     
		return;
	}

	//   
	if(isset($_GET['page'])){
		$page = SafeEnv($_GET['page'], 11, int);
	}else{
		$page = 1;
	}
	$topics_on_page = System::config('forum/topics_on_page');

	//   
	System::site()->SetTitle(SafeDB($forum['title'], 255, str).' - '.($page > 1 ? $forum_lang['page'].$page.' - ' : '').$forum_lang['forum']);

	//    
	$statistics = ForumStatistics::Instance();
	$online = ForumOnline::Instance($forum_id);

	//  
	$statistics->Initialize($forum_lang['statistics_cat']);

	//      $topics_data    ( )
	$topics_data = ForumCacheGetTopics(); //    (  )
	$resolve_cats = $forums_tree->GetAllChildId($forum_id); //        
	foreach($resolve_cats as $resolve_cat){
		if(!isset($topics_data[$resolve_cat])) continue;
		foreach($topics_data[$resolve_cat] as $topic){
			$statistics->hits += $topic['hits'];
			$statistics->AddTopicAuthor($topic['starter_id'], $topic['starter_name']);
		}
	}

	//     
	$counters = $forums_tree->GetCountersRecursive($forum_id);
	$statistics->topics_count = $counters['files'];
	$statistics->reply_count = $counters['cats'];

	//      main ( )
	if(isset($forums_tree->Cats[$forum_id]) && count($forums_tree->Cats[$forum_id]) > 0){
		ForumLoadFunction('main');
		IndexForumMain($forum_id, $topics_data); // <-- IndexForumMain
		//   ,    
		if($forum['parent_id'] == 0){
			return;
		}
	}

	//    (  IndexForumMain        )
	$forums_tree->BreadCrumbsF($forum_id);

	//  
	// ,          .
	$vars_is_forum_member = array();
	$vars_is_forum_member['url'] = '<a href="'.Ufu('index.php?name=forum&op=markread'.($forum_id > 0 ? '&forum='.$forum_id : ''), 'forum/markread/'.($forum_id > 0 ? '{forum}/' : '')).'">'.$forum_lang['mark_all_read'].'</a>';
	$vars_is_forum_member['viewnoreadurl'] = '<a href="'.Ufu('index.php?name=forum&op=viewnoread'.($forum_id > 0 ? '&forum='.$forum_id : ''), 'forum/viewnoread/'.($forum_id > 0 ? '{forum}/' : '')).'">'.$forum_lang['viewnoread'].'</a>';
	$vars_is_forum_member['forum_id'] = $forum_id;
	if(!System::site()->HasBlock('is_forum_member')){
		System::site()->AddBlock('is_forum_member', AccessIsResolved(2), false, 'mark');
	}
	System::site()->SetVars('is_forum_member', $vars_is_forum_member);

	//   
	System::site()->AddBlock('old', true, false, 'mark');
	$vars_old = array();
	$vars_old['lasttopics'] = '<a href="'.Ufu('index.php?name=forum&op=lasttopics&forum='.$forum_id, 'forum/lasttopics/{forum}/').'">'.$forum_lang['lasttopics'].'</a>';
	System::site()->SetVars('old', $vars_old);

	//  (, , )
	System::site()->AddBlock('statistik', true, false, 'stat');
	$vars_stat = array();
	$vars_stat['count_read'] = '';
	$cat_users_count = $online->GetCatOnlineCount($forum_id);
	if($cat_users_count > 0){
		$vars_stat['count_read'] = ($cat_users_count > 0 ? '<small> ('.$forum_lang['online'].': '.$cat_users_count.')</small>' : '');
	}
	System::site()->SetVars('statistik', $vars_stat);

	//     
	System::site()->AddBlock('forum', true, false);
	System::site()->SetVars('forum', IndexForumDataFilter($forum, $forum_config));
	System::site()->AddBlock('forum_guest_message', true);

	//   
	System::site()->AddBlock('topics', true, true, 'topic');

	//   
	$navigation = new Navigation($page);
	$navigation->FrendlyUrl = System::config('general/ufu');

	//      
	$visable_topics = false;
	$auth = System::user()->Auth;
	$user_id = System::user()->Get('u_id');
	$is_admin = System::user()->isAdmin();

	if(!isset($topics_data[$forum_id]) || count($topics_data[$forum_id]) == 0){ //        
		System::site()->AddBlock('no_topics', true);
		$navigation->DisableNavigation();
	}else{

		//      
		$basket = ForumBasketGetData('forum_basket_topics');

		//     
		$read_data = Forum_Marker_GetReadData();

		//  
		$topics_data = $topics_data[$forum_id]; //    
		$topics = array();
		foreach($topics_data as $topic){
			//    ,      (      -  )
			$topic['status'] = '';
			$topic['show_delete'] = $is_admin;
			if($topic['delete'] && isset($basket[$topic['id']]) && $auth && ($is_admin || $topic['starter_id'] == $user_id)){
				//   - "  "
				$topic['status'] = ForumBasketRender($topic['id'], $topic['title'], $basket, false);
				$topic['show_delete'] = false;
			}elseif($topic['delete']){
				continue; //         
			}
			$topics[] = $topic;
		}
		unset($topics_data);

		//   
		$navigation->GenNavigationMenu($topics, $topics_on_page, Ufu('index.php?name=forum&op=showforum&forum='.$forum_id, 'forum/{forum}-{page}/', true));

		//        
		foreach($topics as $topic){

			$close = false;
			if($forum_config['close']){
				$close = true;
			}

			//  
			$read = true; // 
			if($auth && (!isset($read_data[$topic['id']]) || $topic['last_post'] > $read_data[$topic['id']]['date'])){
				$read = false;
			}

			$topic = ForumTopicFilterData($topic); //   

			$topic['on'] = !$read;
			$topic['off'] = $read;

			//    
			if(!$topic['close']){
				$topic['close'] = $forum_config['close'];
				$topic['begin'] = !$forum_config['close'];
			}

			$topic['page'] = $page;

			$visable_topics = true;
			System::site()->AddSubBlock('topics', true, $topic);
		}
		System::site()->AddBlock('no_topics', !$visable_topics);
	}

	//   
	$show_form = $forum_config['add_topic'] && $auth;
	System::site()->AddBlock('topic_form', $show_form, false, 'form');
	if($show_form){
		System::site()->SetVar('topic_form', 'url', Ufu('index.php?name=forum&op=addtopic&forum='.$forum_id, 'forum/addtopic/{forum}/'));
		ForumSmiliesRender();
		//  BBCode 
		IncludePluginsGroup('bbcode_editors');
	}

	//  "  "
	System::site()->AddBlock('topic_right', true, false, 'topic', 'module/forum_right.html');
	$right_text = '';
	if($forum_config['add_topic']){
		$right_text .= $forum_lang['create_new_topics'].'<br />';
	}else{
		$right_text .= $forum_lang['no_create_new_topics'].'<br />';
		$right_text .= '('.$forum_config['add_topic_reason'].')<br />';
	}
	if($forum_config['add_post']){
		$right_text .= $forum_lang['create_new_message_in_topics'].'<br />';
	}else{
		$right_text .= $forum_lang['no_create_new_message_in_topics'].'<br />';
		$right_text .= '('.$forum_config['add_post_reason'].')<br />';
	}
	System::site()->SetVars('topic_right', array('right' => $right_text));

	//  
	ModerationForumTopicsBlocks();

	//  
	System::site()->AddTemplatedBox('', 'module/forum_topics.html');

	//   
	$online->Render($forum_id, '0', $forum_lang['current_category'], 'forum_topics_online');

	//  
	$statistics->Render('forum_topics_statistics');

	//    
	ForumQuickTransitionBox($forum_id, $forum_lang['quick_transition']);
}