<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */

//      .

function IndexForumShowTopic( $one_post = false ){
	global $forum_lang;

	$forums_tree = ForumTree::Instance();

	//  
	$user_auth = System::user()->Auth;
	$user_id = System::user()->Get('u_id');
	$user_admin = System::user()->isAdmin();
	$time = time();
	$max_word_length = System::config('forum/max_word_length');

	if(isset($_GET['topic'])){
		$topic_id = SafeEnv($_GET['topic'], 11, int);
	}else{
		System::site()->AddTextBox($forum_lang['error'], $forum_lang['error_no_topic']);
		return;
	}

	//      
	System::database()->Select('forum_topics', "`id`='".$topic_id."'");
	if(System::database()->NumRows() == 0){
		System::site()->AddTextBox($forum_lang['error'], $forum_lang['error_no_topic']);
		return;
	}
	$topic = System::database()->FetchRow();
	if(!$user_admin && $topic['starter_id'] == $user_id && $topic['delete'] == '1'){ //     (      )
		System::site()->AddTextBox($forum_lang['topic_basket_current_post'], '<p align="center">'.$forum_lang['topic_basket_post'].'.<br><input type="button" value="'.$forum_lang['back'].'"onclick="history.back();"></p>');
		return;
	}

	//    
	$forum_id = SafeEnv($topic['forum_id'], 11, int);
	$forum_config = $forums_tree->GetForumConfigRecursive($forum_id); //    
	if(!$forum_config['access']){
		System::site()->AddTextBox($forum_lang['error'], $forum_config['access_reason']); //     
		return;
	}
	// $forum_config['add_post'] -   
	// $forum_config['add_post_reason'] -    
	// $forum_config['no_link_guest'] -    
	// $forum_config['new_message_email'] -     

	//     
	$topics_data = ForumCacheGetTopics();
	$topics_data = $topics_data[$forum_id];
	$prev_topic = null;
	$next_topic = null;
	$find = false;
	foreach($topics_data as $topic_row){
		if($topic_row['id'] == $topic_id){
			$find = true;
			continue;
		}
		if($find){
			$next_topic = $topic_row;
			break;
		}
		$prev_topic = $topic_row;
	}

	//   
	if(isset($_GET['page'])) {
		$page = SafeEnv($_GET['page'], 11, int);
	}else {
		$page = 1;
	}
	if(isset($_GET['view']) && $_GET['view'] == 'lastpost') {
		$lastpost = true;
	}else {
		$lastpost = false;
	}
	$posts_on_page = System::config('forum/posts_on_page');

	//     ,   
	if($user_auth){
		System::database()->Delete('forum_topics_read', "`tid`='$topic_id' and `mid`='$user_id'");
		System::database()->Insert('forum_topics_read', "'$user_id','$topic_id','$time'");
	}

	//  
	$online = ForumOnline::Instance($forum_id, $topic_id);

	//   
	$topic_title = SafeDB($topic['title'], 255, str);
	System::site()->SetTitle($topic_title.($page > 1 ? ' -  '.$page : ''));

	//  
	$forums_tree->BreadCrumbsF($forum_id);
	System::site()->BreadCrumbAdd(SafeDB($topic['title'], 255, str));

	//   (    )
	if($topic['delete'] == '1'){
		$basket_topics = ForumBasketGetData('forum_basket_topics');
		if(isset($basket_topics[$topic['id']])){
			System::site()->AddTextBox($forum_lang['topic_basket_red'], ForumBasketRender($topic['id'], $topic['title'], $basket_topics, true));
		}
	}

	//   
	System::database()->Update('forum_topics', "`hits`='".(SafeDB($topic['hits'], 11, int) + 1)."'", "`id`='".$topic_id."'");

	//   
	$navigation = new Navigation($page);
	$navigation->FrendlyUrl = System::config('general/ufu');

	//     
	$basket_where = ''; //  (   ..       . )
	if($user_auth){
		if(!$user_admin){
			$basket_where = " and (`delete`='0' or `user_id`='$user_id')"; // 
		}
	}else{
		$basket_where = " and `delete`='0'"; // 
	}
	$posts = System::database()->Select('forum_posts', ($one_post !== false ? "`id`='$one_post'" : "`object`='$topic_id'").$basket_where);
	SortArray($posts, 'public', false); //  

	//   
	if(count($posts) > $posts_on_page){
		if($lastpost){
			$page = ceil(count($posts) / $posts_on_page);
		}
		$navigation->GenNavigationMenu($posts, $posts_on_page, Ufu('index.php?name=forum&op=showtopic&topic='.$topic_id, 'forum/topic'.$topic_id.'-{page}.html', true), $page);
	}else{
		$navigation->DisableNavigation();
	}

	//    
	$basket = ForumBasketGetData('forum_basket_post');

	//     
	System::site()->AddBlock('topic', true, false);
	System::site()->SetVars('topic', ForumTopicFilterData($topic));

	//     
	System::site()->AddBlock('forum_posts', true, true, 'post');

	$is_forum_member = AccessIsResolved(2);

	//      
	$i = 1;

	//    
	foreach($posts as $post){
		$post_user_id = SafeDB($post['user_id'], 11, int);
		if($post_user_id == 0) continue;
		$vars = array();

		//   
		if($post['delete'] == '1'){ //    
			$vars['text'] = ForumBasketRender($post['id'], $post['message'], $basket);
		}else{
			$vars['text'] = HtmlChars($post['message']);
			if($forum_config['no_link_guest']){ //    
				$replace = '<p class="notice">'.$forum_lang['hide_links_for_guests'].'</p>';
				$vars['text'] = preg_replace('/\\<a[^\\>]*?(http|https|ftp|www)(.*?)\\<\/a\\>/is', $replace, $vars['text']);
				$vars['text'] = preg_replace('/(http:\/\/|https:\/\/|ftp:\/\/|www\.)?([a-zA-Z0-9]+)\.(ru|su|com|org|net|info|name|ws|cc|tv|tel|kz|biz|mobi|asia|me|tw|ua)+([--a-zA-Z0-9\'~;,@#%&_\!\$\^\*\(\)\-\=\+\?\.\:\/\\\\]*)?/is', $replace, $vars['text']);
			}
			SmiliesReplace($vars['text']);
			$vars['text'] = nl2br($vars['text']);
			$vars['text'] = BbCodePrepare($vars['text']);
			if($max_word_length > 0){
				$vars['text'] = word_wrapped_string($vars['text'], $max_word_length);
			}
		}

		//   
		// 
		$user_info = GetUserInfo($post_user_id);
		$vars['usertopics'] = '<a href="'.Ufu('index.php?name=forum&op=usertopics&user='.$post_user_id, 'forum/usertopics/{user}/').'">'.$forum_lang['allusertopics'].'</a>' ;
		if($user_info['rank_name'] <> '') {
			$vars['author'] = '<a href="'.Ufu('index.php?name=user&op=userinfo&user='.$post_user_id, 'user/{user}/info/').'">'.$user_info['name'].'</a>';
			$vars['author_name'] = $user_info['name'];
		}else{
			$vars['author'] = $post['name'];
			$vars['author_name'] = $post['name'];
		}
		if($user_info['hideemail'] == '0') {
			$vars['email'] = AntispamEmail($user_info['email']);
		}else {
			$vars['email'] = '&nbsp;';
		}
		if($user_info['url'] != ''){
			$vars['homepage'] = '<a href="http://'.$user_info['url'].'" target="_blank">'.$user_info['url'].'</a>';
		}else {
			$vars['homepage'] = '&nbsp;';
		}
		$vars['icq'] = $user_info['icq'];
		if($user_info['online']){
			$vars['status'] = $forum_lang['user_online'];
		}else {
			$vars['status'] = '';
		}
		$vars['rank_image'] = ($user_info['rank_image'] <> '' ? $user_info['rank_image'] : '');
		$vars['rank_name'] = ($user_info['rank_name'] <> '' ? $user_info['rank_name'] : '');

		$vars['avatar'] = ($user_info['avatar_file'] <> '' ? $user_info['avatar_file'] : GetPersonalAvatar(0));
		$vars['regdate'] = TimeRender($user_info['regdate'], false, true);

		if(isset($user_info['data']['forum_counters'])){
			$vars['user_posts_count'] = $user_info['data']['forum_counters']['posts'];
			$vars['user_topics_count'] = $user_info['data']['forum_counters']['topics'];
		}else{
			$vars['user_posts_count'] = '0';
			$vars['user_topics_count'] = '0';
		}

		// 
		$vars['public'] = $forum_lang['added'].TimeRender($post['public']);
		$vars['public_date'] = TimeRender($post['public']);
		$vars['ip'] = SafeDB($post['user_ip'], 19, str);
		$vars['topic_id'] = $topic_id;
		$vars['id'] = SafeDB($post['id'], 11, int);
		$vars['nodelete'] = (SafeDB($post['delete'], 1, int) == 1 ? false : true);
		$vars['is_admin_and_nodelete'] = $vars['nodelete'] && $user_admin;
		$vars['page'] = $page;

		// is_current_user     (   )
		if($post['delete'] == '0'){
			$vars['is_current_user'] = (($user_id == $post['user_id'] && $topic['close_topics'] == '0') || $user_admin);
		}else{
			$vars['is_current_user'] = false;
		}
		if($one_post === false){
			$vars['num'] = ($page > 1 ? ($page * $posts_on_page) - $posts_on_page + $i : $i);
			$vars['url'] = "javascript:link_post('".GetSiteUrl().Ufu("index.php?name=forum&op=post&topic=".$topic_id."&post=".$post['id'], 'forum/t{topic}/post{post}.html')."')";
		}else{
			$vars['num'] = '';
			$vars['url'] = 'javascript:history.go(-1)';
		}
		$vars['is_forum_member'] = $is_forum_member;
		System::site()->AddSubBlock('forum_posts', true, $vars, array(), 'module/forum_post.html');
		$i++;
	}

	//   
	System::site()->AddBlock('post_form', $forum_config['add_post'], false);
	ForumRenderPostForm(false, $forum_id, $topic_id, 0, '', '', $is_forum_member);

	//   
	System::site()->AddBlock('subscription', $forum_config['new_message_email'], false, 'subs');
	$vars_subs = array();
	$vars_subs['topic'] = $topic_id;
	$vars_subs['sub_status'] = Forum_Subscription_Status($topic_id);
	$vars_subs['status'] = ($vars_subs['sub_status'] ? '   ' : '   ');
	System::site()->SetVars('subscription', $vars_subs);

	System::site()->AddBlock('is_forum_member', $is_forum_member, false, 'marker');
	System::site()->SetVars('is_forum_member', array('id' => $topic_id));

	//  
	System::site()->AddTemplatedBox('', 'module/forum_showtopic.html');

	//   
	$online->Render($forum_id, $topic_id, $forum_lang['current_online'], 'forum_online');

	//    
	System::site()->AddBlock('forum_prev_topic', isset($prev_topic), false, 'topic');
	if(isset($prev_topic)){
		System::site()->SetVars('forum_prev_topic', array(
				'url' => Ufu('index.php?name=forum&op=showtopic&topic='.SafeDB($prev_topic['id'], 11, int), 'forum/topic{topic}.html'),
				'title' => SafeDB($prev_topic['title'], 255, str),
				'lang_prev_topic' => $forum_lang['prev_topic'])
		);
	}
	System::site()->AddBlock('forum_next_topic', isset($next_topic), false, 'topic');
	if(isset($next_topic)){
		System::site()->SetVars('forum_next_topic', array(
				'url' => Ufu('index.php?name=forum&op=showtopic&topic='.SafeDB($next_topic['id'], 11, int), 'forum/topic{topic}.html'),
				'title' => SafeDB($next_topic['title'], 255, str),
				'lang_next_topic' => $forum_lang['next_topic'])
		);
	}

	//    
	ForumQuickTransitionBox($forum_id, $forum_lang['quick_transition']);

}
