<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


if(!defined('VALID_RUN')){
	header("HTTP/1.1 404 Not Found");
	exit;
}

System::site()->SetTitle('');

global $ThumbsDir, $GalleryDir;
$GalleryDir = System::config('gallery/gallery_dir');
$ThumbsDir = System::config('gallery/thumbs_dir');

if(isset($_GET['op'])){
	$op = $_GET['op'];
}else{
	$op = 'main';
}

switch($op){
	case 'main':
		if(isset($_GET['cat'])){
			$cat = SafeEnv($_GET['cat'], 11, int);
		}else{
			$cat = 0;
		}
		IndexGalleryGetTree()->BreadCrumbs($cat);
		IndexGalleryGetTree()->ShowCats($cat);
		if($cat != 0){
			IndexGalleryShow($cat);
		}
		break;
	case 'view':
		IndexGalleryView();
		break;
	case 'addvote':
		IndexGalleryAddVote();
		break;
	// 
	case 'addpost':
		$id = intval(SafeEnv($_GET['img'], 11, int));
		$cat = SafeDB($_GET['cat'], 11, int);
		CommentsAddPost($id, 'gallery_comments', 'gallery', 'com_counter', 'allow_comments', "index.php?name=gallery&op=view&img=$id&cat=$cat", 'gallery/{cat}/{img}/');
		break;
	case 'savepost':
		if(CommentsEditPostSave(SafeEnv($_GET['img'], 11, int), 'gallery_comments')){
			break;
		}
	case 'editpost':
		CommentsEditPost('gallery_comments', "index.php?name=gallery&op=savepost&img=".SafeDB($_GET['img'], 11, int).'&back='.SafeDB($_GET['back'], 255, str));
		break;
	case 'deletepost':
		$id = SafeEnv($_GET['img'], 11, int);
		CommentsDeletePost($id, 'gallery_comments', 'gallery', 'com_counter', "index.php?name=gallery&op=deletepost&img=$id&back=".SafeDB($_GET['back'], 255, str));
		break;
	// //
	default:
		HackOff();
}
function IndexGalleryGetTree(){
	static $tree = null;
	if(is_null($tree)){
		$tree = new IndexTree('gallery_cats');
		$tree->moduleName = 'gallery';
		$tree->id_par_name = 'cat';
		$tree->NumItems = 'IndexGalleryGetNumItems';
	}
	return $tree;
}

function IndexGalleryGetNumItems(){
	System::database()->Select('gallery', GetWhereByAccess('view', "`show`='1'"));
	$num = System::database()->NumRows();
	System::database()->FreeResult();
	return '<p align="center">   : '.$num.'.</p>';
}

function IndexGalleryFilterImageData( $img, $index, $count ){
	global $ThumbsDir, $GalleryDir;
	$id = SafeDB($img['id'], 11, int);
	$cat_id = SafeDB($img['cat_id'], 11, int);
	$filename = SafeDB($img['file'], 255, str);

	$vars = array();
	$vars['id'] = $id;
	$vars['cat_id'] = $cat_id;
	$vars['date'] = TimeRender($img['public'], false);
	$vars['date_time'] = TimeRender($img['public']);
	$vars['title'] = SafeDB($img['title'], 255, str);
	$vars['description_plain'] = SafeDB($img['description'], 0, str);
	$vars['description'] = SafeDB($img['description'], 0, str, false, false);
	$vars['thumb_src'] = $ThumbsDir.$filename;
	$vars['image_src'] = $GalleryDir.$filename;
	$vars['image_view_full'] = $vars['image_src'];
	$vars['image_view'] = Ufu('index.php?name=gallery&op=view&img='.$id.'&cat='.$cat_id, 'gallery/{cat}/{img}/');
	$vars['size'] = false;
	$vars['asize'] = '';
	if(is_file($GalleryDir.$filename)){
		$vars['size'] = FormatFileSize(filesize($GalleryDir.$filename));
		$asize = getimagesize($GalleryDir.$filename);
		$asize = $asize[0].'x'.$asize[1];
		$vars['asize'] = $asize;
	}
	$vars['hits'] = SafeDB($img['hits'], 11, int);
	$vars['author'] = SafeDB($img['author'], 255, str);
	$vars['email'] = SafeDB($img['email'], 255, str);
	$vars['site'] = SafeDB($img['site'], 255, str);
	$vars['allow_comments'] = SafeDB($img['allow_comments'], 255, str);
	$vars['comments'] = SafeDB($img['com_counter'], 11, int);

	$vars['allow_votes'] = SafeDB($img['allow_votes'], 1, bool);
	$vars['num_votes'] = SafeDB($img['num_votes'], 11, int);
	$vars['rating'] = GetRatingImage(SafeDB($img['num_votes'], 11, int), SafeDB($img['sum_votes'], 11, int));

	$vars['lcomments'] = '';
	$vars['ldescription'] = '';

	$vars['index'] = $index;
	$vars['count'] = $count;

	$vars['addvote_url'] = "index.php?name=gallery&op=addvote&img=$id";
	System::site()->DataAdd($vdata, '0', ' ');
	System::site()->DataAdd($vdata, '1', ' ');
	System::site()->DataAdd($vdata, '2', '');
	System::site()->DataAdd($vdata, '3', '');
	System::site()->DataAdd($vdata, '4', '');
	System::site()->DataAdd($vdata, '5', '');
	$vars['votes'] = System::site()->Select('vote', $vdata);
	$vars['addvotesubm'] = System::site()->Submit(' ');

	return $vars;
}

/*
 *    .
 * @param int   $Cat .
 * @param array $Images  (   ).
 * @param bool  $OnlyBlock      .    
 *    .
 */
function IndexGalleryShow( $Cat, $Images = null, $OnlyBlock = false, $Parent = null, $Active = -1 ){
	if(!$OnlyBlock){
		if($Cat != 0){
			System::site()->SetTitle('   '.SafeDB(IndexGalleryGetTree()->IdCats[$Cat]['title'], 255, str));
		}
		$images_on_page = System::config('gallery/images_on_page');
		$thumbs_on_row = System::config('gallery/thumbs_onrow');
		if(isset($_GET['page'])){
			$page = SafeEnv($_GET['page'], 11, int);
		}else{
			$page = 1;
		}
	}

	if(!isset($Images)){
		$Images = System::database()->Select('gallery', GetWhereByAccess('view', "`cat_id`='$Cat' and `show`='1'"), null, 'order');
	}
	$count = count($Images);

	/*
	 *  .
	 */
	if(!$OnlyBlock){
		$navigation = new Navigation($page);
		if(System::config('gallery/page_navigation')){
			$nav_link = Ufu('index.php?name=gallery'.($Cat != 0 ? '&cat='.$Cat : ''), 'gallery/'.($Cat != 0 ? '{cat}/' : '').'page{page}/', true);
			$navigation->FrendlyUrl = System::config('general/ufu');
			$navigation->GenNavigationMenu($Images, $images_on_page, $nav_link);
		}else{
			$navigation->DisableNavigation();
		}
	}

	if($count > 0 || $OnlyBlock){
		/*
		 *    .
		 */
		if(isset($Parent)){
			$block_images = $Parent->NewBlock('gallery_images', true, true, 'img');
		}else{
			$block_images = System::site()->NewBlock('gallery_images_block', true, true, 'img');
		}
		if(!$OnlyBlock) System::site()->AddTable('gallery_images', true, 'img', $thumbs_on_row);
		foreach($Images as $index=>$img){
			if(!$OnlyBlock){
				$index = strval($index+1+($page-1)*$images_on_page);
			}
			$vars = IndexGalleryFilterImageData($img, $index, $count);
			if($vars['title'] == ''){
				$vars['title'] = ' '.$index;
			}
			$vars['active'] = ($index == $Active);
			$block_images->NewSubBlock(true, $vars);
			if(!$OnlyBlock) System::site()->AddTableCell('gallery_images', true, $vars);
		}
		if(!$OnlyBlock) System::site()->AddTemplatedBox('', 'module/gallery_image.html');
	}else{
		System::site()->AddTextBox('', '<p align="center">     .</p>');
	}
}

/*
 *  .
 */
function IndexGalleryView(){
	if(isset($_GET['img'])){
		$id = SafeEnv($_GET['img'],11,int);
	}else{
		GO(GetSiteUrl().Ufu('index.php?name=gallery', '{name}/'));
	}

	/*
	 *          index -> id,    
	 *  .
	 */
	$cat = SafeEnv($_GET['cat'], 11, int);
	$db_images = System::database()->Select('gallery', GetWhereByAccess('view', "`cat_id`='$cat' and `show`='1'"), null, 'order');
	if(System::database()->NumRows() == 0){
		GO(GetSiteUrl().Ufu('index.php?name=gallery', '{name}/'));
	}
	$images = array();
	foreach($db_images as $k=>$img){
		$images[$k] = $img['id'];
	}

	/*
	 *  .
	 */
	$index = array_search($id, $images);
	if($index !== false){
		$img = $db_images[$index];
	}else{
		GO(GetSiteUrl().Ufu('index.php?name=gallery', '{name}/'));
	}

	/*
	 *     ,         .
	 */
	$vars = IndexGalleryFilterImageData($img, $index+1, count($db_images));
	$vars['next'] = isset($db_images[$index + 1]);
	if($vars['next']){
		$nimg = $db_images[$index + 1];
		$vars['next_url'] = Ufu('index.php?name=gallery&op=view&img='.SafeDB($nimg['id'], 11, int).'&cat='.SafeDB($nimg['cat_id'], 11, int), 'gallery/{cat}/{img}/');
		$vars['next_title'] = SafeDB($nimg['title'], 255, str);
	}
	$vars['prev'] = isset($db_images[$index - 1]);
	if($vars['prev']){
		$nimg = $db_images[$index - 1];
		$vars['prev_url'] = Ufu('index.php?name=gallery&op=view&img='.SafeDB($nimg['id'], 11, int).'&cat='.SafeDB($nimg['cat_id'], 11, int), 'gallery/{cat}/{img}/');
		$vars['prev_title'] = SafeDB($nimg['title'], 255, str);
	}
	if($vars['title'] == ''){
		$vars['title'] = ' '.strval($index+1);
	}
	$GalleryImageBlock = System::site()->NewBlock('gallery_image', true, false, 'img')->SetVars($vars);

	/*
	 *    .
	 */
	IndexGalleryShow($cat, $db_images, true, $GalleryImageBlock, $index);

	/*
	 *  ,  ,  .
	 */
	IndexGalleryGetTree()->BreadCrumbs($cat);
	System::site()->BreadCrumbAdd($vars['title']);
	System::site()->SetTitle($vars['title']);
	System::site()->AddTemplatedBox('', 'module/gallery_view.html');

	/*
	 *   .
	 */
	System::database()->Update('gallery', "`hits`='".($img['hits'] + 1)."'", "`id`='$id'");

	/*
	 *  .
	 */
	if(isset($_GET['page'])){
		$page = SafeEnv($_GET['page'], 11, int);
	}else{
		$page = 0;
	}
	$posts = new Posts('gallery_comments', $img['allow_comments'] == '1');
	$posts->EditPageUrl = 'index.php?name=gallery&op=editpost&img='.$id;
	$posts->DeletePageUrl = 'index.php?name=gallery&op=deletepost&img='.$id;
	$posts->PostFormAction = "index.php?name=gallery&op=addpost&img=$id&cat=$cat&page=$page";
	$posts->NavigationUrl = Ufu("index.php?name=gallery&op=view&img=$id&cat=$cat", 'gallery/{cat}/{img}/page{page}/', true);
	$posts->RenderPosts($id, 'gallery_comments', 'comments_navigation', false, $page);
	$posts->RenderForm(false, 'gallery_comments_form');
}

function IndexGalleryAddVote(){
	$ip = getip();
	$time = time() - 86400; //1 
	$id = SafeEnv($_GET['img'], 11, int);
	$vote = SafeEnv($_POST['vote'], 1, int);
	System::database()->Delete('gallery_rating', "`time`<'$time'");
	System::site()->OtherMeta .= '<meta http-equiv="REFRESH" content="3; URL='.HistoryGetUrl(1).'">';
	System::database()->Select('gallery', GetWhereByAccess('view', "`id`='$id' and `show`='1'"));
	if(System::database()->NumRows() > 0){
		$image = System::database()->FetchRow();
		if($image['allow_votes']=='1'){ //  
			System::database()->Select('gallery_rating',"`ip`='$ip' and `imageid`='$id'");
			if(System::database()->NumRows() > 0){
				System::site()->AddTextBox('','<p align="center">  .<br><br><a href="javascript:history.go(-1)"></a></p>');
			}else{
				if($vote == 0){
					System::site()->AddTextBox('','<p align="center">   .<br><br><a href="javascript:history.go(-1)"></a></p>');
				}else{
					System::user()->ChargePoints(System::config('points/gallery_rating'));
					$time = time();
					System::database()->Insert('gallery_rating',"'','$id','$ip','$time'");
					$vote = SafeDB($image['sum_votes'],11,int) + $vote;
					$numvotes = SafeDB($image['num_votes'],11,int) + 1;
					System::database()->Update('gallery',"`num_votes`='$numvotes',`sum_votes`='$vote'","`id`='$id'");
					System::site()->AddTextBox('','<p align="center">   .<br><br><a href="javascript:history.go(-1)"></a></p>');
				}
			}
		}else{ //  
			System::site()->AddTextBox('','<p align="center">,    .<br><br><a href="javascript:history.go(-1)"></a></p>');
		}
	}else{ //   
		System::site()->AddTextBox('','<p align="center"> .   .<br><br><a href="javascript:history.go(-1)"></a></p>');
	}
}