<?php

/*
 * LinkorCMS 1.4
 *  2012 LinkorCMS Development Group
 */


if(!defined('VALID_RUN')){
	header("HTTP/1.1 404 Not Found");
	exit;
}

class Setup
{
	public $block = 'template';
	public $NextPage = '';
	public $PrevPage = '';
	public $form_open = false;
	public $form_name = 'setup_form';

	public function Setup()
	{
		global $config;
		$config['general']['site_name'] = ' LinkorCMS';
		$config['general']['main_title'] = '';
		System::site()->SetVar($this->block, 'content', '&nbsp;');
		System::site()->SetVar($this->block, 'help', false);
		System::site()->SetVar($this->block, 'form', false);
	}

	public function SetTitle( $title )
	{
		System::site()->Title = $title;
		System::site()->SetVar($this->block, 'title', $title);
	}

	public function SetNextPage( $PageName )
	{
		$this->NextPage = $PageName;
	}

	public function SetPrevPage( $PageName )
	{
		$$this->PrevPage = $PageName;
	}

	//   
	public function SetContent( $text )
	{
		System::site()->SetVar($this->block, 'content', $text);
	}

	public function SetHelp( $text = false )
	{
		System::site()->SetVar($this->block, 'help', $text);
	}

	// 
	public function OpenForm( $goModName, $multipart = false )
	{
		$form = '<form name="'.$this->form_name.'" action="setup.php?mod='.$goModName.'" method="post"'
			.($multipart ? ' enctype="multipart/form-data"' : '').'>';
		System::site()->SetVar($this->block, 'form', $form);
		$this->form_open = true;
	}

	//     
	public function AddSubmitButton( $caption )
	{
		$text = System::site()->Button($caption, 'class="button" onClick="javascript:'.$this->form_name.'.submit()"');
		System::site()->AddSubBlock('buttons', true, array('html'=>$text));
	}

	//  
	public function AddButton( $caption, $goModName = '' )
	{
		$text = System::site()->Button($caption, 'class="button" onClick="javascript:SetLocation(\'setup.php?mod='.$goModName.'\')"');
		System::site()->AddSubBlock('buttons', true, array('html'=>$text));
	}

	public function SEcho()
	{
		System::site()->TEcho();
	}

	//   
	public function Page( $page = '' )
	{
		global $config;
		if($page != '' && file_exists($config['s_mod_dir'].RealPath2($page).'/index.php')){
			include($config['s_mod_dir'].RealPath2($page).'/index.php');
		}else{
			include($config['s_mod_dir'].'main/index.php');
		}
		$this->SEcho();
	}
}
