<?php

/*
 *   .
 *   doctype,  JS, CSS   .
 *     ,       .
 */

//   true,  false,       .
//          .
System::site()->SetVar('template', 'inverse', false);

System::site()->Doctype = '<!doctype html>';
System::site()->SetTempVar('template', 'header', 'header.html');
System::site()->SetTempVar('template', 'top_menu', 'top_menu.html');
System::site()->SetTempVar('template', 'sign_in_block', 'sign_in_block.html');
System::site()->SetTempVar('template', 'footer', 'footer.html');

// 
UseScript('jquery', 'bootstrap', 'colorbox?theme=1', 'tiptip');
UseScript('syntaxhighlighter?theme=Default');
System::site()->AddJSFile('functions.js');

//        .
//      module/gallery_view.html.
System::site()->AddOnLoadJS(<<<JS
	$('[title]').tipTip({
		delay: 0,
		defaultPosition: "top"
	});
	$(document).mousedown(function(event){
		if($('#'+last_container_id).is(':visible') && $(event.target).parents().filter(".post-form").length == 0){
			post_reply(last_container_id);
		}
	});
JS
);

// 
System::site()->AddCSSFile('http://fonts.googleapis.com/css?family=Open+Sans:400,400italic,600,600italic&subset=latin,cyrillic', true, false, 'rel="stylesheet" type="text/css"');

// 
System::site()->AddCSSFile('style.css', false, false, 'media="screen"');

/**
 *      .   .
 * @param         $Title  . (    ,         ).
 * @param null    $Link  , url       ( index.php,   ufu    ).
 * @param string  $Type    (mod -   , page -   ).
 * @return string HTML  .
 */
function MenuLink($Title, $Link = null, $Type = 'mod' ){
	if(!isset($Link)){
		$Link = UfuLink($Title);
		$Type = 'page';
	}
	if($Link == 'index.php'){
		$active = (INDEX_PHP ? 'class="active"' : '');
		$link = Ufu('index.php');
	}elseif($Type == 'mod'){
		$active = (isset($_GET['name']) && $_GET['name'] == $Link ? 'class="active"' : '');
		$link = Ufu('index.php?name='.$Link, '{name}/');
	}elseif($Type == 'page'){
		$active = (isset($_GET['file']) && Utf8ToCp1251(rawurldecode($_GET['file'])) == $Link ? 'class="active"' : '');
		$link = Ufu('index.php?name=pages&file='.$Link, 'pages:page');
	}else{
		$active = '';
		$link = $Link;
	}
	echo "<li $active><a href=\"$link\">$Title</a></li>";
}
