<?php
/*******************************************************************************/
//                          InstantCMS v1.9                                    //
//                      http://www.instantcms.ru/                              //
//                                                                             //
//                                                                             //
/********************************************************************************/

if(!defined('VALID_CMS')) { die('ACCESS DENIED'); }


function makeCal($start_date, $end_date, $separator='-'){
  $start_date_list = explode($separator, $start_date);
  $end_date_list = explode($separator, $end_date);
  
  if(!checkdate($start_date_list[1], $start_date_list[0], $start_date_list[2])){return false;}
  if(!checkdate($end_date_list[1], $end_date_list[0], $end_date_list[2])){return false;}
  
  $start_date_jd = GregorianToJD($start_date_list[1], $start_date_list[0], $start_date_list[2]);
  $end_date_jd = GregorianToJD($end_date_list[1], $end_date_list[0], $end_date_list[2]);

  $days=array();
  for($i=$start_date_jd; $i<=$end_date_jd; $i++){
      $day = JDToGregorian($i);
      $day_list=explode('/', $day);
      //прибавляем 0 перед днем и месяцем, если меньше 10
      if($day_list[0]<10){ $day_list[0] = '0'.$day_list[0]; }
      if($day_list[1]<10){ $day_list[1] = '0'.$day_list[1]; }
      $day_str = "{$day_list[1]}-{$day_list[0]}-{$day_list[2]}";
      $days[] = $day_str;
  }

  return  $days;
}



function getCalendar($date='', $start_date=''){
    //проверяем дату
    if(!$date && !$start_date){ $date = date('d-m-Y'); }
    if($start_date){ $date = date('d-m-Y', strtotime($start_date)); }
    $date_timestap = strtotime($date);
    $date_arr = array();
    $date_arr = explode('-', $date);
    if(checkdate($date_arr[1], $date_arr[0], $date_arr[2]) != 1){ return false; }

    $calendar = array();
    setlocale(LC_ALL, 'ru');
    //год
    $calendar['yahr'] = $date_arr[2];
    //название месяца
    $inCore = cmsCore::getInstance();
    $calendar['month']['title'] = $inCore->getRusDate(strftime('%B',strtotime($date)));
    $calendar['month']['num']   =  $date_arr[1];
    //дни недели
    $calendar['week_days'] = array(0=>'Пн',
                                   1=>'Вт',
                                   2=>'Ср',
                                   3=>'Чт',
                                   4=>'Пт',
                                   5=>'Сб',
                                   6=>'Вс');
    //составляем календарь
    $calendar['days'] = array();

    // Вычисляем число дней в текущем месяце
    $dayofmonth = date('t', $date_timestap);
    // Счётчик для дней месяца
    $day_count = 1;

    // 1. Первая неделя
    
   $num = 0;
    for($i = 0; $i < 7; $i++){
      // Вычисляем номер дня недели для числа
      $dayofweek = date('w', mktime(0, 0, 0, date('m',$date_timestap), $day_count, date('Y',$date_timestap)));
      // Приводим к числа к формату 1 - понедельник, ..., 6 - суббота
      $dayofweek = $dayofweek - 1;
      if($dayofweek == -1) $dayofweek = 6;

      if($dayofweek == $i){
        // Если дни недели совпадают,
        // заполняем массив $week
        // числами месяца
        $week[$num][$i]['num'] = $day_count;
        $week[$num][$i]['date'] = strtotime("{$day_count}-{$date_arr[1]}-{$date_arr[2]}");
        $day_count++;
      }else{
        $week[$num][$i] = "";
      }
    }

    // 2. Последующие недели месяца
    while(true){
      $num++;
      for($i = 0; $i < 7; $i++){
        $week[$num][$i]['num'] = $day_count;
        $week[$num][$i]['date'] = strtotime("{$day_count}-{$date_arr[1]}-{$date_arr[2]}");
        $day_count++;
        // Если достигли конца месяца - выходим
        // из цикла
        if($day_count > $dayofmonth) break;
      }
      // Если достигли конца месяца - выходим
      // из цикла
      if($day_count > $dayofmonth) break;
    }


   
    $calendar['days'] = $week;
    //для ссылок следующего и предыдущего месяца
    $next_month = $date_arr[1]+1;
    $next_yahr = $date_arr[2];
    if($next_month >12){ $next_yahr += 1; $next_month = 1;}
    $last_month = $date_arr[1]-1;
    $last_yahr = $date_arr[2];
    if($last_month <1){ $last_yahr -= 1; $last_month = 12;}
    for($i=28; $i<=31; $i++){
        if(checkdate($last_month, $i, $last_yahr) == 1) $last_month_end = $i;
        if(checkdate($next_month, $i, $next_yahr) == 1) $next_month_end = $i;
    }
    $calendar['last_month_date'] = "1-{$last_month}-{$last_yahr}_{$last_month_end}-{$last_month}-{$last_yahr}";
    $calendar['next_month_date'] = "1-{$next_month}-{$next_yahr}_{$next_month_end}-{$next_month}-{$next_yahr}";
$last_ya = $last_yahr -1;
$last_ya1 = $last_yahr -2;

$next_ya = $next_yahr +1;
$last_mo = $last_month +1;
$next_mo = $next_month -1;
    $calendar['last_yahr_date1'] = "1-{$last_mo}-{$last_ya1}_{$last_month_end}-{$last_mo}-{$last_ya1}";

    $calendar['last_yahr_date'] = "1-{$last_mo}-{$last_ya}_{$last_month_end}-{$last_mo}-{$last_ya}";
    $calendar['next_yahr_date'] = "1-{$next_mo}-{$next_ya}_{$next_month_end}-{$next_mo}-{$next_ya}";
$ya1=$date_arr[2]-1;
$ya2=$date_arr[2]-2;
$ya3=$date_arr[2]+1;
$calendar['ya1']=$ya1;
$calendar['ya2']=$ya2;
$calendar['ya3']=$ya3;
$mo=$date_arr[1];
$calendar['da'] =$date_arr[2];
$ya=$date_arr[2];
$calendar['daty']="{$ya}{$mo}";
     
    return $calendar;
}

//устанавливает дату на русском . Если нет русской локали.
function getRusDate($datestr){
        $datestr = str_replace('January', 'Января', $datestr);
        $datestr = str_replace('February', 'Февраля', $datestr);
        $datestr = str_replace('March', 'Марта', $datestr);
        $datestr = str_replace('April', 'Апреля', $datestr);
        $datestr = str_replace('May', 'Мая', $datestr);
        $datestr = str_replace('June', 'Июня', $datestr);
        $datestr = str_replace('July', 'Июля', $datestr);
        $datestr = str_replace('August', 'Августа', $datestr);
        $datestr = str_replace('September', 'Сентября', $datestr);
        $datestr = str_replace('October', 'Октября', $datestr);
        $datestr = str_replace('November', 'Ноября', $datestr);
        $datestr = str_replace('December', 'Декабря', $datestr);
        
        //заменяем дни недели
        $datestr = str_replace('Mon', 'Пн', $datestr);
        $datestr = str_replace('Tue', 'Вт', $datestr);
        $datestr = str_replace('Wed', 'Ср', $datestr);
        $datestr = str_replace('Thu', 'Чтв', $datestr);
        $datestr = str_replace('Fri', 'Пт', $datestr);
        $datestr = str_replace('Sat', 'Сб', $datestr);
        $datestr = str_replace('Sun', 'Вск', $datestr);

        // Замена чисел 01 02 на 1 2
        $day_int = array(
					'01', '02', '03',
					'04', '05', '06',
					'07', '08', '09'

				 );
				 $day_norm = array(
					'1', '2', '3',
					'4', '5', '6',
					'7', '8', '9'

				 );
        
				$datestr = str_replace($day_int, $day_norm, $datestr);

        return $datestr;
    }
    
    function getevens($dat){
          $inCore = cmsCore::getInstance();
          $inDB = cmsDatabase::getInstance();
$even[] = array();

$sql1 = "SELECT
COUNT( id ) num
FROM cms_photo_files
WHERE DATE_FORMAT( pubdate, '%d%m%Y' )=$dat AND published = '1' $filter";
		$result1 = $inDB->query($sql1) ;
$photo = $inDB->fetch_assoc($result1);

$sql2 = "SELECT
COUNT( id ) num
FROM cms_user_files
WHERE DATE_FORMAT( pubdate, '%d%m%Y' )=$dat";
		$result2 = $inDB->query($sql2) ;
$files = $inDB->fetch_assoc($result2);

$sql3 = "SELECT
COUNT( id ) num
FROM cms_content
WHERE DATE_FORMAT( pubdate, '%d%m%Y' )=$dat AND published = '1' $filter";
		$result3 = $inDB->query($sql3) ;
$content = $inDB->fetch_assoc($result3);

$sql4 = "SELECT
COUNT( id ) num
FROM cms_blog_posts
WHERE DATE_FORMAT( pubdate, '%d%m%Y' )=$dat AND published = '1' $filter";
		$result4 = $inDB->query($sql4) ;
$posts = $inDB->fetch_assoc($result4);

$sql5 = "SELECT
COUNT( id ) as num
FROM cms_comments
WHERE DATE_FORMAT( pubdate, '%d%m%Y' )=$dat";
		$result5 = $inDB->query($sql5) ;
$comments = $inDB->fetch_assoc($result5);



$sql6 = "SELECT 
COUNT(id) num
FROM cms_users
WHERE DATE_FORMAT( regdate, '%d%m%Y')=$dat";
		$result6 = $inDB->query($sql6) ;
$use = $inDB->fetch_assoc($result6);

$sql7 = "SELECT 
COUNT(id) num
FROM cms_board_items
WHERE DATE_FORMAT( pubdate, '%d%m%Y')=$dat AND published = '1' $filter";
		$result7 = $inDB->query($sql7) ;
$board = $inDB->fetch_assoc($result7);

$sql8 = "SELECT 
COUNT(id) num
FROM cms_forum_posts
WHERE DATE_FORMAT( pubdate, '%d%m%Y')=$dat";
		$result8 = $inDB->query($sql8) ;
 $forum = $inDB->fetch_assoc($result8);


$even['photo']=$photo['num'];
$even['files']=$files['num'];
$even['content']=$content['num'];
$even['posts']=$posts['num'];
$even['comment']=$comments['num']; 
$even['use']=$use['num']; 
$even['board']=$board['num']; 
$even['forum']=$forum['num']; 

return $even;
         
    }
function getusers($dat){
          $inCore = cmsCore::getInstance();
          $inDB = cmsDatabase::getInstance();
$sql = "SELECT 
DATE_FORMAT( p.regdate, '%H:%i') as regdata,
p.nickname,
p.login,
g.imageurl as avatar,
o.user_id as status
FROM cms_users p
LEFT JOIN cms_user_profiles g ON p.id = g.user_id
LEFT JOIN cms_online o ON o.user_id = p.id
WHERE DATE_FORMAT( p.regdate, '%d%m%Y')=$dat";
		$result = $inDB->query($sql) ;
$users=array();
while ($user = $inDB->fetch_assoc($result)){
$user['avatar'] = ($user['avatar']) ? 
'/images/users/avatars/small/'.$user['avatar'] : '/images/users/avatars/small/nopic.jpg';
$user['status'] = ($user['status']) ?
'онлайн' : 'оффлайн';
$users[] = $user;
}
return $users;
        
}
function getphoto($dat){
          $inCore = cmsCore::getInstance();
          $inDB = cmsDatabase::getInstance();
$sql = "SELECT 
DATE_FORMAT( a.pubdate, '%H:%i') as pubdate,
a.id,
a.title,
a.file,
b.title as name,
p.nickname,
p.login
FROM cms_photo_files a
LEFT JOIN cms_photo_albums b on b.id = a.album_id
LEFT JOIN cms_users p on p.id = a.user_id
WHERE DATE_FORMAT( a.pubdate, '%d%m%Y' )=$dat AND a.published = '1' $filter";		
$result = $inDB->query($sql) ;
$photos=array();
while ($photo = $inDB->fetch_assoc($result)){

$photos[] = $photo;
}
   return $photos;     
}
function getcontent($dat){
          $inCore = cmsCore::getInstance();
          $inDB = cmsDatabase::getInstance();
$sql = "SELECT 
DATE_FORMAT( a.pubdate, '%H:%i') as pubdate,
a.title as title,
a.seolink as url,
b.title as name,
p.nickname,
p.login,
g.imageurl as avatar
FROM cms_content a
LEFT JOIN cms_category b ON b.id = a.category_id
LEFT JOIN cms_users p on p.id = a.user_id
LEFT JOIN cms_user_profiles g ON p.id = g.user_id

WHERE DATE_FORMAT( a.pubdate, '%d%m%Y' )=$dat AND a.published = '1' $filter";		
$result = $inDB->query($sql) ;
$contents=array();
while ($content = $inDB->fetch_assoc($result)){
$content['avatar'] = ($content['avatar']) ? 
'/images/users/avatars/small/'.$content['avatar'] : '/images/users/avatars/small/nopic.jpg';
$contents[] = $content;
}
   return $contents; 
}
function getposts($dat){
          $inCore = cmsCore::getInstance();
          $inDB = cmsDatabase::getInstance();
$sql = "SELECT 
DATE_FORMAT( a.pubdate, '%H:%i') as pubdate,
a.title as title,
a.seolink as upost,
b.seolink as ublog,
b.title as name,
p.nickname,
p.login,
g.imageurl as avatar
FROM cms_blog_posts a
LEFT JOIN cms_blogs b ON b.id = a.blog_id
LEFT JOIN cms_users p on p.id = a.user_id
LEFT JOIN cms_user_profiles g ON p.id = g.user_id

WHERE DATE_FORMAT( a.pubdate, '%d%m%Y' )=$dat AND a.published = '1' $filter";		
$result = $inDB->query($sql) ;
$posts=array();
while ($post = $inDB->fetch_assoc($result)){
$post['avatar'] = ($post['avatar']) ? 
'/images/users/avatars/small/'.$post['avatar'] : '/images/users/avatars/small/nopic.jpg';
$posts[] = $post;
}
   return $posts; 
}
function getboard($dat){
          $inCore = cmsCore::getInstance();
          $inDB = cmsDatabase::getInstance();
$sql = "SELECT 
DATE_FORMAT( a.pubdate, '%H:%i') as pubdate,
a.id,
a.obtype,
a.title,
p.nickname,
p.login,
g.imageurl as avatar
FROM cms_board_items a
LEFT JOIN cms_users p on p.id = a.user_id
LEFT JOIN cms_user_profiles g ON p.id = g.user_id

WHERE DATE_FORMAT( a.pubdate, '%d%m%Y' )=$dat AND a.published = '1' $filter";		
$result = $inDB->query($sql) ;
$boards=array();
while ($board = $inDB->fetch_assoc($result)){

$board['avatar'] = ($board['avatar']) ? 
'/images/users/avatars/small/'.$board['avatar'] : '/images/users/avatars/small/nopic.jpg';

$boards[] = $board;
}
   return $boards; 
}
function getcomment($dat){
          $inCore = cmsCore::getInstance();
          $inDB = cmsDatabase::getInstance();
$sql = "SELECT 
DATE_FORMAT( a.pubdate, '%H:%i') as pubdate,
a.content_bbcode as content,
a.target_link as url,
b.title,
p.nickname,
p.login,
g.imageurl as avatar
FROM cms_comments a
LEFT JOIN cms_comment_targets b on b.target = a.target
LEFT JOIN cms_users p on p.id = a.user_id
LEFT JOIN cms_user_profiles g ON p.id = g.user_id

WHERE DATE_FORMAT( a.pubdate, '%d%m%Y' )=$dat";		
$result = $inDB->query($sql) ;
$comments=array();
while ($comment = $inDB->fetch_assoc($result)){
$comment['avatar'] = ($comment['avatar']) ? 
'/images/users/avatars/small/'.$comment['avatar'] : '/images/users/avatars/small/nopic.jpg';
$comment['content'] = contentbb($comment['content']);

$comments[] = $comment;
}
   return $comments; 
}
function getforum($dat){
          $inCore = cmsCore::getInstance();
          $inDB = cmsDatabase::getInstance();
$sql = "SELECT 
DATE_FORMAT( a.pubdate, '%H:%i') as pubdate,
a.content,
b.id,
b.title,
p.nickname,
p.login,
g.imageurl as avatar
FROM cms_forum_posts a
LEFT JOIN cms_forum_threads b on b.id = a.thread_id
LEFT JOIN cms_users p on p.id = a.user_id
LEFT JOIN cms_user_profiles g ON p.id = g.user_id

WHERE DATE_FORMAT( a.pubdate, '%d%m%Y' )=$dat";		
$result = $inDB->query($sql) ;
$forums=array();
while ($forum = $inDB->fetch_assoc($result)){
$forum['avatar'] = ($forum['avatar']) ? 
'/images/users/avatars/small/'.$forum['avatar'] : '/images/users/avatars/small/nopic.jpg';
$forum['content'] = contentbb($forum['content']);

$forums[] = $forum;
}
   return $forums; 
}
function contentbb($content){
                    $content = strip_tags($content);
                    $content =  preg_replace('/\[IMG\](.*?)\[\/IMG\]/i', '', $content);
                    $content =  preg_replace('/\[\/b\]/i', '', $content);
                    $content =  preg_replace('/\[b\]/i', ' ', $content);
                    $content =  preg_replace('/\[\/i\]/i', '', $content);
                    $content =  preg_replace('/\[i\]/i', ' ', $content);
                    $content =  preg_replace('/\[\/u\]/i', '', $content);
                    $content =  preg_replace('/\[u\]/i', ' ', $content);
                    $content =  preg_replace('/\[\/s\]/i', '', $content);
                    $content =  preg_replace('/\[s\]/i', ' ', $content);
                    $content =  preg_replace('/\[\/align\]/i', ' ', $content);
                    $content =  preg_replace('/\[align=left\]/i', '', $content);
                    $content =  preg_replace('/\[align=center\]/i', '', $content);
                    $content =  preg_replace('/\[align=right\]/i', '', $content);
                    $content =  preg_replace('/\[\/quote\]/i', ' ', $content);
                    $content =  preg_replace('/\[quote\]/i', '', $content);
                    $content =  preg_replace('/\[url=(.*?)\](.*?)\[\/url\]/i', '', $content);
                    $content =  preg_replace('/\[\/h1\]/i', '', $content);
                    $content =  preg_replace('/\[h1\]/i', ' ', $content);
                    $content =  preg_replace('/\[email\](.*?)\[\/email\]/i', '', $content);
                    $content =  preg_replace('/\[code=php\](.*?)\[\/code\]/i', '', $content);
                    $content =  preg_replace('/\[\/h2\]/i', '', $content);
                    $content =  preg_replace('/\[h2\]/i', ' ', $content);
                    $content =  preg_replace('/\[\/h3\]/i', '', $content);
                    $content =  preg_replace('/\[h3\]/i', ' ', $content);
                    $content =  preg_replace('/\[\/hide\]/i', '', $content);
                    $content =  preg_replace('/\[hide\]/i', ' ', $content);
                    $content =  preg_replace('/\[\/spoiler\]/i', '', $content);
                    $content =  preg_replace('/\[spoiler=Спойлер\]/i', ' ', $content);
                    $content =  preg_replace('/\[video\](.*?)\[\/video\]/i', '', $content);
                    $content =  preg_replace('/\[audio\](.*?)\[\/audio\]/i', '', $content);
                    $content =  preg_replace('/\[img\](.*?)\[\/img\]/i', '', $content);
             return $content;
}
?>