<?php

class SotmarketProduct {

    //  
    protected $oController;
    // 
    protected $oImageCache;
    // 
    protected $oTpl;
    //  
    protected $sHomeUrl;
    //id 
    protected $iSiteId;
    //id 
    protected $iPartnerId;

    //  
    protected $sType;

    protected $sLabelType = 'from';
    protected $sLabel;

    protected $bExternalLink = true;

    protected $sBlockType = 'informer';

    protected $sCpaLinkBegin = '';
    protected $sCpaLinkEnd = '';
    protected $sCpaLinkGet = '';

    function __construct( $aConfig , $oTpl , $sType ){

        $this->oTpl = $oTpl;
        //
        $this->iSiteId = $aConfig['SOTMARKET_SITE_ID'];
        $this->iPartnerId = $aConfig['SOTMARKET_PARTNER_ID'];
        $oConfig = new SotmarketConfig(dirname(__FILE__) . "/");
        $oConfig->config['rpc']['site_id'] = $this->iSiteId;

        $callback = new SotmarketRPCClientCallbackImp( $this->iSiteId , session_id());
        $RPC_Client = new SotmarketRPCClient($oConfig->config['rpc'], $callback);
        $this->oController = $RPC_Client->getObjectByClassName('SotmarketRPCOrder');

        $this->oImageCache = new SotmarketClientImageCacheFile($oConfig->config['rpc']);

        $this->sHomeUrl = $aConfig['home_url'];

        $aTypes = array('products','related','analog','popular');
        if ( in_array( $sType,$aTypes ) ){
            $this->sType = $sType;
        } else {
            echo '   ';
        }

        $this->sLabel = $aConfig['SOTMARKET_SUBREF'];

        if ($aConfig['SOTMARKET_LINK_TYPE'] == 'redirect'){
            $this->bExternalLink = false;
        }

        if ($aConfig['SOTMARKET_CPA_LINK_BEGIN']){
            $this->sCpaLinkBegin = $aConfig['SOTMARKET_CPA_LINK_BEGIN'];
        }
        if ($aConfig['SOTMARKET_CPA_LINK_END']){
            $this->sCpaLinkEnd = $aConfig['SOTMARKET_CPA_LINK_END'];
        }
        if ($aConfig['SOTMARKET_CPA_LINK_GET']){
            $this->sCpaLinkGet = $aConfig['SOTMARKET_CPA_LINK_GET'];
        }
    }

    public function getProducts( $aProductsIds, $sProductName = '', $iCnt = 1,  $sTemplate = 'sotmarket_block' , $sImageSize = 'default', $aCategories = array()){




        if ( $sProductName && !$aProductsIds && $this->sType != 'popular'){

            if ( $this->sType == 'products' ){
                if (!$aCategories){
                    $aCategories = array(11,25);
                }
                $aProductsIds = $this->oController->product_search_cached( $sProductName , $aCategories );
            } else {
                $aProductsIds = $this->oController->product_search_cached( $sProductName , array(11,25) );
            }

        }

        //   
        if ( $this->sType == 'popular' ){
            if (!$aCategories){
                $aCategories = array(11,25);
            }
            $aProductsIds = $this->oController->product_search_cached( '' , $aCategories,array(),'popularity','asc',$aProductsIds );
        }

        if ( !$aProductsIds ){
            return '     ';
        }

        if ( $this->sType == 'products' || $this->sType == 'popular'){
            $aProductsIds = array_slice( $aProductsIds, 0,$iCnt );
        }

        if ( $this->sType == 'analog' ){
            $aAnalogIds = array();
            if (!$aCategories){
                $aCategories = array(11,25);
            }
            foreach( $aProductsIds as $iProductId ){

                $aFindedAnalogProductIds = $this->oController->products_analog_cached( $iProductId, $aCategories,array());
                $aAnalogIds = array_merge( $aAnalogIds, $aFindedAnalogProductIds );
                //       
                if ( count($aAnalogIds ) > $iCnt ){

                    $aAnalogIds = array_slice($aAnalogIds, 0,$iCnt );
                    break;
                }
            }

            $aProductsIds = $aAnalogIds;
        }

        if ( $this->sType == "related" ){

            $aRelatedIds = array();
            foreach( $aProductsIds as $iProductId ){
                $aFindedRelatedProductIds = $this->oController->product_accessories( $iProductId, $aCategories,array());

                $aRelatedIds  = array_merge( $aRelatedIds , $aFindedRelatedProductIds );
                //       
                if ( count( $aRelatedIds  ) > $iCnt ){

                    $aRelatedIds = array_slice($aRelatedIds , 0,$iCnt );
                    break;
                }
            }

            $aProductsIds = $aRelatedIds;
        }


        //   
        if ($this->sType == 'popular'){
            $aParams = array(
                'image_size' => $sImageSize,
                'order_by' => 'popularity' ,
                'sort_by' => 'asc'
            );
        } else {
            $aParams = array(
                'image_size' => $sImageSize,

            );
        }

        $aProductsInfo = $this->oController->product_info_array_cached($aProductsIds, $aParams, true);

        $aProducts = array();

        foreach( $aProductsInfo as $iProductId => $aProductInfo ){


            $sImgUrl = $aProductsInfo[$iProductId]['image_url'];
            $sLocalImgUrl = $iProductId . '-' . $sImageSize . $this->oImageCache->sGetExtensionWithDot($sImgUrl);
            if (!$this->oImageCache->bCheckCache($sLocalImgUrl)) {
                if ($this->oImageCache->bSaveRemote($sLocalImgUrl, $sImgUrl)) {
                    $sFullImgUrl = $this->sHomeUrl.$this->oImageCache->sGetImagePath($sLocalImgUrl);

                } else {
                    $sFullImgUrl = $this->sHomeUrl.$this->oImageCache->sGetDefaultImagePath();
                }
            } else {
                $sFullImgUrl = $this->sHomeUrl.$this->oImageCache->sGetImagePath($sLocalImgUrl);


            }


            $sProductUrl = $aProductInfo['info_url'];
            if ($this->sCpaLinkBegin || $this->sCpaLinkEnd){
                //    CPA 
                if ($this->sCpaLinkBegin){
                    $sProductUrl = $this->sCpaLinkBegin . $sProductUrl;
                }
                if ($this->sCpaLinkEnd){
                    $sProductUrl .= $this->sCpaLinkEnd;
                }
            } else {
                if ($this->sCpaLinkGet){
                    $sProductUrl .= '?'.$this->sCpaLinkGet;
                } else {
                    //    
                    $sProductUrl .= '?ref=' . $this->iPartnerId;
                    $sProductUrl .= '&subref=dle.'.$this->iSiteId.'.'.$this->sType.'.'.$iProductId;
                    if ($this->sLabel){
                        $sProductUrl .= '.any_'.$this->sLabel;
                    }
                }

            }

            if ( !$this->bExternalLink ){

                $sSecret = md5('redirect'.$this->iPartnerId.$this->iSiteId);
                $sProductUrl = base64_encode( sotm_encode($sSecret.$sProductUrl,$sSecret));

                if ($this->sHomeUrl){
                    $sProductUrl = $this->sHomeUrl.'?srdr='.$sProductUrl;
                } else {
                    $sProductUrl = '/?srdr='.$sProductUrl;
                }

            }

            $aProducts[] = array(
                '{id}' => $iProductId,
                '{sale}' => $aProductInfo['isSale'] ? 'SALE&nbsp;' : '',
                '{title}' => $aProductInfo['name'],
                '{price}' => $aProductInfo['price'],
                '{url}' => $sProductUrl,
                '{image_src}' => $sFullImgUrl,
                '{full_url}' => $aProductInfo['full_url'],

            );
        }



        $sReturn = $this->getRenderedData( $aProducts , $sTemplate);

        return $sReturn;

    }

    protected function getRenderedData( $aProducts = array() , $sTemplate = 'sotmarket_block'){

        $this->oTpl->load_template('sotmarket/'. $sTemplate . '.tpl');
        foreach ($aProducts as $aProduct) {
            $this->oTpl->set('', $aProduct);
            $this->oTpl->compile('sotmarket_content');
        }
        $sReturn = $this->oTpl->result['sotmarket_content'];
        //  
        $this->oTpl->clear();

        return $sReturn;

    }
}