<?php

/**
 * Функция для кодирования и декодирования ссылки с редиректом
 * @param $string
 * @param $key
 * @return string
 */
function sotm_decode($string,$key) {
    $key = sha1($key);
    $strLen = strlen($string);
    $keyLen = strlen($key);
    $j = 0;
    $hash = '';
    for ($i = 0; $i < $strLen; $i+=2) {
        $ordStr = hexdec(base_convert(strrev(substr($string,$i,2)),36,16));
        if ($j == $keyLen) { $j = 0; }
        $ordKey = ord(substr($key,$j,1));
        $j++;
        $hash .= chr($ordStr - $ordKey);
    }
    return $hash;
}

/**
 * Кодирование с ключем
 * @param $string
 * @param $key
 * @return string
 */
function sotm_encode($string,$key) {
    $key = sha1($key);
    $strLen = strlen($string);
    $keyLen = strlen($key);
    $j = 0;
    $hash = '';
    for ($i = 0; $i < $strLen; $i++) {
        $ordStr = ord(substr($string,$i,1));
        if ($j == $keyLen) { $j = 0; }
        $ordKey = ord(substr($key,$j,1));
        $j++;
        $hash .= strrev(base_convert(dechex($ordStr + $ordKey),16,36));
    }
    return $hash;
}

function explodeProductId( $sProductIds ){
    $aProductIds = array();
    $sProductIds = trim($sProductIds);
    $aTmpProductIds = explode(',',$sProductIds);
    foreach($aTmpProductIds as $iProductId){
        $iProductId = (int) $iProductId;
        if ( $iProductId ){
            $aProductIds[] = $iProductId;
        }
    }

    return $aProductIds;
}

function getSotmarketConfig(){
    global $db;
    static $aConfig;

    if ($aConfig){
        return $aConfig;
    }

    $db->query("SELECT sm_value, sm_key FROM `" . PREFIX . "_sotmarket_settings`");

    $aConfig = array();

    while ($aRow = $db->get_array()) {
        $aConfig[$aRow['sm_key']] = $aRow['sm_value'];
    }

    $db->free();
    return $aConfig;
}