UserBox
=======

__UserBox__ - простой модуль для вывода информации о любом пользователе в любом месте сайта на DLE 9.8 - 10.0.
Понадобится, если нужно вывести не только аватар с минимальной нагрузкой на сайт!
Модуль будет полезен тогда, когда нужно вывести информацию о каком-либо пользователе в произвольном месте сайта.
Например кулинарным сайтам, где нужно вывести информацию об авторе рецепта непосредственно в рецепт или личным (коллективным) блогам. 

### Ссылки
[Автор модуля](http://pafnuty.name/ "ПафНутиЙ")

### Возможности модуля UserBox:
* Подключение одной строкой.
* Вывод данных из профиля пользователя в любом месте сайта, на основе логина пользователя.
* Вывод дополнительных полей профиля пользователя (выводятся только те, которые не являются личными).
* Возможность использовать собственные шаблоны для вывода информации.
* Настраиваемая заглушка-аватар на случай, если у пользователя нет аватара и нужно вывести не стандартную заглушку.
* Кеширование результата работы модуля. Кеш создаётся с учётом логина пользователя, дефолтного аватара и используемого шаблона вывода модуля.

### Особенности: 
- __Одна обязательная переменная в строке подключения__ - &userName. Именно через эту переменную модуль определяет для какого юзера выводить информацию.
- __Добавляет один запрос на каждого выводимого модулем пользователя__. Т.е. если выводить информацию об авторе новости в кратких новостях и на главной странице сайта выводится 30 новостей, которые опубликовали 10 пользователей (по три новости каждый) - то модуль при первом обращении к странице добавит 10 запросов в БД, после чего данные будут браться уже из кеша (при включенном кешировании на сайте). Если на второй странице попадётся пользователь с первой страницы, то запрос в БД на этого пользователя делаться не будет. 
- __Собственные теги для вывода в шаблоне.__ Отдельные теги сделаны для того, что бы не было конфликтов и для упрощения обработки этих тегов в модуле, что сократило кода процентов на 10-15 точно.
- __Собственная папка с шаблонами__. Так же для удобства использования.
- __Выводятся не все данные.__ Т.к. выводить все данные о пользователе не имеет смысла, а так же в целях экономии ресурсов сервера выводятся следующие данные:
[list=1]
[*] email - Email пользователя
[*] name - Логин
[*] news_num - Кол-во новостей
[*] user_id - ID пользователя
[*] comm_num - Кол-во комментариев
[*] user_group - Группа (форматированный вывод с префиксами и суффиксами)
[*] lastdate - Дата последнего посещения сайта
[*] reg_date - Дата регистрации
[*] info - Информация о пользователе
[*] foto - URL аватарки (или настраиваемая заглушка)
[*] fullname - Полное имя
[*] land - Место проживания
[*] icq - Номер ICQ
[*] Дополнительные поля
[/list]
Полный список поддерживаемых модулем тегов приведён в шаблоне __userbox/dafault.tpl__


### Установка:

* Распаковать содержимое папки uload из архива в корень сайта, при этом не забывайте переименовать папку THEME в соответствии с названием текущего шаблона сайта.
* В нужном месте любого шаблона сайта прописать: ```{include file="engine/modules/userbox.php?&userName=login"}``` где login - логин пользователя.
* Всё!

Примеры использования:
```{include file="engine/modules/userbox.php?&userName={login}"}``` выведет информацию о авторе, если эту строку прописать в шаблоне новости (краткой или полной) или комментария (к примеру можно вывести рейтинг пользователя).

```{include file="engine/modules/userbox.php?&userName=Бот&template=newtemplate&defAvatar=images/picture.jpg"}``` Выведет информацию о пользователе с логином __Бот__, для вывода будет использован шаблон, лежащий в папке __userbox/newtemplate.tpl__, при этом если у пользователя нет аватарки (или не задан gravatar в настройках) - будет выведено изображение из папки __images/picture.jpg__.


