<?php 
set_time_limit(0);
ini_set("max_execution_time", 90000000);
require_once (ROOT_DIR . '/engine/classes/pclzip.lib.php');

class mysitebackup

	{
	var $options = array();
	var $out_backup_files = '';
	var $last_error = '';
	var $uploader = null;
	var $site = '';
	function mysitebackup($site = '')
		{
		$site = str_replace('http://', '', $site);
		$site = explode('/', $site);
		foreach($site as $dd)
		if ($dd != '') $this->site = ($this->site == '' ? '' : '_') . $dd;
		require_once (ROOT_DIR . '/engine/data/config_mybackup.php');

		$this->options = $config_mybackup;
		if ($this->options['upload_type'] == 'dropbox')
			{
			require_once (ROOT_DIR . '/engine/classes/mysite.backup.dropbox.class.php');

			$this->uploader = new mysitebackup_dropbox($this->options['dropbox_email'], $this->options['dropbox_password']);
			}
		  else
		if ($this->options['upload_type'] == 'yandexdisk')
			{
			require_once (ROOT_DIR . '/engine/classes/mysite.backup.yandexdisk.class.php');

			$this->uploader = new mysitebackup_yandexdisk($this->options['yandexdisk_email'], $this->options['yandexdisk_password']);
			}
		}

	function bf_getfile_backup()
		{
		$return = '';
		if ($dh = opendir($this->options['out_file']))
			{
			while (($file = readdir($dh)) !== false)
			if ($file != '.' && $file != '..')
				{
				if (preg_match('"(.*?)_' . $this->site . '_backup.zip"is', $file) === 1)
					{
					$return = ROOT_DIR . '/' . $this->options['out_file'] . '/' . $file;
					}
				}

			closedir($dh);
			}

		return $return;
		}

	function bf_getfiles($dir, $rootdir = '')
		{
		$allowed_dir = explode("\r\n", $this->options['upload_dir']);
		foreach($allowed_dir as $ii => $dd)
		if ($dd != '') $allowed_dir[$ii] = ROOT_DIR . ($dd[0] == '/' ? '' : '/') . $dd;
		$return = array();
		if ($rootdir == '') $rootdir = $dir . '/';
		if (is_dir($dir))
			{
			if ($dh = opendir($dir))
				{
				while (($file = readdir($dh)) !== false)
				if ($file != '.' && $file != '..')
					{
					if ($dir != ROOT_DIR)
						{
						$allowed_find = false;
						foreach($allowed_dir as $dd)
						if (strpos($dir . '/' . $file, $dd) !== false)
							{
							$allowed_find = true;
							break;
							}

						if ($this->options['upload_dir_type'] == 1 and !$allowed_find) continue;
						if ($this->options['upload_dir_type'] == 2 and $allowed_find) continue;
						}

					if (strpos($dir . '/' . $file, ROOT_DIR . '/engine/cache') !== false) continue;
					if (preg_match('"' . $this->options['out_file'] . '/(.*?)_' . $this->site . '_backup.zip"is', $dir . '/' . $file) === 1) continue;
					if (is_dir($dir . '/' . $file)) $return = array_merge($return, $this->bf_getfiles($dir . '/' . $file, $rootdir));
					  else $return[] = str_ireplace($rootdir, '', $dir . '/' . $file);
					}

				closedir($dh);
				}
			}

		return $return;
		}

	function backup()
		{
		$this->out_backup_files = $this->bf_getfile_backup();
		if ($this->out_backup_files != '') return true;
		$files = $this->bf_getfiles(ROOT_DIR);
		$this->out_backup_files = ROOT_DIR . '/' . $this->options['out_file'] . '/' . date('Y_m_d_H_i') . '_' . $this->site . '_backup.zip';
		@unlink($this->out_backup_files);
		$archive = new PclZip($this->out_backup_files);
		$result = $archive->create(implode(',', $files) , PCLZIP_OPT_REMOVE_PATH, ROOT_DIR);
		if ($result == 0) $this->last_error = $archive->errorInfo(true);
		return $result != 0;
		}

	function upload()
		{
		try
			{
			$result = $this->uploader->upload($this->out_backup_files, $this->options['dir']);
			}

		catch(Exception $ex)
			{
			$this->last_error = $ex->getMessage();
			$result = false;
			}

		if ($result) @unlink($this->out_backup_files);
		return $result;
		}

	function execute()
		{
		if (!$this->backup()) die('Error create zip file: ' . $this->last_error);
		if (!$this->upload()) die('Error upload zip file: ' . $this->last_error);
		die('Backup create and upload');
		}
	};