<?php 
class yandex_webdav_client

{
	var $_debug = false;
	var $_fp;
	var $_server;
	var $_port = 80;
	var $_path = '/';
	var $_user;
	var $_protocol = 'HTTP/1.0';
	var $_pass;
	var $_socket_timeout = 5;
	var $_errno;
	var $_errstr;
	var $_user_agent = 'php class webdav_client $Revision: 1.7 $';
	var $_crlf = "\r\n";
	var $_req;
	var $_resp_status;
	var $_parser;
	var $_xmltree;
	var $_tree;
	var $_ls = array();
	var $_ls_ref;
	var $_ls_ref_cdata;
	var $_delete = array();
	var $_delete_ref;
	var $_delete_ref_cdata;
	var $_lock = array();
	var $_lock_ref;
	var $_lock_rec_cdata;
	var $_null = NULL;
	var $_header = '';
	var $_body = '';
	var $_connection_closed = false;
	var $_maxheaderlenth = 1000;
	function yandex_webdav_client()
	{
	}

	function set_server($server)
	{
		$this->_server = $server;
	}

	function set_port($port)
	{
		$this->_port = $port;
	}

	function set_user($user)
	{
		$this->_user = $user;
	}

	function set_pass($pass)
	{
		$this->_pass = $pass;
	}

	function set_debug($debug)
	{
		$this->_debug = $debug;
	}

	function set_protocol($version)
	{
		if ($version == 1) {
			$this->_protocol = 'HTTP/1.1';
		}
		else {
			$this->_protocol = 'HTTP/1.0';
		}

		$this->_error_log('HTTP Protocol was set to ' . $this->_protocol);
	}

	function iso8601totime($iso8601)
	{
		$regs = array();
		if (ereg('^([0-9]{4})-([0-9]{2})-([0-9]{2})T([0-9]{2}):([0-9]{2}):([0-9]{2})Z$', $iso8601, $regs)) {
			return mktime($regs[4], $regs[5], $regs[6], $regs[2], $regs[3], $regs[1]);
		}

		return false;
	}

	function open()
	{
		$this->_error_log('open a socket connection');
		$this->_fp = fsockopen($this->_server, $this->_port, $this->_errno, $this->_errstr, $this->_socket_timeout);
		socket_set_blocking($this->_fp, true);
		if (!$this->_fp) {
			$this->_error_log("$this->_errstr ($this->_errno)\n");
			return false;
		}
		else {
			$this->_connection_closed = false;
			$this->_error_log('socket is open: ' . $this->_fp);
			return true;
		}
	}

	function close()
	{
		$this->_error_log('closing socket ' . $this->_fp);
		$this->_connection_closed = true;
		fclose($this->_fp);
	}

	function check_webdav()
	{
		$resp = $this->options();
		if (!$resp) {
			return false;
		}

		$this->_error_log($resp['header']['DAV']);
		if (preg_match('/1,2/', $resp['header']['DAV'])) {
			return true;
		}

		return false;
	}

	function options()
	{
		$this->_header_unset();
		$this->_create_basic_request('OPTIONS');
		$this->_send_request();
		$this->_get_respond();
		$response = $this->_process_respond();
		if ($response['status']['http-version'] == 'HTTP/1.1' || $response['status']['http-version'] == 'HTTP/1.0') {
			return $response;
		}

		$this->_error_log('Response was not even http');
		return false;
	}

	function mkcol($path)
	{
		$this->_path = $this->_translate_uri($path);
		$this->_header_unset();
		$this->_create_basic_request('MKCOL');
		$this->_send_request();
		$this->_get_respond();
		$response = $this->_process_respond();
		if ($response['status']['http-version'] == 'HTTP/1.1' || $response['status']['http-version'] == 'HTTP/1.0') {
			return $response['status']['status-code'];
		}
	}

	function get($path, &$buffer)
	{
		$this->_path = $this->_translate_uri($path);
		$this->_header_unset();
		$this->_create_basic_request('GET');
		$this->_send_request();
		$this->_get_respond();
		$response = $this->_process_respond();
		if ($response['status']['http-version'] == 'HTTP/1.1' || $response['status']['http-version'] == 'HTTP/1.0') {
			if ($response['status']['status-code'] == 200) {
				$this->_error_log('returning buffer with ' . strlen($response['body']) . ' bytes.');
				$buffer = $response['body'];
			}

			return $response['status']['status-code'];
		}

		return false;
	}

	function put($path, $data)
	{
		$this->_path = $this->_translate_uri($path);
		$this->_header_unset();
		$this->_create_basic_request('PUT');
		$this->_header_add('Content-length: ' . strlen($data));
		$this->_header_add('Content-type: application/octet-stream');
		$this->_send_request();
		fputs($this->_fp, $data);
		$this->_get_respond();
		$response = $this->_process_respond();
		if ($response['status']['http-version'] == 'HTTP/1.1' || $response['status']['http-version'] == 'HTTP/1.0') {
			return $response['status']['status-code'];
		}

		return false;
	}

	function put_file($path, $filename)
	{
		$handle = @fopen($filename, 'r');
		if ($handle) {
			$this->_path = $this->_translate_uri($path);
			$this->_header_unset();
			$this->_create_basic_request('PUT');
			$this->_header_add('Content-length: ' . filesize($filename));
			$this->_header_add('Content-type: application/octet-stream');
			$this->_send_request();
			while (!feof($handle)) {
				fputs($this->_fp, fgets($handle, 4096));
			}

			fclose($handle);
			$this->_get_respond();
			$response = $this->_process_respond();
			if ($response['status']['http-version'] == 'HTTP/1.1' || $response['status']['http-version'] == 'HTTP/1.0') {
				return $response['status']['status-code'];
			}

			return false;
		}
		else {
			$this->_error_log('could not open ' . $filename);
			return false;
		}
	}

	function get_file($srcpath, $localpath)
	{
		if ($this->get($srcpath, $buffer)) {
			$handle = fopen($localpath, 'w');
			if ($handle) {
				fwrite($handle, $buffer);
				fclose($handle);
				return true;
			}
			else {
				return false;
			}
		}
		else {
			return false;
		}
	}

	function copy_file($src_path, $dst_path, $overwrite)
	{
		$this->_path = $this->_translate_uri($src_path);
		$this->_header_unset();
		$this->_create_basic_request('COPY');
		$this->_header_add(sprintf('Destination: http://%s%s', $this->_server, $this->_translate_uri($dst_path)));
		if ($overwrite) {
			$this->_header_add('Overwrite: T');
		}
		else {
			$this->_header_add('Overwrite: F');
		}

		$this->_header_add('');
		$this->_send_request();
		$this->_get_respond();
		$response = $this->_process_respond();
		if ($response['status']['http-version'] == 'HTTP/1.1' || $response['status']['http-version'] == 'HTTP/1.0') {
			return $response['status']['status-code'];
		}

		return false;
	}

	function copy_coll($src_path, $dst_path, $overwrite)
	{
		$this->_path = $this->_translate_uri($src_path);
		$this->_header_unset();
		$this->_create_basic_request('COPY');
		$this->_header_add(sprintf('Destination: http://%s%s', $this->_server, $this->_translate_uri($dst_path)));
		$this->_header_add('Depth: Infinity');
		$xml = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\r\n";
		$xml.= "<d:propertybehavior xmlns:d=\"DAV:\">\r\n";
		$xml.= "  <d:keepalive>*</d:keepalive>\r\n";
		$xml.= "</d:propertybehavior>\r\n";
		$this->_header_add('Content-length: ' . strlen($xml));
		$this->_header_add('Content-type: text/xml');
		$this->_send_request();
		fputs($this->_fp, $xml);
		$this->_get_respond();
		$response = $this->_process_respond();
		if ($response['status']['http-version'] == 'HTTP/1.1' || $response['status']['http-version'] == 'HTTP/1.0') {
			return $response['status']['status-code'];
		}

		return false;
	}

	function move($src_path, $dst_path, $overwrite)
	{
		$this->_path = $this->_translate_uri($src_path);
		$this->_header_unset();
		$this->_create_basic_request('MOVE');
		$this->_header_add(sprintf('Destination: http://%s%s', $this->_server, $dst_path));
		if ($overwrite) {
			$this->_header_add('Overwrite: T');
		}
		else {
			$this->_header_add('Overwrite: F');
		}

		$this->_header_add('');
		$this->_send_request();
		$this->_get_respond();
		$response = $this->_process_respond();
		if ($response['status']['http-version'] == 'HTTP/1.1' || $response['status']['http-version'] == 'HTTP/1.0') {
			return $response['status']['status-code'];
		}

		return false;
	}

	function lock($path)
	{
		$this->_path = $this->_translate_uri($path);
		$this->_header_unset();
		$this->_create_basic_request('LOCK');
		$this->_header_add('Timeout: Infinite');
		$this->_header_add('Content-type: text/xml');
		$xml = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\r\n";
		$xml.= "<D:lockinfo xmlns:D='DAV:'\r\n>";
		$xml.= "  <D:lockscope><D:exclusive/></D:lockscope>\r\n";
		$xml.= "  <D:locktype><D:write/></D:locktype>\r\n";
		$xml.= "  <D:owner>\r\n";
		$xml.= "    <D:href>" . ($this->_user) . "</D:href>\r\n";
		$xml.= "  </D:owner>\r\n";
		$xml.= "</D:lockinfo>\r\n";
		$this->_header_add('Content-length: ' . strlen($xml));
		$this->_send_request();
		fputs($this->_fp, $xml);
		$this->_get_respond();
		$response = $this->_process_respond();
		if ($response['status']['http-version'] == 'HTTP/1.1' || $response['status']['http-version'] == 'HTTP/1.0') {
			switch ($response['status']['status-code']) {
			case 200 :
			if (strcmp($response['header']['Content-Type'], 'text/xml; charset="utf-8"') == 0) {
				$this->_parser = xml_parser_create_ns();
				unset($this->_lock[$this->_parser]);
				unset($this->_xmltree[$this->_parser]);
				xml_parser_set_option($this->_parser, XML_OPTION_SKIP_WHITE, 0);
				xml_parser_set_option($this->_parser, XML_OPTION_CASE_FOLDING, 0);
				xml_set_object($this->_parser, $this);
				xml_set_element_handler($this->_parser, "_lock_startElement", "_endElement");
				xml_set_character_data_handler($this->_parser, "_lock_cdata");
				if (!xml_parse($this->_parser, $response['body'])) {
					die(sprintf("XML error: %s at line %d", xml_error_string(xml_get_error_code($this->_parser)) , xml_get_current_line_number($this->_parser)));
				}

				xml_parser_free($this->_parser);
				$this->_lock[$this->_parser]['status'] = 200;
				return $this->_lock[$this->_parser];
			}
			else {
				print 'Missing Content-Type: text/xml header in response.<br />';
			}

			return false;
		default:
			$this->_lock['status'] = $response['status']['status-code'];
			return $this->_lock;
		}
	}
}

function unlock($path, $locktoken)
{
	$this->_path = $this->_translate_uri($path);
	$this->_header_unset();
	$this->_create_basic_request('UNLOCK');
	$this->_header_add(sprintf('Lock-Token: <%s>', $locktoken));
	$this->_send_request();
	$this->_get_respond();
	$response = $this->_process_respond();
	if ($response['status']['http-version'] == 'HTTP/1.1' || $response['status']['http-version'] == 'HTTP/1.0') {
		return $response['status']['status-code'];
	}

	return false;
}

function delete($path)
{
	$this->_path = $this->_translate_uri($path);
	$this->_header_unset();
	$this->_create_basic_request('DELETE');
	$this->_header_add('');
	$this->_send_request();
	$this->_get_respond();
	$response = $this->_process_respond();
	if ($response['status']['http-version'] == 'HTTP/1.1' || $response['status']['http-version'] == 'HTTP/1.0') {
		switch ($response['status']['status-code']) {
		case 207:
			if (strcmp($response['header']['Content-Type'], 'text/xml; charset="utf-8"') == 0) {
				$this->_parser = xml_parser_create_ns();
				unset($this->_delete[$this->_parser]);
				unset($this->_xmltree[$this->_parser]);
				xml_parser_set_option($this->_parser, XML_OPTION_SKIP_WHITE, 0);
				xml_parser_set_option($this->_parser, XML_OPTION_CASE_FOLDING, 0);
				xml_set_object($this->_parser, $this);
				xml_set_element_handler($this->_parser, "_delete_startElement", "_endElement");
				xml_set_character_data_handler($this->_parser, "_delete_cdata");
				if (!xml_parse($this->_parser, $response['body'])) {
					die(sprintf("XML error: %s at line %d", xml_error_string(xml_get_error_code($this->_parser)) , xml_get_current_line_number($this->_parser)));
				}

				print_r($this->_delete[$this->_parser]);
				print "<br />";
				xml_parser_free($this->_parser);
				$this->_delete[$this->_parser]['status'] = $response['status']['status-code'];
				return $this->_delete[$this->_parser];
			}
			else {
				print 'Missing Content-Type: text/xml header in response.<br />';
			}

			return false;
		default:
			$this->_delete['status'] = $response['status']['status-code'];
			return $this->_delete;
		}
	}
}

function ls($path)
{
	if (trim($path) == '') {
		$this->_error_log('Missing a path in method ls');
		return false;
	}

	$this->_path = $this->_translate_uri($path);
	$this->_header_unset();
	$this->_create_basic_request('PROPFIND');
	$this->_header_add('Depth: 1');
	$this->_header_add('Content-type: text/xml');
	$xml = "<?xml version=\"1.0\"?>\r\n";
	$xml.= "<A:propfind xmlns:A=\"DAV:\">\r\n";
	$xml.= "    <A:allprop/>\r\n";
	$xml.= "</A:propfind>\r\n";
	$this->_header_add('Content-length: ' . strlen($xml));
	$this->_send_request();
	$this->_error_log($xml);
	fputs($this->_fp, $xml);
	$this->_get_respond();
	$response = $this->_process_respond();
	if ($response['status']['http-version'] == 'HTTP/1.1' || $response['status']['http-version'] == 'HTTP/1.0') {
		if (strcmp($response['status']['status-code'], '207') == 0) {
			if (strcmp($response['header']['Content-Type'], 'text/xml; charset="utf-8"') == 0 || strcmp($response['header']['Content-Type'], 'application/xml; charset="utf-8"') == 0) {
				$this->_parser = xml_parser_create_ns();
				unset($this->_ls[$this->_parser]);
				unset($this->_xmltree[$this->_parser]);
				xml_parser_set_option($this->_parser, XML_OPTION_SKIP_WHITE, 0);
				xml_parser_set_option($this->_parser, XML_OPTION_CASE_FOLDING, 0);
				xml_set_object($this->_parser, $this);
				xml_set_element_handler($this->_parser, "_propfind_startElement", "_endElement");
				xml_set_character_data_handler($this->_parser, "_propfind_cdata");
				if (!xml_parse($this->_parser, $response['body'])) {
					die(sprintf("XML error: %s at line %d", xml_error_string(xml_get_error_code($this->_parser)) , xml_get_current_line_number($this->_parser)));
				}

				xml_parser_free($this->_parser);
				return $this->_ls[$this->_parser];
			}
			else {
				$this->_error_log('Missing Content-Type: text/xml header in response!!');
				return false;
			}
		}
	}

	$this->_error_log('Ups in method ls: error in response from server');
	return false;
}

function gpi($path)
{
	$path = rtrim($path, "/");
	$item = basename($path);
	$dir = dirname($path);
	$list = $this->ls($dir);
	if (is_array($list)) {
		foreach($list as $e) {
			$fullpath = urldecode($e['href']);
			$filename = basename($fullpath);
			if ($filename == $item && $filename != "" and $fullpath != $dir . "/") {
				return $e;
			}
		}
	}

	return false;
}

function is_file($path)
{
	$item = $this->gpi($path);
	if ($item === false) {
		return false;
	}
	else {
		return ($item['resourcetype'] != 'collection');
	}
}

function is_dir($path)
{
	$item = $this->gpi($path);
	if ($item === false) {
		return false;
	}
	else {
		return ($item['resourcetype'] == 'collection');
	}
}

function mput($filelist)
{
	$result = true;
	while (list($localpath, $destpath) = each($filelist)) {
		$localpath = rtrim($localpath, "/");
		$destpath = rtrim($destpath, "/");
		if (is_dir($localpath)) {
			$pathparts = explode("/", $destpath . "/ ");
		}
		else {
			$pathparts = explode("/", $destpath);
		}

		$checkpath = "";
		for ($i = 1; $i < sizeof($pathparts) - 1; $i++) {
			$checkpath.= "/" . $pathparts[$i];
			if (!($this->is_dir($checkpath))) {
				$result&= ($this->mkcol($checkpath) == 201);
			}
		}

		if ($result) {
			if (is_dir($localpath)) {
				$dp = opendir($localpath);
				$fl = array();
				while ($filename = readdir($dp)) {
					if ((is_file($localpath . "/" . $filename) || is_dir($localpath . "/" . $filename)) && $filename != "." && $filename != "..") {
						$fl[$localpath . "/" . $filename] = $destpath . "/" . $filename;
					}
				}

				$result&= $this->mput($fl);
			}
			else {
				$result&= ($this->put_file($destpath, $localpath) == 201);
			}
		}
	}

	return $result;
}

function mget($filelist)
{
	$result = true;
	while (list($remotepath, $localpath) = each($filelist)) {
		$localpath = rtrim($localpath, "/");
		$remotepath = rtrim($remotepath, "/");
		if ($this->is_dir($remotepath)) {
			$pathparts = explode("/", $localpath . "/ ");
		}
		else {
			$pathparts = explode("/", $localpath);
		}

		$checkpath = "";
		for ($i = 1; $i < sizeof($pathparts) - 1; $i++) {
			$checkpath.= "/" . $pathparts[$i];
			if (!is_dir($checkpath)) {
				$result&= mkdir($checkpath);
			}
		}

		if ($result) {
			if ($this->is_dir($remotepath)) {
				$list = $this->ls($remotepath);
				$fl = array();
				foreach($list as $e) {
					$fullpath = urldecode($e['href']);
					$filename = basename($fullpath);
					if ($filename != '' and $fullpath != $remotepath . '/') {
						$fl[$remotepath . "/" . $filename] = $localpath . "/" . $filename;
					}
				}

				$result&= $this->mget($fl);
			}
			else {
				$result&= ($this->get_file($remotepath, $localpath));
			}
		}
	}

	return $result;
}

function _endElement($parser, $name)
{
	$this->_xmltree[$parser] = substr($this->_xmltree[$parser], 0, strlen($this->_xmltree[$parser]) - (strlen($name) + 1));
}

function _propfind_startElement($parser, $name, $attrs)
{
	$propname = strtolower($name);
	$this->_xmltree[$parser].= $propname . '_';
	switch ($this->_xmltree[$parser]) {
	case 'dav::multistatus_dav::response_':
		$this->_ls_ref = & $this->_ls[$parser][];
		break;

	case 'dav::multistatus_dav::response_dav::href_':
		$this->_ls_ref_cdata = & $this->_ls_ref['href'];
		break;

	case 'dav::multistatus_dav::response_dav::propstat_dav::prop_dav::creationdate_':
		$this->_ls_ref_cdata = & $this->_ls_ref['creationdate'];
		break;

	case 'dav::multistatus_dav::response_dav::propstat_dav::prop_dav::getlastmodified_':
		$this->_ls_ref_cdata = & $this->_ls_ref['lastmodified'];
		break;

	case 'dav::multistatus_dav::response_dav::propstat_dav::prop_dav::getcontenttype_':
		$this->_ls_ref_cdata = & $this->_ls_ref['getcontenttype'];
		break;

	case 'dav::multistatus_dav::response_dav::propstat_dav::prop_dav::getcontentlength_':
		$this->_ls_ref_cdata = & $this->_ls_ref['getcontentlength'];
		break;

	case 'dav::multistatus_dav::response_dav::propstat_dav::prop_dav::lockdiscovery_dav::activelock_dav::depth_':
		$this->_ls_ref_cdata = & $this->_ls_ref['activelock_depth'];
		break;

	case 'dav::multistatus_dav::response_dav::propstat_dav::prop_dav::lockdiscovery_dav::activelock_dav::owner_dav::href_':
		$this->_ls_ref_cdata = & $this->_ls_ref['activelock_owner'];
		break;

	case 'dav::multistatus_dav::response_dav::propstat_dav::prop_dav::lockdiscovery_dav::activelock_dav::owner_':
		$this->_ls_ref_cdata = & $this->_ls_ref['activelock_owner'];
		break;

	case 'dav::multistatus_dav::response_dav::propstat_dav::prop_dav::lockdiscovery_dav::activelock_dav::timeout_':
		$this->_ls_ref_cdata = & $this->_ls_ref['activelock_timeout'];
		break;

	case 'dav::multistatus_dav::response_dav::propstat_dav::prop_dav::lockdiscovery_dav::activelock_dav::locktoken_dav::href_':
		$this->_ls_ref_cdata = & $this->_ls_ref['activelock_token'];
		break;

	case 'dav::multistatus_dav::response_dav::propstat_dav::prop_dav::lockdiscovery_dav::activelock_dav::locktype_dav::write_':
		$this->_ls_ref_cdata = & $this->_ls_ref['activelock_type'];
		$this->_ls_ref_cdata = 'write';
		$this->_ls_ref_cdata = & $this->_null;
		break;

	case 'dav::multistatus_dav::response_dav::propstat_dav::prop_dav::resourcetype_dav::collection_':
		$this->_ls_ref_cdata = & $this->_ls_ref['resourcetype'];
		$this->_ls_ref_cdata = 'collection';
		$this->_ls_ref_cdata = & $this->_null;
		break;

	case 'dav::multistatus_dav::response_dav::propstat_dav::status_':
		$this->_ls_ref_cdata = & $this->_ls_ref['status'];
		break;

	default:
		$this->_ls_ref_cdata = & $this->_ls_ref[$this->_xmltree[$parser]];
	}
}

function _propfind_cData($parser, $cdata)
{
	if (trim($cdata) <> '') {
		$this->_ls_ref_cdata = $cdata;
	}
	else {
	}
}

function _delete_startElement($parser, $name, $attrs)
{
	$propname = strtolower($name);
	$this->_xmltree[$parser].= $propname . '_';
	switch ($this->_xmltree[$parser]) {
	case 'dav::multistatus_dav::response_':
		$this->_delete_ref = & $this->_delete[$parser][];
		break;

	case 'dav::multistatus_dav::response_dav::href_':
		$this->_delete_ref_cdata = & $this->_ls_ref['href'];
		break;

	default:
		$this->_delete_cdata = & $this->_delete_ref[$this->_xmltree[$parser]];
	}
}

function _delete_cData($parser, $cdata)
{
	if (trim($cdata) <> '') {
		$this->_delete_ref_cdata = $cdata;
	}
	else {
	}
}

function _lock_startElement($parser, $name, $attrs)
{
	$propname = strtolower($name);
	$this->_xmltree[$parser].= $propname . '_';
	switch ($this->_xmltree[$parser]) {
	case 'dav::prop_dav::lockdiscovery_dav::activelock_':
		$this->_lock_ref = & $this->_lock[$parser][];
		break;

	case 'dav::prop_dav::lockdiscovery_dav::activelock_dav::locktype_dav::write_':
		$this->_lock_ref_cdata = & $this->_lock_ref['locktype'];
		$this->_lock_cdata = 'write';
		$this->_lock_cdata = & $this->_null;
		break;

	case 'dav::prop_dav::lockdiscovery_dav::activelock_dav::lockscope_dav::exclusive_':
		$this->_lock_ref_cdata = & $this->_lock_ref['lockscope'];
		$this->_lock_ref_cdata = 'exclusive';
		$this->_lock_ref_cdata = & $this->_null;
		break;

	case 'dav::prop_dav::lockdiscovery_dav::activelock_dav::depth_':
		$this->_lock_ref_cdata = & $this->_lock_ref['depth'];
		break;

	case 'dav::prop_dav::lockdiscovery_dav::activelock_dav::owner_dav::href_':
		$this->_lock_ref_cdata = & $this->_lock_ref['owner'];
		break;

	case 'dav::prop_dav::lockdiscovery_dav::activelock_dav::timeout_':
		$this->_lock_ref_cdata = & $this->_lock_ref['timeout'];
		break;

	case 'dav::prop_dav::lockdiscovery_dav::activelock_dav::locktoken_dav::href_':
		$this->_lock_ref_cdata = & $this->_lock_ref['locktoken'];
		break;

	default:
		$this->_lock_cdata = & $this->_lock_ref[$this->_xmltree[$parser]];
	}
}

function _lock_cData($parser, $cdata)
{
	if (trim($cdata) <> '') {
		$this->_lock_ref_cdata = $cdata;
	}
	else {
	}
}

function _header_add($string)
{
	$this->_req[] = $string;
}

function _header_unset()
{
	unset($this->_req);
}

function _create_basic_request($method)
{
	$request = '';
	$this->_header_add(sprintf('%s %s %s', $method, $this->_path, $this->_protocol));
	$this->_header_add(sprintf('Host: %s', $this->_server));
	$this->_header_add(sprintf('User-Agent: %s', $this->_user_agent));
	$this->_header_add(sprintf('Authorization: Basic %s', base64_encode("$this->_user:$this->_pass")));
}

function _send_request()
{
	if ($this->_connection_closed) {
		$this->close();
		$this->_reopen();
	}

	$buffer = implode("\r\n", $this->_req);
	$buffer.= "\r\n\r\n";
	$this->_error_log($buffer);
	fputs($this->_fp, $buffer);
}

function _get_respond()
{
	$this->_error_log('_get_respond()');
	$buffer = '';
	$header = '';
	$max_chunk_size = 81920;
	if (!$this->_fp) {
		$this->_error_log('socket is not open. Can not process response');
		return false;
	}

	$i = 0;
	do {
		$header.= fread($this->_fp, 1);
		$i++;
	}

	while (!preg_match('/\\r\\n\\r\\n$/', $header) && $i < $this->_maxheaderlenth);
	$this->_error_log($header);
	if (preg_match('/Connection: close\\r\\n/', $header)) {
		$this->_error_log('Connection: close found');
		$this->_connection_closed = true;
	}

	switch (true) {
	case (preg_match('/Transfer\\-Encoding:\\s+chunked\\r\\n/', $header)):
		$this->_error_log('Getting HTTP/1.1 chunked data...');
		do {
			$byte = '';
			$chunk_size = '';
			do {
				$chunk_size.= $byte;
				$byte = fread($this->_fp, 1);
				if (strlen($byte) == 0) {
					$this->_error_log('_get_respond: warning --> read zero bytes');
				}
			}

			while ($byte != "\r" and strlen($byte) > 0);
			fread($this->_fp, 1);
			$chunk_size = hexdec($chunk_size);
			if ($chunk_size > 0) {
				$buffer.= fread($this->_fp, $chunk_size);
			}

			fread($this->_fp, 2);
		}

		while ($chunk_size);
		break;

	case preg_match('/Content\\-Length:\\s+([0-9]*)\\r\\n/', $header, $matches):
		$this->_error_log('Getting data using Content-Length ' . $matches[1]);
		if ($matches[1] <= $max_chunk_size) {
			if ($matches[1] > 0) {
				$buffer = fread($this->_fp, $matches[1]);
			}
			else {
				$buffer = '';
			}
		}
		else {
			fwrite($this->_fp, "Action: Status\r\n\r\n");
			fwrite($this->_fp, "Connection: Close\r\n\r\n");
			while (!feof($this->_fp)) {
				$buffer.= fread($this->_fp, $max_chunk_size);
			}
		}

		break;

	case preg_match('/HTTP\/1\.1\ 204/', $header):
		$this->_error_log('204 No Content found. No further data to read..');
		break;

	default:
		$this->_error_log('reading until feof...' . $header);
		socket_set_timeout($this->_fp, 0);
		while (!feof($this->_fp)) {
			$buffer.= fread($this->_fp, 4096);
		}

		socket_set_timeout($this->_fp, $this->_socket_timeout);
	}

	$this->_header = $header;
	$this->_body = $buffer;
	$this->_error_log($this->_header);
}

function _process_respond()
{
	$lines = explode("\r\n", $this->_header);
	$header_done = false;
	list($ret_struct['status']['http-version'], $ret_struct['status']['status-code'], $ret_struct['status']['reason-phrase']) = explode(' ', $lines[0], 3);
	for ($i = 1; $i < count($lines); $i++) {
		if (rtrim($lines[$i]) == '' && !$header_done) {
			$header_done = true;
		}

		if (!$header_done) {
			$lines[$i] = str_replace("http:/", "http+++/", $lines[$i]);
			list($fieldname, $fieldvalue) = explode(':', $lines[$i]);
			$fieldname = str_replace("http+++/", "http:/", $fieldname);
			$fieldvalue = str_replace("http+++/", "http:/", $fieldvalue);
			if (!$ret_struct['header'][$fieldname]) {
				$ret_struct['header'][$fieldname] = trim($fieldvalue);
			}
			else {
				$ret_struct['header'][$fieldname].= ',' . trim($fieldvalue);
			}
		}
	}

	$ret_struct['body'] = $this->_body;
	return $ret_struct;
}

function _reopen()
{
	$this->_error_log('reopen a socket connection');
	return $this->open();
}

function _translate_uri($uri)
{
	$native_path = html_entity_decode($uri);
	$parts = explode('/', $native_path);
	for ($i = 0; $i < count($parts); $i++) {
		$parts[$i] = rawurlencode($parts[$i]);
	}

	return implode('/', $parts);
}

function _error_log($err_string)
{
	if ($this->_debug) {
		error_log($err_string);
	}
}

function filePublish($path)
{
	$this->_path = $this->_translate_uri($path) . "?publish";
	$this->_header_unset();
	$this->_create_basic_request('POST');
	$this->_send_request();
	$this->_get_respond();
	$response = $this->_process_respond();
	if ($response['status']['status-code'] == '302') {
		return $response['header']['Location'];
	}
	else {
		return FALSE;
	}
}

function fileUnPublish($path)
{
	$this->_path = $this->_translate_uri($path) . "?unpublish";
	$this->_header_unset();
	$this->_create_basic_request('POST');
	$this->_send_request();
	$this->_get_respond();
	$response = $this->_process_respond();
	if ($response['status']['status-code'] == '200') {
		return TRUE;
	}
	else {
		return FALSE;
	}
}
}

class mysitebackup_yandexdisk

{
	var $login = '';
	var $password = '';
	var $cookie = '';
	var $webdav = null;
	function mysitebackup_yandexdisk($email, $password)
	{
		$this->webdav = new yandex_webdav_client();
		$this->webdav->set_server('ssl://webdav.yandex.ru');
		$this->webdav->set_port(443);
		$this->webdav->set_user($email);
		$this->webdav->set_pass($password);
		$this->webdav->set_protocol(1);
		$this->webdav->set_debug(true);
	}

	function upload($filename, $dir = '')
	{
		if (!$this->webdav->open()) throw new Exception('Error: could not open server connection');
		if (!$this->webdav->check_webdav()) throw new Exception('Error: server does not support webdav or user/password may be wrong');
		if ($dir != '') $this->webdav->mkcol('/' . $dir);
		$http_status = $this->webdav->put_file(($dir == '' ? '' : "/" . $dir) . "/" . basename($filename) , $filename);
		if (!$http_status) throw new Exception('Error: Unauthorized or more error');
		return true;
	}
};