var leftAlignedElements = new Array();
leftAlignedElements[0] = fullscreenButton;
leftAlignedElements[1] = zoomButton;
leftAlignedElements[2] = gotoPage;

var centerAlignedElements = new Array();
centerAlignedElements[0] = firstButton;
centerAlignedElements[1] = previousButton;
centerAlignedElements[2] = slideshowPlayButton;
centerAlignedElements[3] = slideshowPauseButton;
centerAlignedElements[4] = nextButton;
centerAlignedElements[5] = lastButton;

var rightAlignedElements = new Array();
rightAlignedElements[0] = printButton;
rightAlignedElements[1] = downloadButton;
rightAlignedElements[2] = soundControl;

initItems();
repositionElements();
onPutPage(leftPageNumber,rightPageNumber);

function onPutPage(leftPageNumber, rightPageNumber) {
	if ((leftPageNumber != undefined) && (_root.pageLinksSet[leftPageNumber - 1] != "") && (_root.pageLinksSet[leftPageNumber - 1] != undefined)) {
		lPageLink._visible = true;
		lPageLink.onRelease = function() {
			getURL(_root.pageLinksSet[leftPageNumber - 1]);
		}
	} else {
		lPageLink._visible = false;
	}
	if ((rightPageNumber != undefined) && (_root.pageLinksSet[rightPageNumber - 1] != "") && (_root.pageLinksSet[rightPageNumber - 1] != undefined)) {
		rPageLink._visible = true;
		rPageLink.onRelease = function() {
			getURL(_root.pageLinksSet[rightPageNumber - 1]);
		}
	} else {
		rPageLink._visible = false;
	}
	gotoPage.gotoPageField.text = "";
	if (leftPageNumber != undefined) {
		if (_root.direction == "RTL")
			gotoPage.gotoPageField.text = _root.totalPages() - leftPageNumber + 1;
		else
			gotoPage.gotoPageField.text = leftPageNumber;
	}
	if ((leftPageNumber != undefined) && (rightPageNumber != undefined)) {
		gotoPage.gotoPageField.text += "-";
	}
	if (rightPageNumber != undefined) {
		if (_root.direction == "RTL")
			gotoPage.gotoPageField.text += _root.totalPages() - rightPageNumber + 1;
		else
			gotoPage.gotoPageField.text += rightPageNumber;
	}
}

function repositionElements() {
	var leftAlignedElementsXOffset:Number;
	leftAlignedElementsXOffset = 10;
	for (i = 0; i < leftAlignedElements.length; i++) {
		if (leftAlignedElements[i]._visible == true) {
			leftAlignedElements[i]._x = leftAlignedElementsXOffset;
			leftAlignedElementsXOffset += leftAlignedElements[i]._width;
		}
	}
	var centerAlignedElementsXOffset:Number = Math.round(Stage.width / 2 - getTotalItemsWidth(centerAlignedElements) / 2);
	if (centerAlignedElementsXOffset < leftAlignedElementsXOffset) //prevent overlap of buttons
		centerAlignedElementsXOffset = leftAlignedElementsXOffset;
	for (i = 0; i < centerAlignedElements.length; i++) {
		if (centerAlignedElements[i]._visible == true) {
			centerAlignedElements[i]._x = centerAlignedElementsXOffset;
			centerAlignedElementsXOffset += centerAlignedElements[i]._width;
		}
	}
	var rightAlignedElementsXOffset:Number = Math.round(Stage.width - getTotalItemsWidth(rightAlignedElements)) - 10;
	if (rightAlignedElementsXOffset < centerAlignedElementsXOffset) //prevent overlap of buttons
		rightAlignedElementsXOffset = centerAlignedElementsXOffset;
	for (i = 0; i < rightAlignedElements.length; i++) {
		if (rightAlignedElements[i]._visible == true) {
			rightAlignedElements[i]._x = rightAlignedElementsXOffset;
			rightAlignedElementsXOffset += rightAlignedElements[i]._width;
		}
	}
	lPageLink._x = Math.round(Stage.width / 2 - getTotalItemsWidth(centerAlignedElements) / 2) - lPageLink._width;
	rPageLink._x = Math.round(Stage.width / 2 + getTotalItemsWidth(centerAlignedElements) / 2);
	backgroundImage._width = Stage.width;
}

function initItems() {
	Stage.addListener(this);
	this.onResize = repositionElements;
	gotoPage.totalPagesField.text = _root.totalPages();
	gotoPage.gotoPageButton._focusrect = false;

	//INIT VISIBILITY
	if (_root.fullscreenEnabled == false) {
		fullscreenButton._visible = false;
	}

	if (_root.zoomEnabled == false) {
		zoomButton._visible = false;
	}
	
	if (_root.zoomingMethod == "ajax") {
		zoomButton._visible = false;
	}
		
	if (_root.printEnabled == false) {
		printButton._visible = false;
	}

	if (_root.downloadURL == "") {
		downloadButton._visible = false;
	}
	
	if (_root.firstLastButtons == false) {
		firstButton._visible = false;
		lastButton._visible = false;
	}
	
	if (_root.slideshowButton == true) {
		slideshowPlayButton._visible = true;
		slideshowPauseButton._visible = false;
		if (_root.slideshowAutoPlay == true) {
			slideshowPauseButton._visible = true;
			slideshowPlayButton._visible = false;
		} else {
			slideshowPauseButton._visible = false;
			slideshowPlayButton._visible = true;
		}
	} else {
		slideshowPlayButton._visible = false;
		slideshowPauseButton._visible = false;
	}

	if (_root.goToPageField == false) {
		gotoPage._visible = false;
	}

	if (_root.soundControlButton == false) {
		soundControl._visible = false;
	}
	
	//ACTIONS OF BUTTONS     
	fullscreenButton.onRelease = function() {
		if (Stage.displayState == "fullScreen") {
			Stage.displayState = "normal";
			gotoPage.gotoPageField.selectable = true;
		} else {
			Stage.displayState = "fullScreen";
			gotoPage.gotoPageField.selectable = false;
		}
	}
	
	fullscreenButton.onRollOver = function() {
		if (Stage.displayState == "normal") {
			fullscreenButton.gotoAndPlay(2);
		}
		if (Stage.displayState == "fullScreen") {
			fullscreenButton.gotoAndPlay(9);
		}
	}
	
	fullscreenButton.onRollOut = function() {
		if (Stage.displayState == "normal") {
			fullscreenButton.gotoAndStop(1);
		}
		if (Stage.displayState == "fullScreen") {
			fullscreenButton.gotoAndStop(9);
		}
	}

	zoomButton.onRelease = function() {
		_root.zoomIn();
	}

	Key.addListener(gotoPage.gotoPageField);
	gotoPage.gotoPageField.onKeyDown = function() {
		if (Key.isDown(Key.ENTER)) {
			flipToPage();
		}
	}

	gotoPage.gotoPageButton.onRelease = function() {
		flipToPage();
		Selection.setFocus(gotoPage.gotoPageButton);
	}

	firstButton.onRelease = function() {
		if (_root.direction == "RTL")
			_root.flipGotoPage(_root.totalPages());
		else
			_root.flipGotoPage(0);
	}

	previousButton.onRelease = function() {
		if (_root.direction == "RTL")
			_root.flipForward();
		else
			_root.flipBack();
	}

	slideshowPlayButton.onRelease = function() {
		_root.switchSlideshow();
		slideshowPlayButton._visible = false;
		slideshowPauseButton._visible = true;
		repositionElements();
	}

	slideshowPauseButton.onRelease = function() {
		_root.switchSlideshow();
		slideshowPlayButton._visible = true;
		slideshowPauseButton._visible = false;
		repositionElements();
	}

	nextButton.onRelease = function() {
		if (_root.direction == "RTL")
			_root.flipBack();
		else
			_root.flipForward();
	}

	lastButton.onRelease = function() {
		if (_root.direction == "RTL")
			_root.flipGotoPage(0);
		else
			_root.flipGotoPage(_root.totalPages());
	}

	printButton.onRelease = function() {
		_root.print();
	}

	downloadButton.onRelease = function() {
		_root.download();
	}
	
	var soundClass = new Sound();
	soundControl.soundButton.onRelease = function() {
		if (soundClass.getVolume() == 0) {
			soundClass.setVolume(100);
			soundControl.gotoAndStop (1);
		} else {
			soundClass.setVolume(0);
			soundControl.gotoAndStop (2);
		}
	}
}

function flipToPage() {
	if (gotoPage.gotoPageField.text != "") {
		var index = gotoPage.gotoPageField.text.indexOf("-");
		if (index == -1) {
			if (_root.direction == "RTL")
				_root.flipGotoPage(_root.totalPages() - gotoPage.gotoPageField.text + 1);
			else
				_root.flipGotoPage(gotoPage.gotoPageField.text);
		} else {
			if (_root.direction == "RTL")
				_root.flipGotoPage(_root.totalPages() - gotoPage.gotoPageField.text.substr(0, index) + 1);
			else
				_root.flipGotoPage(gotoPage.gotoPageField.text.substr(0, index));
		}
	}
}

function getTotalItemsWidth(itemsSet) {
	var totalWidth:Number = 0;
	for (i = 0; i < itemsSet.length; i++) {
		if (itemsSet[i]._visible == true) {
			totalWidth += itemsSet[i]._width;
		}
	}
	return totalWidth;
}
stop()