<?php
/* * *************************************************************************** */
//                                                                            //
//                             InstantCMS v1.10                               //
//                        http://www.instantcms.ru/                           //
//                                                                            //
//                   written by InstantCMS Team, 2007-2013                    //
//                produced by InstantSoft, (www.instantsoft.ru)               //
//                                                                            //
//                        LICENSED BY GNU/GPL v2                              //
//                                                                            //
/* * *************************************************************************** */

session_start();
setlocale(LC_ALL, "ru_RU.UTF-8");
header('Content-Type: text/html; charset=utf-8');

define('VALID_CMS', 1);
define('PATH', $_SERVER['DOCUMENT_ROOT']);
define('HOST', 'http://' . $_SERVER['HTTP_HOST']);
include(PATH . '/core/cms.php');
cmsCore::includeFile('install/function.php');
cmsCore::loadClass('config');
cmsCore::loadClass('db');
cmsCore::loadClass('user');
cmsCore::loadClass('page');
cmsCore::loadClass('actions');
$inConf = cmsConfig::getInstance();

$installed = false;

////////////////////// процесс установки ////////////////////////////////////////
if (cmsCore::inRequest('install')) {

    $errors = false;

    $_CFG['sitename'] = cmsCore::request('sitename', 'html', 'Мой сайт');
    $_CFG['db_host'] = cmsCore::request('db_server', 'html', '');
    $_CFG['db_base'] = cmsCore::request('db_base', 'html', '');
    $_CFG['db_user'] = cmsCore::request('db_user', 'html', '');
    $_CFG['db_pass'] = cmsCore::request('db_password', 'html', '');
    $_CFG['db_prefix'] = cmsCore::request('db_prefix', 'html', '');
    $sql_file = PATH . '/install/' . (cmsCore::request('demodata', 'int') ? 'sqldumpdemo.sql' : 'sqldumpempty.sql');

    $admin_login    = cmsCore::request('admin_login', 'html', '');
    $admin_password = cmsCore::request('admin_password', 'html', '');

    if (!$_CFG['db_host']) {
        cmsCore::addSessionMessage('Необходимо указать сервер БД!', 'error');
        $errors = true;
    }
    if (!$_CFG['db_base']) {
        cmsCore::addSessionMessage('Необходимо указать название БД!', 'error');
        $errors = true;
    }
    if (!$_CFG['db_user']) {
        cmsCore::addSessionMessage('Необходимо указать пользователя БД!', 'error');
        $errors = true;
    }
    if (!$_CFG['db_prefix']) {
        cmsCore::addSessionMessage('Необходимо указать префикс БД!', 'error');
        $errors = true;
    }
    if (mb_strlen($admin_login) < 3) {
        cmsCore::addSessionMessage('Необходимо указать логин администратора, не менее 3-х символов!', 'error');
        $errors = true;
    }
    if (mb_strlen($admin_password) < 6) {
        cmsCore::addSessionMessage('Необходимо указать пароль администратора, не менее 6-ти символов!', 'error');
        $errors = true;
    }

    if ($errors) {
        cmsCore::redirect('/install/');
    }

    $inConf->db_host   = $_CFG['db_host'];
    $inConf->db_user   = $_CFG['db_user'];
    $inConf->db_pass   = $_CFG['db_pass'];
    $inConf->db_base   = $_CFG['db_base'];
    $inConf->db_prefix = $_CFG['db_prefix'];

    $inDB = cmsDatabase::getInstance();

    $inDB->importFromFile($sql_file);

    $d_cfg = $inConf->getDefaultConfig();
    $_CFG = array_merge($d_cfg, $_CFG);
    $inConf->saveToFile($_CFG);

    $sql = "UPDATE cms_users SET password = md5('{$admin_password}'), login = '{$admin_login}' WHERE id = 1";
    $inDB->query($sql);
    $sql = "UPDATE cms_users SET password = md5('{$admin_password}') WHERE id > 1";
    $inDB->query($sql);

    $installed = true;

    cmsCore::getInstance();
    $inUser = cmsUser::getInstance();
    $inUser->update();
    $inUser->signInUser($admin_login, $admin_password, true);

}
// =================================================================================================== //

$info        = check_requirements();
$permissions = check_permissions();
?>

<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
        <title>InstantCMS - Установка</title>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
        <script src='/includes/jquery/jquery.js' type='text/javascript'></script>
        <script src='/install/js/jquery.wizard.js' type='text/javascript'></script>
        <script src='/install/js/install.js' type='text/javascript'></script>
        <link type='text/css' href='/install/css/styles.css' rel='stylesheet' media='screen' />
    </head>

    <body>
        <table id="wrapper" align="center">
            <tr>
                <td>
                    <h1 id="header">
                        Установка InstantCMS <?php echo CORE_VERSION; ?>
                    </h1>
                    <?php if (!$installed) { ?>
                        <!-- ================================================================ -->
                        <form class="wizard" action="#" method="post" >
                            <div class="wizard-nav"  align="center">
                                <a href="#start">Начало</a>
                                <a href="#php">Проверка PHP</a>
                                <a href="#folders">Проверка прав</a>
                                <a href="#install">Установка</a>
                            </div>
                            <?php $messages = cmsCore::getSessionMessages(); ?>
                            <?php if ($messages) { ?>
                                <div class="sess_messages">
                                    <?php foreach ($messages as $message) { ?>
                                        <?php echo $message; ?>
                                    <?php } ?>
                                </div>
                            <?php } ?>
                            <div id="start" class="wizardpage">
                                <h2>Добро пожаловать</h2>
                                <img src="/install/images/start.png" />
                                <p>Cкрипт установки проверит сервер на соответствие техническим требованиям и совершит все
                                    необходимые действия для начала работы с InstantCMS.</p>
                                <p>Устанавливать InstantCMS можно только в корневую директорию сайта.</p>
                                <p>Перед началом установки создайте новую базу данных MySQL на вашем хостинге. Сравнение (COLLATION) должно быть любое из utf8_* согласно ваших потребностей. В большинстве случаев это utf8_general_ci.</p>
                                <p>Как установить систему на локальный компьютер с ОС Windows&trade; для тестирования, читайте в <a href="http://www.instantcms.ru/wiki/doku.php/локальная_установка_денвер" target="_blank">инструкции</a> на официальном сайте.</p>
                                <p>InstantCMS распространяется по лицензии GNU/GPL версии 2. Вы должны согласиться с условиями этой лицензии для установки системы.</p>
                                <p>
                                    <label><input type="checkbox" id="license_agree" onClick="checkAgree()" /> Я согласен с условиями <a target="_blank" href="/license.rus.txt">лицензии GNU/GPL</a> (<a target="_blank" href="http://www.gnu.org/licenses/gpl-2.0.html">оригинал на английском</a>).</label>
                                </p>
                            </div>
                            <!-- ================================================================ -->
                            <div id="php" class="wizardpage">
                                <h2>Проверка расширений PHP</h2>
                                <img src="/install/images/extensions.png" />
                                <p>Для корректной работы InstantCMS необходим php интерпретатор версии не ниже 5.2.0, веб сервер Apache + mod_rewrite (возможно использовать и чистый nginx, однако правила .htaccess необходимо переписать согласно документации), сервер баз данных MySQL не ниже 5 версии.<br>Ниже указана текущая версия php, перечислены требуемые расширения и их статус наличия.</p>
                                <h3>Версия PHP интерпретатора</h3>
                                <table class="grid">
                                    <tr>
                                        <td>Установленная версия</td>
                                        <td class="value">
                                            <?php echo html_bool_span($info['php']['version'], $info['php']['valid']); ?>
                                        </td>
                                    </tr>
                                </table>
                                <h3>Требуемые расширения PHP</h3>
                                <table class="grid">
                                <?php foreach ($info['ext'] as $name => $valid) { ?>
                                    <tr>
                                        <td><a href="http://ru2.php.net/manual/ru/book.<?php echo str_replace('math', '', $name) ?>.php" target="_blank" title="Посмотреть описание на сайте PHP"><?php echo $name ?></a></td>
                                        <td class="value">
                                        <?php if ($valid) { ?>
                                            <?php echo html_bool_span('Установлено', $valid); ?>
                                        <?php } else { ?>
                                            <?php echo html_bool_span('Не найдено', $valid); ?>
                                        <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>
                                </table>
                            </div>
                            <!-- ================================================================ -->
                            <div id="folders" class="wizardpage">
                                <h2>Проверка прав на папки</h2>
                                <img src="/install/images/folders.png" border="0" />
                                <p>Для корректной работы InstantCMS указанные ниже папки (и вложенные в них, но за исключением вложенных в "/includes") должны быть доступны для записи. Сменить права можно с помощью FTP-клиента или же непосредственно на сервере при помощи chmod.</p>
                                <p>Для успешного завершения установки необходимы как минимум права на запись для директории "/includes". Для остальных директорий допустимо игнорирование предупреждения о недоступности прав на запись, но только на момент установки.</p>
                                <p>Обращаем ваше внимание на то, что сразу после установки, на директорию "/includes" в целях безопасности права на запись необходимо снять. А после основного конфигурирования сайта сделать недоступным для записи файл /includes/config.inc.php</p>
                                <table class="grid">
                                <?php foreach ($permissions as $name => $permission) { ?>
                                    <tr>
                                        <td>/<?php echo $name;
                                            echo $permission['perm'] ? ' | текущие права доступа ' . $permission['perm'] : ''; ?></td>
                                        <td class="value">
                                        <?php if ($permission['valid']) { ?>
                                            <?php echo html_bool_span('доступна для записи', $permission['valid']); ?>
                                        <?php } else { ?>
                                            <?php echo html_bool_span('недоступна для записи', $permission['valid']); ?>
                                        <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>
                                </table>
                            </div>
                            <!-- ================================================================ -->
                            <div id="install" class="wizardpage">
                                <h2>Установка</h2>
                                <p>Заполните форму и нажмите "Установить" для завершения процесса.</p>
                                <table cellpadding="0" cellspacing="0" border="0" width="100%">
                                    <tr>
                                        <td width="140" valign="top">
                                            <img src="/install/images/install.png" />
                                        </td>
                                        <td valign="top">
                                            <table width="" border="0" cellpadding="4" cellspacing="0" style="margin-bottom:10px">
                                                <tr>
                                                    <td width="210">Название сайта:</td>
                                                    <td width="" align="center"><input name="sitename" type="text" class="txt" value="Моя социальная сеть"></td>
                                                </tr>
                                                <tr>
                                                    <td>Логин администратора сайта:</td>
                                                    <td align="center"><input name="admin_login" type="text" class="txt" value="admin"></td>
                                                </tr>
                                                <tr>
                                                    <td>Пароль администратора сайта:</td>
                                                    <td align="center"><input name="admin_password" type="password" placeholder="не менее 6-ти символов" class="txt"></td>
                                                </tr>
                                                <tr>
                                                    <td>Сервер MySQL: </td>
                                                    <td align="center"><input name="db_server" type="text" class="txt" value="localhost"></td>
                                                </tr>
                                                <tr>
                                                    <td>Название базы данных: </td>
                                                    <td align="center"><input name="db_base" type="text" class="txt"></td>
                                                </tr>
                                                <tr>
                                                    <td>Пользователь БД: </td>
                                                    <td align="center"><input name="db_user" type="text" class="txt" value=""></td>
                                                </tr>
                                                <tr>
                                                    <td>Пароль пользователя БД: </td>
                                                    <td align="center"><input name="db_password" type="password" class="txt"></td>
                                                </tr>
                                                <tr>
                                                    <td>Префикс таблиц в базе данных: </td>
                                                    <td align="center"><input name="db_prefix" type="text" class="txt" value="cms"></td>
                                                </tr>
                                                <tr>
                                                    <td>Демо-данные:</td>
                                                    <td align="center" valign="top">
                                                        <label><input name="demodata" type="radio" value="1" checked /> Да</label>
                                                        <label><input name="demodata" type="radio" value="0" /> Нет</label>
                                                    </td>
                                                </tr>
                                            </table>
                                        </td>
                                    </tr>
                                </table>
                                <p>
                                    При установке с демо-данными всем пользователям будет установлен одинаковый пароль, совпадающий с паролем администратора. Логин каждого пользователя можно узнать из адреса его профиля или из панели управления.
                                </p>
                                <p>Установка может занять от секунд до нескольких минут, в зависимости от скорости вашего сервера.</p>
                            </div>
                        </form>
<?php } else { ?>
                        <div class="sess_messages">
                            <div class="message_success">Поздравляем, установка завершена! Система установлена и готова к работе.</div>
                        </div>
                        <div style="margin-left:52px;_margin-left:0px">
                            <div style="background:url(/install/images/cron.png) no-repeat;padding-left:24px;margin-top:30px;">
                                <div style="margin-bottom:6px;"><strong>Создайте задание для CRON</strong></div>
                                <div>
                                    Добавьте файл <strong>/cron.php</strong> в расписание заданий CRON в панели вашего хостинга.<br/>
                                    Интервал выполнения &mdash; 24 часа. Это позволит системе выполнять периодические сервисные задачи.
                                    Возможная команда, которую нужно добавить в CRON, выглядит так:
                                    <pre class="cron">  php -f <?php echo PATH; ?>/cron.php > /dev/null</pre>
                                </div>
                                <div>
                                    В случае затруднений обратитесь в техническую поддержку хостинга.
                                </div>
                            </div>
                            <div style="background:url(/install/images/info.png) no-repeat;padding-left:24px;margin:10px 0 20px;">
                                <div style="margin-bottom:6px;"><strong>Внимание!</strong></div>
                                До перехода на сайт необходимо удалить каталоги "install" и "migrate"<br/>
                                на сервере вместе со всеми находящимися в них файлами!
                            </div>
                            <p class="result_link">
                                <a href="/">Перейти на сайт</a>  <a href="/admin">Панель управления</a>
                                <a id="tutorial" target="_blank" href="http://www.instantcms.ru/articles/quickstart.html">Учебник для начинающих</a>
                                <a id="video" target="_blank" href="http://www.instantcms.ru/video-lessons.html">Видео-уроки</a>
                            </p>
                        </div>
<?php } ?>
                    <div id="footer">
                        <a href="http://www.instantcms.ru/" target="_blank">InstantCMS</a>, <a href="http://instantsoft.ru/" target="_blank">InstantSoft</a> &copy; 2007-<?php echo date('Y'); ?>
                    </div>
                </td></tr></table>
    </body>
</html>