<?php
/******************************************************************************/
//                                                                            //
//                             InstantCMS v1.10                               //
//                        http://www.instantcms.ru/                           //
//                                                                            //
//                   written by InstantCMS Team, 2007-2012                    //
//                produced by InstantSoft, (www.instantsoft.ru)               //
//                                                                            //
//                        LICENSED BY GNU/GPL v2                              //
//                                                                            //
/******************************************************************************/

	@set_time_limit(0);

    session_start();

    header('Content-Type: text/html; charset=utf-8');
    define('VALID_CMS', 1);

    define('PATH', $_SERVER['DOCUMENT_ROOT']);

    include(PATH.'/core/cms.php');
    $inCore = cmsCore::getInstance();

    define('HOST', 'http://' . $inCore->getHost());

    cmsCore::loadClass('user');
	cmsCore::loadClass('cron');
	cmsCore::loadClass('actions');
    cmsCore::loadClass('page');

    $inConf = cmsConfig::getInstance();
    $inDB   = cmsDatabase::getInstance();

    // принудительно включаем дебаг
    $inConf->debug = 1;

    $version_prev = '1.10.1';
    $version_next = '1.10.2';

// ========================================================================== //
// ========================================================================== //
?>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<title>InstantCMS - Миграция</title>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
</head>

<body>
<style type="text/css">
	body { font-family:Arial; font-size:14px; }

	a { color: #0099CC; }
	a:hover { color: #375E93; }
	h2 { color: #375E93; }

	#wrapper { padding:10px 30px; }
	#wrapper p{ line-height: 20px; }

	.migrate p {
				   line-height:16px;
				   padding-left:20px;
				   margin:2px;
				   margin-left:20px;
				   background:url(/admin/images/actions/on.gif) no-repeat;
			   }
	.migrate p.info {
                   font-size: 16px;
				   background: none;
                   color: #C00;
			   }
	.important {
				   margin:20px;
				   margin-left:0px;
				   border:solid 1px silver;
				   padding:15px;
				   padding-left:65px;
				   background:url(important.png) no-repeat 15px 15px;
			   }
	 .nextlink {
				   margin-top:15px;
				   font-size:18px;
	 }
  </style>
<div id="wrapper" class="migrate">
<?php
    echo "<h2>Миграция InstantCMS {$version_prev} &rarr; {$version_next}</h2>";

	if(!cmsCore::inRequest('go')){
		echo '<h3><a href="/migrate/index.php?go=1">начать миграцию...</a></h3>';
		exit;
	}

// ========================================================================== //
// ========================================================================== //
	$step = cmsCore::request('go', 'int', 0);

    echo '<h3>Шаг № '.$step.'</h3>';

// ========================================================================== //
// ========================================================================== //

	if($step == 1){

        // ========================================================================== //
        // ========================================================================== //

        $result = $inDB->query("SELECT id, fieldsdata FROM cms_uc_items");

        if ($inDB->num_rows($result)){

            while($item = $inDB->fetch_assoc($result)){

                $cfg = @unserialize($item['fieldsdata']);
                $config_yaml = ($cfg) ? cmsCore::arrayToYaml($cfg) : "---\n";
                $cfg_db = $inDB->escape_string($config_yaml);
                $inDB->query("UPDATE cms_uc_items SET fieldsdata='{$cfg_db}' WHERE id='{$item['id']}'");

            }

        }

        echo '<p>Значения полей категорий каталога переведены в формат YAML.</p>';

        // ========================================================================== //
        // ========================================================================== //

        $result = $inDB->query("SELECT id, fieldsstruct FROM cms_uc_cats");

        if ($inDB->num_rows($result)){

            while($item = $inDB->fetch_assoc($result)){

                $cfg = @unserialize($item['fieldsstruct']);
                $config_yaml = ($cfg) ? cmsCore::arrayToYaml($cfg) : "---\n";
                $cfg_db = $inDB->escape_string($config_yaml);
                $inDB->query("UPDATE cms_uc_cats SET fieldsstruct='{$cfg_db}' WHERE id='{$item['id']}'");

            }

        }

        echo '<p>Поля категорий каталога переведены в формат YAML.</p>';

        // ========================================================================== //
        // ========================================================================== //
        if(!$inDB->rows_count('cms_components', "link='files'", 1)){

            $inDB->query("INSERT INTO `cms_components` (`title`, `link`, `config`, `internal`, `author`, `published`, `version`, `system`) VALUES ('Скачивание и редирект', 'files', '', 1, 'InstantCMS team', 1, '1.10', 1), ('Голосования', 'polls', '', 1, 'InstantCMS team', 1, '1.10', 1), ('Подписки', 'subscribes', '', 1, 'InstantCMS team', 1, '1.10', 1);");

        }
        // ========================================================================== //
        // ========================================================================== //
        if(!$inDB->rows_count('cms_components', "link='statistics'", 1)){

            $inDB->query("DELETE FROM `cms_components` WHERE `link` = 'statistics'");

            echo '<p>Удален компонент статистика сайта.</p>';

        }

		$inDB->query("UPDATE `cms_modules` SET `name` = 'Записи в каталоге', `title` = 'Записи в каталоге',`content` = 'mod_uc' WHERE `content` = 'mod_uc_popular'");
		$inDB->query("UPDATE `cms_modules` SET `published` = 0 WHERE `content` = 'mod_uc_latest'");

        echo '<p>Модуль "Популярное в каталоге" удален из системы, необходимо удалить сопутствующие файлы.</p>';
        echo '<p>Модуль "Новинки каталога" снят с публикации.</p>';
        echo '<p>Модуль "Записи в каталоге" добавлен в систему. Он объединяет в себе два модуля - "Популярное в каталоге" и "Новинки каталога". Модуль находится в той же позиции, в которой у вас был модуль "Популярное в каталоге".</p>';

        // ========================================================================== //
        // ========================================================================== //

        cmsDatabase::optimizeTables();
		echo '<div style="margin:15px 0px;font-weight:bold">Миграция завершена. Удалите папку /migrate/ прежде чем продолжить!</div>';
		echo '<div style="margin:15px 0px;">Файлы и директории, которые удалены из дистрибутива:</div>';
		echo '<ul>';
		echo '<li>/admin/components/price</li>';
		echo '<li>/admin/components/statistics</li>';
		echo '<li>/admin/components/price/backend.php</li>';
		echo '<li>/admin/components/statistics/backend.php</li>';
		echo '<li>/admin/images/components/price.png</li>';
		echo '<li>/admin/images/components/statistics.png</li>';
		echo '<li>/admin/images/toolmenu/calendar.gif</li>';
		echo '<li>/admin/images/toolmenu/clock.gif</li>';
		echo '<li>/admin/images/toolmenu/refers.gif</li>';
		echo '<li>/admin/modules/mod_pricecat</li>';
		echo '<li>/admin/modules/mod_uc_latest</li>';
		echo '<li>/admin/modules/mod_uc_popular</li>';
		echo '<li>/admin/modules/mod_pricecat/backend.xml</li>';
		echo '<li>/admin/modules/mod_uc_latest/backend.xml</li>';
		echo '<li>/admin/modules/mod_uc_popular/backend.xml</li>';
		echo '<li>/components/price</li>';
		echo '<li>/components/price/cart.php</li>';
		echo '<li>/components/price/common.js</li>';
		echo '<li>/components/price/frontend.php</li>';
		echo '<li>/components/price/psearch.php</li>';
		echo '<li>/components/price/router.php</li>';
		echo '<li>/components/users/plugins</li>';
		echo '<li>/components/users/plugins/get_demo.php</li>';
		echo '<li>/images/markers/priceitem.png</li>';
		echo '<li>/images/markers/pricelist.png</li>';
		echo '<li>/includes/dbexport.inc.php</li>';
		echo '<li>/includes/phpmailer/phpmailer.php</li>';
		echo '<li>/includes/phpmailer/language/phpmailer.lang-en.php</li>';
		echo '<li>/languages/ru/components/price.php</li>';
		echo '<li>/languages/ru/modules/mod_uc_latest.php</li>';
		echo '<li>/languages/ru/modules/mod_uc_popular.php</li>';
		echo '<li>/modules/mod_pricecat</li>';
		echo '<li>/modules/mod_uc_latest</li>';
		echo '<li>/modules/mod_uc_popular</li>';
		echo '<li>/modules/mod_pricecat/module.php</li>';
		echo '<li>/modules/mod_uc_latest/module.php</li>';
		echo '<li>/modules/mod_uc_popular/module.php</li>';
		echo '<li>/templates/_default_/modules/mod_latest_uc.tpl</li>';
		echo '<li>/templates/_default_/modules/mod_pricecat.tpl</li>';
		echo '<li>/templates/_default_/modules/mod_uc_popular.tpl</li>';
		echo '</ul>';
		echo '<div class="nextlink"><a href="/">Перейти на сайт</a></div>';

	}
// ========================================================================== //
// ========================================================================== //

    echo '</div></body></html>';

?>