<?php
/******************************************************************************/
//                                                                            //
//                             InstantCMS v1.10                               //
//                        http://www.instantcms.ru/                           //
//                                                                            //
//                   written by InstantCMS Team, 2007-2013                    //
//                produced by InstantSoft, (www.instantsoft.ru)               //
//                                                                            //
//                        LICENSED BY GNU/GPL v2                              //
//                                                                            //
/******************************************************************************/

    if(!defined('VALID_CMS')) { die('ACCESS DENIED'); }
    $inUser = cmsUser::getInstance();
	$inPage = cmsPage::getInstance();
	$inConf = cmsConfig::getInstance();

    $mod_count['top']     = $inPage->countModules('top');
    $mod_count['sidebar'] = $inPage->countModules('sidebar');

    $inPage->addHeadCSS('templates/'.TEMPLATE.'/css/reset.css');
    $inPage->addHeadCSS('templates/'.TEMPLATE.'/css/text.css');
    $inPage->addHeadCSS('templates/'.TEMPLATE.'/css/960.css');
    $inPage->addHeadCSS('templates/'.TEMPLATE.'/css/styles.css');

?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <?php $inPage->printHead(); ?>
    <?php if($inUser->is_admin){ ?>
        <script src="/admin/js/modconfig.js" type="text/javascript"></script>
        <script src="/templates/<?php echo TEMPLATE; ?>/js/nyromodal.js" type="text/javascript"></script>
        <link href="/templates/<?php echo TEMPLATE; ?>/css/modconfig.css" rel="stylesheet" type="text/css" />
        <link href="/templates/<?php echo TEMPLATE; ?>/css/nyromodal.css" rel="stylesheet" type="text/css" />
    <?php } ?>
</head>

<body>
<?php if ($inConf->siteoff && $inUser->is_admin) { ?>
<div style="margin:4px; padding:5px; border:solid 1px red; background:#FFF; position: fixed;opacity: 0.8; z-index:999"><?php echo $_LANG['SITE_IS_DISABLE']; ?></div>
<?php } ?>
    <div id="wrapper">

        <div id="header">
            <div class="container_12">
                <div class="grid_3">
                    <div id="sitename"><a href="/"></a></div>
                </div>
                <div class="grid_9">
                    <?php if ($inConf->is_change_lang){

                        $langs = cmsCore::getDirsList('/languages'); ?>
                        <div onclick="$('#langs-select').toggle().toggleClass('active_lang');$(this).toggleClass('active_lang'); return false;" title="<?php echo $_LANG['TEMPLATE_INTERFACE_LANG']; ?>" id="langs" style="background-image:  url(/templates/<?php echo TEMPLATE; ?>/images/icons/langs/<?php echo $inConf->lang; ?>.png);">
                            <span>&#9660;</span>
                            <ul id="langs-select">
                                <?php foreach ($langs as $lng) { ?>
                                <li onclick="setLang('<?php echo $lng; ?>'); return false;" style="background-image:  url(/templates/<?php echo TEMPLATE; ?>/images/icons/langs/<?php echo $lng; ?>.png);"><?php echo $lng; ?></li>
                                <?php } ?>
                            </ul>
                        </div>

                    <?php } ?>
                    <?php if (!$inUser->id){ ?>
                        <div class="mod_user_menu">
                            <span class="register"><a href="/registration"><?php echo $_LANG['TEMPLATE_REGISTRATION']; ?></a></span>
                            <span class="login"><a href="/login"><?php echo $_LANG['TEMPLATE_ENTER']; ?></a></span>
                        </div>
                    <?php } else { ?>
                        <?php $inPage->printModules('header'); ?>
                    <?php } ?>
                </div>
            </div>
        </div>

        <div id="page">

            <div class="container_12" id="topmenu">
                <div class="grid_12">
                    <?php $inPage->printModules('topmenu'); ?>
                </div>
            </div>

            <?php if ($mod_count['top']){ ?>
            <div class="clear"></div>

            <div id="topwide" class="container_12">
                <div class="grid_12" id="topmod"><?php $inPage->printModules('top'); ?></div>
            </div>
            <?php } ?>

                <div id="pathway" class="container_12">
                    <div class="grid_12"><?php $inPage->printPathway('&rarr;'); ?></div>
                </div>

            <div class="clear"></div>

            <div id="mainbody" class="container_12">
                <div id="main" class="<?php if ($mod_count['sidebar']) { ?>grid_8<?php } else { ?>grid_12<?php } ?>">
                    <?php $inPage->printModules('maintop'); ?>

                    <?php $messages = cmsCore::getSessionMessages(); ?>
                    <?php if ($messages) { ?>
                    <div class="sess_messages">
                        <?php foreach($messages as $message){ ?>
                            <?php echo $message; ?>
                        <?php } ?>
                    </div>
                    <?php } ?>

                    <?php if($inPage->page_body){ ?>
                        <div class="component">
                             <?php $inPage->printBody(); ?>
                        </div>
                    <?php } ?>
                    <?php $inPage->printModules('mainbottom'); ?>
                </div>
                <?php if ($mod_count['sidebar']) { ?>
                    <div class="grid_4" id="sidebar"><?php $inPage->printModules('sidebar'); ?></div>
                <?php } ?>
            </div>

        </div>

    </div>

    <div id="footer">
        <div class="container_12">
            <div class="grid_8">
                <div id="copyright"><?php $inPage->printSitename(); ?> &copy; <?php echo date('Y'); ?></div>
            </div>
            <div class="grid_4 foot_right">
                <a href="http://www.instantcms.ru/" title="<?php echo $_LANG['POWERED_BY_INSTANTCMS']; ?>" target="_blank">
                    <img src="/templates/<?php echo TEMPLATE; ?>/images/b88x31.gif" border="0"/>
                </a>
            </div>
        </div>
    </div>

    <script type="text/javascript">
        $(document).ready(function(){
            $('#topmenu .menu li').hover(
                function() {
                    $(this).find('ul:first').show();
                    $(this).find('a:first').addClass("hover");
                },
                function() {
                    $(this).find('ul:first').hide();
                    $(this).find('a:first').removeClass("hover");
                }
            );
        });
    </script>

</body>

</html>