<?php
/**
 * RokQuickCart CartItem View
 *
 * @package		Joomla
 * @subpackage	RokQuickCart
 * @copyright Copyright (C) 2009 RocketTheme. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 * @author RocketTheme, LLC
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die( 'Restricted access' );

jimport( 'joomla.application.component.view');
jimport('joomla.html.pane');
/**
 * HTML View class for the WebLinks component
 *
 * @static
 * @package		Joomla
 * @subpackage	Weblinks
 * @since 1.0
 */
class RokQuickCartViewCartItem extends JView
{
	function display($tpl = null)
	{
		global $mainframe;

		if($this->getLayout() == 'form') {
			$this->_displayForm($tpl);
			return;
		}

		$row =& $this->get('data');

		parent::display($tpl);
	}

	function _displayForm($tpl)
	{
		global $mainframe, $option;

		$db		=& JFactory::getDBO();
		$uri 	=& JFactory::getURI();
		$user 	=& JFactory::getUser();
		$model	=& $this->getModel();
		$document   =& JFactory::getDocument();
		
		$document->addStyleSheet('components/'.$option.'/assets/rokquickcart.css');

		$component_params = &JComponentHelper::getParams($option);
		
		$image_width = $component_params->get('shelf_image_width');
		
		$lists = array();

		//get the cart item
		$cartitem	=& $this->get('data');
		$isNew		= ($cartitem->id < 1);

		// fail if checked out not by 'me'
		if ($model->isCheckedOut( $user->get('id') )) {
			$msg = JText::sprintf( 'DESCBEINGEDITTED', JText::_( 'ROKQUICKCART_CARTITEM' ), $cartitem->name );
			$mainframe->redirect( 'index.php?option='. $option, $msg );
		}

		// Edit or Create?
		if (!$isNew)
		{
			$model->checkout( $user->get('id') );
		}
		else
		{
			// initialise new record
			$cartitem->published = 1;
			$cartitem->order 	= 0;
		}

		// build the html select list for ordering
		$query = 'SELECT ordering AS value, name AS text'
			. ' FROM #__rokquickcart'
			. ' ORDER BY ordering';

		$lists['ordering'] 			= JHTML::_('list.specificordering',  $cartitem, $cartitem->id, $query );
		
		// build the html select list
		$lists['published'] 		= JHTML::_('select.booleanlist',  'published', 'class="inputbox"', $cartitem->published );
		
		$cart_images_dir = 'images/rokquickcart/';
		
		JFilterOutput::objectHTMLSafe( $cartitem, ENT_QUOTES, 'description' );

		$paramfile 	= JPath::clean(JPATH_COMPONENT.'/views/cartitem/params.xml');
		$params = new JParameter($cartitem->params,$paramfile);
		
		$editor = JFactory::getEditor();
		$this->assignRef('editor', $editor);
		$this->assignRef('lists',		$lists);
		$this->assignRef('cartitem',		$cartitem);
		$this->assignRef('cart_images_dir', $cart_images_dir);
		$sliders = JPane::getInstance('sliders');
		$this->assignRef('pane', $sliders);
		$this->assignRef('params',		$params);
		$this->assignRef('image_width', $image_width);

		parent::display($tpl);
	}
}
