<?php
/**
 * RokQuickCart Module
 *
 * @package		Joomla
 * @subpackage	RokQuickCart Module
 * @copyright Copyright (C) 2009 RocketTheme. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see RT-LICENSE.php
 * @author RocketTheme, LLC
 */

defined('_JEXEC') or die('Restricted access');

class comRokQuickCartHelper {
	
	function load_css($css_style, &$params){
		$doc =& JFactory::getDocument();

		if($css_style == 1) {
			// Add main css
			$css = comRokQuickCartHelper::_getCSSPath('rokquickcart.css', 'com_rokquickcart');
			$iebrowser = comRokQuickCartHelper::_getBrowser();
			if ($css) { 
				$doc->addStyleSheet($css);
			}
			// Add browser specific css
			if ($iebrowser) {
				$iecss = comRokQuickCartHelper::_getCSSPath("rokquickcart-ie". $iebrowser . ".css", 'com_rokquickcart');	
				if ($iecss) { 
					$doc->addStyleSheet($iecss);
				}
			}
			$shelf_image_width = $params->get('shelf_image_width',100);
			$shelf_item_width = $params->get('shelf_item_width',350);
			$cart_item_height = $params->get('cart_item_height',200);
			
			$css  = ".cart_product_l {width:".$shelf_image_width."px;} ";
			$css .= ".cart_product_r {margin-left:".$shelf_image_width."px;} ";
			$css .= ".simpleCart_shelfItem {width:". $shelf_item_width ."px;}";
			$css .= ".itemContainer {height:". $cart_item_height."px;}";
			$doc->addStyleDeclaration($css);
		}		
	}
	
	function _getCSSPath($cssfile, $component) {
		global $mainframe;
		$tPath = 'templates/'.$mainframe->getTemplate().'/css/' . $cssfile;
		$bPath = 'components/'.$component.'/css/' . $cssfile;

		if (file_exists(JPATH_BASE.DS.$tPath)) {
			return JURI::Root(true).'/'.$tPath;
		} 
		else if (file_exists(JPATH_BASE.DS.$bPath)) {
			return JURI::Root(true).'/'.$bPath;
		} 
		else {
			return false;
		}
	}
	
	function _getBrowser() 
	{
		$agent = ( isset( $_SERVER['HTTP_USER_AGENT'] ) ) ? strtolower( $_SERVER['HTTP_USER_AGENT'] ) : false;
		$ie_version = false;
				
		if (eregi("msie", $agent) && !eregi("opera", $agent)){
            $val = explode(" ",stristr($agent, "msie"));
            $ver = explode(".", $val[1]);
			$ie_version = $ver[0];
			$ie_version = ereg_replace("[^0-9,.,a-z,A-Z]", "", $ie_version);
		}
		
		return $ie_version;
	}
	
}