<?php
// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

jimport( 'joomla.application.component.view');

class RokQuickCartViewRokQuickCart extends JView
{
	var $cart_images_dir = 'images/rokquickcart/';
	
	function display( $tpl = null)
	{
		global $mainframe, $option;
		$user		   =& JFactory::getUser();
		$document	   =& JFactory::getDocument();
		$items = $this->_prepItems($this->get('Data')); 
		
		
		
		$component_params = &JComponentHelper::getParams($option);
		
		$configured=true;
		
		//output the checkout mech
		if (!$component_params->get('checkout_method',false)) {
			$configured=false;
		}
		$config_options = array();
		
		
		$checkout_mode = $component_params->get('checkout_mode');
		$shipping_per_item = false;
		$shipping = false;
		
		if ($checkout_mode == "production"){
			$config_options[]  = 'simpleCart.sandboxMode = false;';
		}
		$uri =& JURI::getInstance();
		
		$config_options[]  = 'simpleCart.continue_url = "' .$uri->toString(array('scheme', 'user', 'pass', 'host', 'port', 'path', 'query')).'";';
		
		$checkout_method = $component_params->get('checkout_method');
		if ($checkout_method == 'PayPal') {
			$config_options[] = 'simpleCart.checkoutTo = PayPal;'; 
			$config_options[] = 'simpleCart.email = "'.$component_params->get('paypal_email').'";';
			$config_options[]  = 'simpleCart.currency = '.$component_params->get('paypal_currency').';';
			$currency_symbol = $this->_getCurrecySymbol($component_params->get('paypal_currency'));
			
			$shipping = $component_params->get('shipping',false);
			if ($shipping) { 
				$shipping_type = $component_params->get('shipping_type','items');
				switch ($shipping_type) {
					case "flat":
						$config_options[]  = 'simpleCart.shippingFlatRate = '.$component_params->get('shipping_flat',0).';';	
						break;
					case "quantity":
						$config_options[]  = 'simpleCart.shippingQuantityRate = '.$component_params->get('shipping_quantity',0).';';	
						break;
					case  "percent":
						$config_options[]  = 'simpleCart.shippingTotalRate = '.$component_params->get('shipping_percent',0).';';	
						break;
					default:
						$shipping_per_item = true;
						break;
				}
			}
		
		}
		else {
			$config_options[] = 'simpleCart.checkoutTo = GoogleCheckout;';
			$config_options[] = 'simpleCart.merchantId = "'.$component_params->get('googlecheckout_merchant_id').'";';
			$config_options[]  = 'simpleCart.currency = '.$component_params->get('googlecheckout_currency').';';
			$currency_symbol = $this->_getCurrecySymbol($component_params->get('googlecheckout_currency'));	
		}
		
		$tax = $component_params->get('tax',false);
		if ($tax) {
			$config_options[] = 'simpleCart.taxRate = ' .$component_params->get('tax_rate',0.00) . ';'; 	
		}
		
		

		
		// set cart headers
		$config_options[] = 'simpleCart.cartHeaders = [ "name", "thumb_image" ,  "size", "color", "Quantity_input" , "increment",  "decrement", "Total" ];';
		
		
		// Add CSS
		require_once (JPath::clean(JPATH_COMPONENT.'/libs/helper.php'));
		comRokQuickCartHelper::load_css($component_params->get('include_css',1), $component_params);
		
		
		
		// Add JS
		$document->addScript('components/com_rokquickcart/assets/js/simplecart/simpleCart.min.js');
		JHTML::_('behavior.mootools');
		$config_vars_js = implode("\n", $config_options);
		$document->addScriptDeclaration($config_vars_js);
		
        $document->addScriptDeclaration("window.addEvent('domready', function() { 
                                     var blocks = $$('.cart_product_content'), height = 0, tmp = 0;
                                                             if (blocks.length) {
                                                     blocks.each(function(block, i) { 
                                                         tmp = block.getSize().size.y;
                                                         if (tmp > height) height = tmp;
                                                     });
                                                     blocks.setStyle('height', height);
                                         }
                                     });");
		$page_title = $component_params->get('page_title');
		$use_rokbox = $component_params->get('use_rokbox',1);
		
		// Assign page refs
		$this->assignRef('items',		$items);
		$this->assignRef('tax',		$tax);
		$this->assignRef('shipping',	$shipping);
		$this->assignRef('page_title',	$page_title);
		$this->assignRef('shipping_per_item',	$shipping_per_item);
		$this->assignRef('use_rokbox',$use_rokbox);
		$this->assignRef('currency_symbol',$currency_symbol);
		$this->assignRef('checkout_mode',$checkout_mode);

		parent::display($tpl);
	}
	
	
	function _prepItems(&$items){
		global $mainframe, $option;
		$component_params = &JComponentHelper::getParams($option);
		reset($items);
		while (list(, $item) = each($items)) {
		    $item->_params = new JParameter($item->params);
		    $item->_component_params = $component_params;
		    $item->sizes = false;
		    $item->show_sizes =  $item->_params->get('has_sizes');
		    if ($item->_params->get('sizes_name_1', false)) {
		    	$sizes = array();
			    $count = 0;
				while (true) { 
					$count++;
					$size_option=array();
					$size_option['name'] = $item->_params->get('sizes_name_'.$count, '');
					if ($size_option['name']=='') {
						break;
					}
					$size_option['value'] = $item->_params->get('sizes_name_'.$count, '');
					$sizes[] = $size_option;
				}
			    $item->sizes = JHTML::_('select.genericlist',   $sizes, '', 'class="item_size" size="1" ', 'value', 'name');
		    }
		    $item->colors = false;
		    $item->show_colors =  $item->_params->get('has_colors');
		    if ($item->_params->get('colors_name_1', false)) {
		    	$colors = array();
			    $count = 0;
				while (true) { 
					$count++;
					$color_option=array();
					$color_option['name'] = $item->_params->get('colors_name_'.$count, '');
					if ($color_option['name']=='') {
						break;
					}
					$color_option['value'] = $item->_params->get('colors_name_'.$count, '');
					$colors[] = $color_option;
				}
			    $item->colors = JHTML::_('select.genericlist',   $colors, '', 'class="item_color" size="1" ', 'value', 'name');
		    }
		    
		}
		return $items;
	}
	function _getCurrecySymbol($currency) {
		switch($currency){
			case 'JPY':
				return "&yen;";
			case 'EUR':
				return "&euro;";
			case 'GBP':
				return "&pound;";
			case 'USD':
			case 'CAD':
			case 'AUD':
			case 'NZD':
			case 'HKD':
			case 'SGD':
				return "&#36;";
			default:
				return "";
		}
	}
	
}