<?php
function insert_data($table)
{
	global $mysql_db, $conn;
	@set_time_limit(60);
    $rs = &$conn->Execute("SELECT * from $table") or exit();

	$insert="";
	while($rs && !$rs->EOF)
	{	/*$insert.="INSERT INTO $table (";
		$cols=&$conn->MetaColumns($table);
		//all field names
		foreach($cols as $key => $value)
			$insert.=strtolower($key).", ";
		$insert=substr_replace($insert,") ",-2); //kill last comma and space
		$insert.="VALUES (";
		
		//all values
		for($i=0;$i<count($cols);$i++)
			//$insert.="'".$rs->fields[$i]."', ";
			$insert.=$conn->qstr($rs->fields[$i].", ");
		$insert=substr_replace($insert,") ",-2); //kill last comma and space
		$insert.=";\n";*/
		$temp=$conn->GetInsertSQL($rs,$rs->fields);
		$temp=ereg_replace("\n","\\n", $temp);
		$temp=ereg_replace("\r","\\r", $temp);
		$insert.=$temp.";\n";
		$rs->MoveNext();
    }
    return ($insert);
}

function create_tables()
{	global $sql_type;
	//create tables
	$dbtype=$sql_type;
	
	//config
	if ($dbtype == "mysql")
		$inl_config_u = ", UNIQUE name (name)";
	elseif ($dbtype == "postgres7")
		$inl_config_u = ", UNIQUE (name)";
	elseif ($dbtype == "mssql")
		$inl_config_u = "";

	$query="CREATE TABLE inl_config (name varchar(255) NOT NULL,value varchar(255) NOT NULL,PRIMARY KEY (name) $inl_config_u);\n";

	if ($dbtype == "mysql")
		$idfield = "int NOT NULL auto_increment";
	elseif ($dbtype == "postgres7")
		$idfield = "serial";
	elseif ($dbtype == "mssql")
			$idfield = "int IDENTITY (1, 1) NOT NULL ";

	//categories
	$query .= "CREATE TABLE inl_cats (cat_id $idfield,cat_name varchar(255),cat_desc text NULL,cat_user int DEFAULT '0' NOT NULL,cat_sub int DEFAULT '0' NOT NULL,cat_perm smallint DEFAULT '0' NOT NULL,	   cat_pend smallint DEFAULT '0' NOT NULL,cat_vis smallint DEFAULT '0' NOT NULL,cat_links int DEFAULT '0' NOT NULL,cat_cats int DEFAULT '0' NOT NULL,cat_date int DEFAULT '0' NOT NULL,cat_pick int DEFAULT '0' NOT NULL,cat_image varchar(255) NULL,cat_cust int DEFAULT '0' NOT NULL,meta_keywords text NULL,meta_desc text NULL,PRIMARY KEY (cat_id));\n";

   $query .= "CREATE INDEX cat_sub ON inl_cats (cat_sub);\n";

	//custom
	$query .= "CREATE TABLE inl_custom (cust_id $idfield,cust1 varchar(255) NULL,cust2 varchar(255) NULL,cust3 varchar(255) NULL,cust4 text NULL,cust5 text NULL,cust6 text NULL,PRIMARY KEY (cust_id));\n";

	//e-mail
	$query .= "CREATE TABLE inl_email (email_id $idfield,email_subject varchar(255) NULL,email_body text NULL,   email_from varchar(50) NULL,email_reply varchar(50) NULL,email_to varchar(50) NULL,	PRIMARY KEY (email_id));\n";

	//link cats
	$query .= "CREATE TABLE inl_lc (link_id int DEFAULT '0' NOT NULL,cat_id int DEFAULT '0' NOT NULL,	   link_pend int DEFAULT '0' NOT NULL);\n";

   $query .= "CREATE INDEX link_id ON inl_lc (link_id);\n";
   $query .= "CREATE INDEX cat_id ON inl_lc (cat_id);\n";

	//links
	$query .= "CREATE TABLE inl_links (link_id $idfield,link_name varchar(254) NOT NULL,link_desc text NOT NULL,	link_url varchar(254) NOT NULL,link_date int DEFAULT '0' NOT NULL,link_user int DEFAULT '0' NOT NULL,	   link_hits int DEFAULT '0' NOT NULL,link_votes int DEFAULT '0' NOT NULL,link_rating decimal(6,4) DEFAULT '0.0000' NOT NULL,link_pick smallint DEFAULT '0' NOT NULL,link_vis smallint DEFAULT '0' NOT NULL,	   link_image varchar(254) NULL,link_cust int DEFAULT '0' NOT NULL,link_numrevs int DEFAULT '0' NOT NULL,	   PRIMARY KEY (link_id));\n";

	//reviews
	$query.= "CREATE TABLE inl_reviews (rev_id $idfield,rev_link int DEFAULT '0' NOT NULL,rev_user int DEFAULT '0' NOT NULL,rev_text text NULL,rev_date int DEFAULT '0' NOT NULL,rev_pend int DEFAULT '0' NOT NULL,PRIMARY KEY (rev_id));\n";

   $query.= "CREATE INDEX rev_link ON inl_reviews (rev_link);\n";

	//search log
	$query.= "CREATE TABLE inl_search_log (log_id  $idfield,log_type smallint DEFAULT '0' NOT NULL,log_date int DEFAULT '0' NOT NULL,log_search smallint DEFAULT '0' NOT NULL,log_keyword varchar(255) NOT NULL, search_action int default '0' NOT NULL , PRIMARY KEY (log_id));\n";

   //sessions
   $query.= "CREATE TABLE inl_sessions (ses_id  $idfield,ses_time int DEFAULT '0' NOT NULL,user_id int DEFAULT '0' NOT NULL,user_perm int DEFAULT '0' NOT NULL,num_res varchar(25) NULL,link_order varchar(25) NULL,link_sort varchar(25) NULL,cat_order varchar(25) NULL,cat_sort varchar(25) NULL,lang varchar(25) NULL,theme varchar(25) NULL,destin varchar(250) NULL,PRIMARY KEY (ses_id));\n";

   $query.= "CREATE INDEX ses_id ON inl_sessions (ses_id);\n";

	//users
	if ($dbtype == "mysql")
		$inl_users_u = ", UNIQUE user_name (user_name)";
	elseif ($dbtype == "postgres7")
		$inl_users_u = ", UNIQUE (user_name)";
	elseif ($dbtype == "")
		$inl_users_u = "";

	$query.= "CREATE TABLE inl_users (user_id $idfield,user_name varchar(20) NOT NULL,user_pass varchar(50) NOT NULL,first varchar(50) NOT NULL,last varchar(50) NOT NULL,email varchar(255) NULL,user_perm int DEFAULT '0' NOT NULL,user_date int DEFAULT '0' NOT NULL,user_cust int DEFAULT '0' NOT NULL,user_status smallint DEFAULT '0' NOT NULL,user_pend int DEFAULT '0' NOT NULL,PRIMARY KEY (user_id)  $inl_users_u);\n";

	//votes
   $query.= "CREATE TABLE inl_votes (stamp int DEFAULT '0' NOT NULL,vote_ip varchar(16) NOT NULL,	   vote_link int DEFAULT '0' NOT NULL,rev int DEFAULT '0' NOT NULL);\n";

   $query.= "CREATE INDEX stamp ON inl_votes (stamp);\n";
   $query.= "CREATE INDEX vote_ip ON inl_votes (vote_ip);\n";
   $query.= "CREATE INDEX vote_link ON inl_votes (vote_link);\n";

   return $query;
}
?>