<?php
class ControllerPaymentYandexMoney extends Controller {
	private $error = array();

	public function index() {

		$this->load->language('payment/yandex_money');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('setting/setting');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && ($this->validate())) {
			$this->load->model('setting/setting');

			$this->model_setting_setting->editSetting('yandex_money', $this->request->post);

			$this->session->data['success'] = $this->language->get('text_success');

			$this->redirect($this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL'));
		}

		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_enabled'] = $this->language->get('text_enabled');
		$this->data['text_disabled'] = $this->language->get('text_disabled');
		$this->data['text_all_zones'] = $this->language->get('text_all_zones');
		$this->data['text_seller'] = $this->language->get('text_seller');
		$this->data['text_buyer'] = $this->language->get('text_buyer');
		$this->data['text_buyer_seller'] = $this->language->get('text_buyer_seller');

		$this->data['entry_key'] = $this->language->get('entry_key');
		$this->data['entry_pro_client'] = $this->language->get('entry_pro_client');
		$this->data['entry_pro_ra'] = $this->language->get('entry_pro_ra');
		$this->data['entry_callback'] = $this->language->get('entry_callback');
		$this->data['entry_commission'] = $this->language->get('entry_commission');
		$this->data['entry_success'] = $this->language->get('entry_success');
		$this->data['entry_fail'] = $this->language->get('entry_fail');
		$this->data['entry_order_status'] = $this->language->get('entry_order_status');
		$this->data['entry_geo_zone'] = $this->language->get('entry_geo_zone');
		$this->data['entry_status'] = $this->language->get('entry_status');
		$this->data['entry_sort_order'] = $this->language->get('entry_sort_order');
		$this->data['entry_add_params'] = $this->language->get('entry_add_params');

		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');

		$this->data['tab_general'] = $this->language->get('tab_general');

		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}

		if (isset($this->error['key'])) {
			$this->data['error_key'] = $this->error['key'];
		} else {
			$this->data['error_key'] = '';
		}
		
		if (isset($this->error['pro_client'])) {
			$this->data['error_pro_client'] = $this->error['pro_client'];
		} else {
			$this->data['error_pro_client'] = '';
		}
		
		if (isset($this->error['pro_ra'])) {
			$this->data['error_pro_ra'] = $this->error['pro_ra'];
		} else {
			$this->data['error_pro_ra'] = '';
		}

		$this->data['breadcrumbs'] = array();

		$this->data['breadcrumbs'][] = array(
			'href' => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),
			'text' => $this->language->get('text_home'),
			'separator' => FALSE
		);

		$this->data['breadcrumbs'][] = array(
			'href' => $this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL'),
			'text' => $this->language->get('text_payment'),
			'separator' => ' :: '
		);

		$this->data['breadcrumbs'][] = array(
			'href' => $this->url->link('payment/yandex_money', 'token=' . $this->session->data['token'], 'SSL'),
			'text' => $this->language->get('heading_title'),
			'separator' => ' :: '
		);
		$this->data['action'] =$this->url->link('payment/yandex_money', 'token=' . $this->session->data['token'], 'SSL');

		$this->data['cancel'] =$this->url->link('extension/payment', 'token=' . $this->session->data['token'], 'SSL');

		if (isset($this->request->post['yandex_money_key'])) {
			$this->data['yandex_money_key'] = $this->request->post['yandex_money_key'];
		} else {
			$this->data['yandex_money_key'] = $this->config->get('yandex_money_key');
		}
		
		if (isset($this->request->post['yandex_money_pro_client'])) {
			$this->data['yandex_money_pro_client'] = $this->request->post['yandex_money_pro_client'];
		} else {
			$this->data['yandex_money_pro_client'] = $this->config->get('yandex_money_pro_client');
		}
		
		if (isset($this->request->post['yandex_money_pro_ra'])) {
			$this->data['yandex_money_pro_ra'] = $this->request->post['yandex_money_pro_ra'];
		} else {
			$this->data['yandex_money_pro_ra'] = $this->config->get('yandex_money_pro_ra');
		}
		
		if (isset($this->request->post['yandex_money_comission'])) {
			$this->data['yandex_money_comission'] = $this->request->post['yandex_money_comission'];
		} else {
			$this->data['yandex_money_comission'] = $this->config->get('yandex_money_comission');
		}

		$this->data['callback'] = HTTP_CATALOG . 'index.php?route=payment/yandex_money/callback';
		$this->data['success'] = HTTP_CATALOG . 'index.php?route=payment/yandex_money/success';
		$this->data['fail'] = HTTP_CATALOG . 'index.php?route=payment/yandex_money/fail';

		if (isset($this->request->post['yandex_money_order_status_id'])) {
			$this->data['yandex_money_order_status_id'] = $this->request->post['yandex_money_order_status_id'];
		} else {
			$this->data['yandex_money_order_status_id'] = $this->config->get('yandex_money_order_status_id');
		}

		$this->load->model('localisation/order_status');

		$this->data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

		if (isset($this->request->post['yandex_money_geo_zone_id'])) {
			$this->data['yandex_money_geo_zone_id'] = $this->request->post['yandex_money_geo_zone_id'];
		} else {
			$this->data['yandex_money_geo_zone_id'] = $this->config->get('yandex_money_geo_zone_id');
		}

		$this->load->model('localisation/geo_zone');

		$this->data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();

		if (isset($this->request->post['yandex_money_status'])) {
			$this->data['yandex_money_status'] = $this->request->post['yandex_money_status'];
		} else {
			$this->data['yandex_money_status'] = $this->config->get('yandex_money_status');
		}

		if (isset($this->request->post['yandex_money_sort_order'])) {
			$this->data['yandex_money_sort_order'] = $this->request->post['yandex_money_sort_order'];
		} else {
			$this->data['yandex_money_sort_order'] = $this->config->get('yandex_money_sort_order');
		}

		$this->template = 'payment/yandex_money.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);

		$this->response->setOutput($this->render(TRUE), $this->config->get('config_compression'));
	}

	private function validate() {
		if (!$this->user->hasPermission('modify', 'payment/yandex_money')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if (!$this->request->post['yandex_money_key']) {
			$this->error['key'] = $this->language->get('error_key');
		}
		
		if (!$this->request->post['yandex_money_pro_client']) {
			$this->error['pro_client'] = $this->language->get('error_pro_client');
		}
		
		if (!$this->request->post['yandex_money_pro_ra']) {
			$this->error['pro_ra'] = $this->language->get('error_pro_ra');
		}

		if (!$this->error) {
			return TRUE;
		} else {
			return FALSE;
		}
	}
}

?>