<?php
class ControllerPaymentYandexMoney extends Controller {
	protected function index() {
		$this->data['button_confirm'] = $this->language->get('button_confirm');
		
		$this->data['action'] = 'http://merchant.prochange.ru/pay.pro';
		
		$this->load->model('checkout/order');

		$order_info = $this->model_checkout_order->getOrder($this->session->data['order_id']);
		
		// Номер заказа
		$this->data['inv_id'] = $this->session->data['order_id']; // PRO_PAYMENT_DESC
		$this->data['pro_client'] = $this->config->get('yandex_money_pro_client'); // PRO_CLIENT
		$this->data['pro_ra'] = $this->config->get('yandex_money_pro_ra'); // PRO_RA
		
		if ($this->config->get('yandex_money_comission') == 'buyer') {
			$amount = $order_info['total'] + $order_info['total'] * 9/100;
		} elseif ($this->config->get('yandex_money_comission') == 'seller') {
			$amount = $order_info['total'];
		} elseif ($this->config->get('yandex_money_comission') == 'buyer_seller') {
			$amount = $order_info['total'] + $order_info['total'] * 5/100;
		}
		
		$rur_code = 'RUB';
		$rur_order_total = $this->currency->convert($amount, $order_info['currency_code'], $rur_code);
		$this->data['order_amount'] = $this->currency->format($rur_order_total, $rur_code, $order_info['currency_value'], FALSE);
		
		$this->data['secret_key'] = $this->config->get('yandex_money_key'); // PRO_SECRET_KEY
		
		$this->data['return'] = HTTPS_SERVER . 'index.php?route=checkout/success';
		
		if ($this->request->get['route'] != 'checkout/guest_step_3') {
			$this->data['cancel_return'] = HTTPS_SERVER . 'index.php?route=checkout/payment';
		} else {
			$this->data['cancel_return'] = HTTPS_SERVER . 'index.php?route=checkout/guest_step_2';
		}
		
		if ($this->request->get['route'] != 'checkout/guest_step_3') {
			$this->data['back'] = HTTPS_SERVER . 'index.php?route=checkout/payment';
		} else {
			$this->data['back'] = HTTPS_SERVER . 'index.php?route=checkout/guest_step_2';
		}
		
		$this->id = 'payment';
		
		if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/payment/yandex_money.tpl')) {
			$this->template = $this->config->get('config_template') . '/template/payment/yandex_money.tpl';
		} else {
			$this->template = 'default/template/payment/yandex_money.tpl';
		}

		$this->render();
	}

	public function fail() {

		$this->redirect(HTTPS_SERVER . 'index.php?route=checkout/checkout');

	}
	
	public function success() {
		
		$PRO_FIELD_1 = $this->request->post['PRO_FIELD_1'];
		
		$this->load->model('checkout/order');
		
		$this->model_checkout_order->confirm($PRO_FIELD_1, $this->config->get('yandex_money_order_status_id'), 'Яндекс Деньги');
		
		$this->redirect(HTTPS_SERVER . 'index.php?route=checkout/success');
		
		return TRUE;
	}
	
	public function callback() {
		$PRO_FIELD_1 = $this->request->post['PRO_FIELD_1'];
		
		$this->load->model('checkout/order');
			
		$order_info = $this->model_checkout_order->getOrder($PRO_FIELD_1);
		$new_order_status_id = $this->config->get('yandex_money_order_status_id');
			
		if ( ! $order_info) {
			echo 'ERROR:  Нет такого заказа!';
			return 0;
		}
			
		if( $order_info['order_status_id'] == 0) {
			$this->model_checkout_order->confirm($PRO_FIELD_1, $new_order_status_id, 'Яндекс Деньги');
			return TRUE;
		}
		
		if( $order_info['order_status_id'] != $new_order_status_id) {
			$this->model_checkout_order->update($PRO_FIELD_1, $new_order_status_id, 'Яндекс Деньги',TRUE);
		}
			
		return TRUE;
		
	}

}

?>