<?php
/*
=====================================================
  : REZER (http://rezer.net)
=====================================================
 :     
=====================================================
*/

//-------------------------------------------------====
//	 
//-------------------------------------------------====

@session_start();
@ob_start();
@ob_implicit_flush( 0 );

@error_reporting ( E_ALL ^ E_NOTICE );
@ini_set( "display_errors", true );
@ini_set( "html_errors", false );
@ini_set( "error_reporting", E_ALL ^ E_NOTICE );

define( "DATALIFEENGINE", true );
define( "ROOT_DIR", dirname ( __FILE__ ) );
define( "ENGINE_DIR", ROOT_DIR."/engine" );

//-------------------------------------------------====
//	   
//-------------------------------------------------====

require_once( ENGINE_DIR."/data/config.php" );
require_once( ROOT_DIR."/language/".$config['langs']."/website.lng" );
require_once( ENGINE_DIR."/classes/mysql.php" );
require_once( ENGINE_DIR."/data/dbconfig.php" );

if( $config['version_id'] >= 8 )
	require_once( ENGINE_DIR."/inc/include/functions.inc.php" );
else
	require_once( ENGINE_DIR."/inc/functions.inc.php" );
	
require_once( ENGINE_DIR."/modules/sitelogin.php" );

//-------------------------------------------------====
//	 
//-------------------------------------------------====

$config['charset'] = ( $lang['charset'] != "" ) ? $lang['charset'] : $config['charset'];

//-------------------------------------------------====
//	   
//-------------------------------------------------====

if( !$is_logged ) die( error );
if( $member_id['user_group'] != 1 && $member_db[1] != 1 ) die( error );

//-------------------------------------------------====
//	   
//-------------------------------------------------====

function EchoHeadInstall( $title = "      <a href=\"http://rezer.net/\" target=\"_blank\">Rezer.net</a>" ){
	global $ModuleName;
	
	$lang['skin_title'] = strip_tags( $title );
	require_once( ENGINE_DIR."/skins/default.skin.php" );
	$skin_header = preg_replace( "/{header-text}/", "", $skin_header );
	$skin_header = preg_replace( "/{user}/", $title, $skin_header );
	$skin_header = preg_replace( "#{group}#Us", $ModuleName, $skin_header );
	$skin_header = preg_replace( "#{js_files}#Us", "", $skin_header );
	$skin_header = preg_replace( "#&nbsp;<map(.*)</map>#Us", "", $skin_header );
	
	echo $skin_header;
}

//-------------------------------------------------====
//	 
//-------------------------------------------------====

function EchoBlockMaster( $about, $result = "", $title = "  :" ){

	EchoHeadInstall();	
	opentable( true );
	tableheader( "      <a href=\"http://rezer.net/\" target=\"_blank\">Rezer.net</a>" );
			
if( $result ) $itog = <<<HTML
<div class="hr_line"></div>
<div style="padding: 5px;">
	{$result}
</div>
HTML;

echo <<<HTML
<div style="padding: 5px;">
	<b>{$title}</b><br /><br />
	{$about}
</div>
{$itog}
HTML;
	
	closetable();
	footer();
}

//-------------------------------------------------====
//	 
//-------------------------------------------------====

function CharsetConvert( $text, $to = "auto" ){
	global $config;
			
	$text = stripslashes( $text );
	$charset = mb_detect_encoding( $text, "utf-8,windows-1251" );
	if( $to == "auto" ) $to = $config['charset'];
	if( $charset != $to && $to != "" ) $text = iconv( $charset, $to."//IGNORE", $text );
	return urldecode( $text );
}

//-------------------------------------------------====
//	  
//-------------------------------------------------====
	
function SaveConfig( $Opt = array(), $LastOpt, $NameOpt, $File, $title = "(Powered by REZER)" ){
	
	if( !is_array( $LastOpt ) ) $LastOpt = array();
	$save_con = $Opt + $LastOpt;
	$handler = fopen( $File, "w" );
	fwrite( $handler, "<?php \n\n//{$title}\n\n\${$NameOpt} = array (\n" );
	foreach( $save_con as $name => $value )
		{
			if( is_array( $value ) ) $value = implode( ",", $value );
			$value = addslashes( stripslashes( trim( $value ) ) );
			fwrite( $handler, "\t\"{$name}\" => \"{$value}\",\n" );
		}
	fwrite( $handler, ");\n\n?>" );
	fclose( $handler );
}

//-------------------------------------------------====
//	   
//-------------------------------------------------====

function ListInfoEditFile( $Info, $version, $type = "install" ){
	
	if( count( $Info ) > 0 )
		{
			$List = "";
			foreach( $Info as $EditInfo )
				{
					$title = stripslashes( $EditInfo['title'] );
					$content = stripslashes( $EditInfo['content'] );
					if( $content ) $content = "<br /><textarea style=\"width: 100%; height: auto; background: #F1FEE2;\">{$content}</textarea><br />";

$List .= <<<HTML
<div class="hr_line"></div>
<div style="padding: 5px;" class="navigation">
	<strong>{$title}</strong><br />
	{$content}
</div>
HTML;

					}
			}
				else
			{
				$List = $type == "install" ? "    {$version}      ." : "     {$version}      .";
			}
			
	return $List;	
}

function SqlQuery( $sqlData ){
	global $db;
	
	foreach( $sqlData as $query )
		{
			$query = trim( $query );
			$query = str_replace( "{prefix}", PREFIX, $query );
			$db->query( $query );
		}
}

//-------------------------------------------------====
//	 
//-------------------------------------------------====

$ModuleName = "DLE Board";
$LicenseLink = "http://rezer.net/module/board/license.html";
$ModulePage = "board";
$FolderData = "board.installdb";
$options['menu'] = array();
$ModAllowVersion = array( "1.1" );
$ThisFile = $_SERVER['SCRIPT_NAME'];

$ConfigFile = ENGINE_DIR."/data/board.config.php";
$RequireFiles = array( 
	ENGINE_DIR."/inc/board/functions.php",
);

$AllowUpdate = true;
$AllowNext = true;
if( file_exists( $ConfigFile ) )
	require_once( $ConfigFile );
else
	$AllowUpdate = false;
	
foreach( $RequireFiles as $file )
	{
		if( !file_exists( $file ) ) 
			$AllowNext = false;
		else
			require_once( $file );
	}
	
$ModServerVersion = $BoardConfig['id_version'];
sort( $ModAllowVersion );
$ModuleInstallVersion = end( $ModAllowVersion );
$action = $_REQUEST['action'];

//-------------------------------------------------------------------
//
//			     
//
//-------------------------------------------------------------------

if( $AllowNext !== true )
	{
		EchoBlockMaster( "         .", "<span style=\"color: #F00;\">   (     )</a>" );
		die();
	}

//-------------------------------------------------------------------
//
//					  ?
//
//-------------------------------------------------------------------

if( $action == "start" )
	{
		$LinkInstall = $ModServerVersion != "" ? " ( ..   )" : "<a href=\"?action=install\"></a>";
		$LinkUpdate = $ModServerVersion != "" ? "<a href=\"?action=update\"><a/>" : " ( ..    )";
		
		if( $ModServerVersion != "" )
			{
				EchoHeadInstall();	
				opentable( true );
				tableheader( "      <a href=\"http://rezer.net/\" target=\"_blank\">Rezer.net</a>" );

echo <<<HTML
<div style="padding: 5px;">
	<b>  :</b><br /><br />
	    : {$ModServerVersion}<br />
	         , <a href="?action=edit-file">   </a>.<br />
	    ,   ,  .
</div>
<div class="hr_line"></div>
<div style="padding: 5px;">
	{$LinkInstall} | {$LinkUpdate}
</div>
HTML;
	
				closetable();
				footer();
			}
				else
			{
				EchoBlockMaster( "     ?", "{$LinkInstall} | {$LinkUpdate}", "  :" );
			}
	}
	
//-------------------------------------------------------------------
//
//				 
//
//-------------------------------------------------------------------

elseif( $action == "edit-file" )
	{
		
		EchoHeadInstall();	
		opentable( true );
		tableheader( "      <a href=\"http://rezer.net/\" target=\"_blank\">Rezer.net</a>" );
		
		sort( $ModAllowVersion );
		
		$EchoVersion = $_REQUEST['version'];
		if( !in_array( $EchoVersion, $ModAllowVersion ) ) $EchoVersion = "";
		
		if( $EchoVersion )
			{
				if( file_exists( ROOT_DIR."/{$FolderData}/{$EchoVersion}.php" ) )
					{
						require( ROOT_DIR."/{$FolderData}/{$EchoVersion}.php" );
						$ListEditFilesUpdate = ListInfoEditFile( $EditFilesUpdate, $EchoVersion, "update" );
						$ListEditFilesInstall = ListInfoEditFile( $EditFilesInstall, $EchoVersion );
					}
						else
					{
						$ListEditFilesUpdate = "      .";
						$ListEditFilesInstall = "      .";
					}
			}
				else
			{
				$ListEditFilesUpdate = "   .";
				$ListEditFilesInstall = "   .";
			}
		
		$result = "";
		foreach( $ModAllowVersion as $version )
			{
				$result .= $version == $EchoVersion ? "[{$version}] ": "[<a href=\"?action=edit-file&version={$version}\">{$version}</a>] ";
			}

echo <<<HTML
<div style="padding: 5px;">
	<b>  :</b><br /><br />
	      ,     .<br />
	           ?<br /><br />
	[<a href="?action=start"> </a>] {$result}
</div>
<div class="hr_line"></div>
<div style="padding: 5px;">
	<div id="OptChange">
		<div class="dle_aTab" style="padding: 10px;">
			{$ListEditFilesUpdate}
		</div>
		<div class="dle_aTab" style="padding: 10px;">
			{$ListEditFilesInstall}
		</div>
	</div>
	<script type="text/javascript" src="engine/skins/tabs.js"></script>
	<script type="text/javascript">
	   initTabs( "OptChange", Array( " ", " " ),0, '100%' );
	</script>
</div>
HTML;
	
		closetable();
		footer();
	}

//-------------------------------------------------------------------
//
//				 
//
//-------------------------------------------------------------------

elseif( $action == "install" )
	{
		if( $ModServerVersion != "" )
			{
				EchoBlockMaster( "   : {$ModServerVersion}<br /><br />&raquo; <a href=\"/{$config['admin_path']}?mod={$ModulePage}\">   </a><br />&raquo; <a href=\"?action=start\"> </a>", ": <span style=\"color: #F00;\">    !</span> ( <a href=\"?action=update\"><a/>)" );
			}
				else
			{
				if( file_exists( ROOT_DIR."/{$FolderData}/{$ModuleInstallVersion}.php" ) )
					{
						require( ROOT_DIR."/{$FolderData}/{$ModuleInstallVersion}.php" );
						if( $_REQUEST['sql'] == "true" )
							{
								$sqlData = CharsetConvert( $_REQUEST['sqldata'] );
								$sqlData = explode( ";", $sqlData );
								if( trim( end( $sqlData ) ) == "" ) unset( $sqlData[ ( count( $sqlData ) - 1 ) ] );
								SqlQuery( $sqlData );
												
								if( is_array( $ConfigFileInstall ) )
									{
										foreach( $ConfigFileInstall as $InstallFile )
											{
												SaveConfig( $InstallFile['config'], array(), $InstallFile['variable'], $InstallFile['file'], $InstallFile['comments'] );
											}
									}
									
								if( is_array( $CreateFileInstall ) )
									{
										foreach( $CreateFileInstall as $InstallFile )
											{
												$fp = fopen( $InstallFile['file'], "w" );
												if( $InstallFile['value'] ) fwrite( $fp, $InstallFile['value'] );
												fclose( $fp );
												chmod( $InstallFile['file'], $InstallFile['chmod'] );
											}
									}
												
								die( "  ,   ." );
							}
											
						EchoHeadInstall();	
						opentable( true );
						tableheader( "      <a href=\"http://rezer.net/\" target=\"_blank\">Rezer.net</a>");
										
						$SqlInstall = implode( "\n", $SqlDataInstall );
						if( $config['version_id'] == "9.0" ) $JS = "<script language=\"javascript\" type=\"text/javascript\">function ShowLoading(){var Ajax = new dle_ajax; Ajax.onShow( \"\" );}function HideLoading(){var Ajax = new dle_ajax; Ajax.onHide( \"\" );}</script>";
						
						$ListEditFilesInstall = ListInfoEditFile( $EditFilesInstall, $ModuleInstallVersion );
											
						if( !count( $SqlDataInstall ) && !count( $EditFilesInstall ) )
							$InfoUser = "<strong>  </strong>,              .      ,      \" SQL   .\"";
						elseif( !count( $EditFilesInstall ) )
							$InfoUser = "<strong>  </strong>,          .           ,      \" SQL   .\"";
											
						if( $InfoUser ) $InfoUser = "<div class=\"hr_line\"></div><div style=\"padding: 5px;\">{$InfoUser}</div>";

								
echo <<<HTML
<script type="text/javascript" src="engine/classes/js/jquery.js"></script>
<script type="text/javascript" src="engine/classes/js/jqueryui.js"></script>
<script type="text/javascript" src="engine/skins/default.js"></script>
{$JS}
<script language="javascript" type="text/javascript">
	function SendSQL(){
		
		var Quest = confirm( " ,    sql ,     ?" );
		if( Quest === true )
			{
				var SqlData = document.getElementById( "sql_data" ).value;
				if( document.getElementById( "SqlResult" ).style.display == "none" ) ShowOrHide( "SqlResult" );
				$( "#SqlResult" ).html( ",  ..." );

				
				$.ajax({
					url: "{$ThisFile}",
					data: "&action=install&sql=true&sqldata=" + SqlData,
					success: function( data ){
						$( "#SqlResult" ).html( data );
					},
					dataType: "html",
					type: "POST"
				});
			}
	}
</script>
<div style="padding: 5px;">
	<b>  :</b><br /><br />
	    : {$ModuleInstallVersion}
</div>
<div class="hr_line"></div>
<div style="padding: 5px;">
	<strong>:</strong>      (  )    ,         "  ".
</div>
{$InfoUser}
<div class="hr_line"></div>
<div style="padding: 5px;">
	<div id="OptChange">
		<div class="dle_aTab" style="padding: 10px;">
			<a href="javascript:void(0);" onclick="ShowOrHide( 'sql_textarea' );">     ( )</a><br />
			<div id="sql_textarea" style="display: none;">
			<br /><textarea id="sql_data" style="width: 100%; height: 100px;">{$SqlInstall}</textarea><br /><br />
			 -      <br />
			{prefix} -      <br />
			 ";" -   <br />
			</div><br />
			<input type="submit" value=" SQL        " onclick="SendSQL(); return false;" class="buttons" />
			<div id="SqlResult" style="display: none; margin: 10px 0px 0px 0px; padding: 5px; border: 1px solid #cccccc; background: #F4FEF3;"></div>
		</div>
		<div class="dle_aTab" style="padding: 10px;">
			<div style="padding: 5px;" class="navigation">
				     :
			</div>
			{$ListEditFilesInstall}
		</div>
	</div>
	<script type="text/javascript" src="engine/skins/tabs.js"></script>
	<script type="text/javascript">
	   initTabs( "OptChange", Array( " ", "  " ),0, '100%' );
	</script>
</div>
<div class="hr_line"></div>
<div style="padding: 5px;">
	<input type="button" class="buttons" onclick="if( confirm( ' ,   ?' ) === true ) window.location = '?action=start';" value="  " />
	<input type="button" class="buttons" onclick="if( confirm( ' ,        ?' ) === true ) window.location = '/{$config[admin_path]}?mod={$ModulePage}';" value="   " />
</div>
HTML;
									
						closetable();
						footer();
					}
						else
					{
						EchoBlockMaster( "      !<br /><br />&raquo; <a href=\"/{$config['admin_path']}?mod={$ModulePage}\">   </a><br />&raquo; <a href=\"?action=start\"> </a>", ": <span style=\"color: #F00;\">  !</span>", "  :" );
					}
			}
	}
	
//-------------------------------------------------------------------
//
//				 
//
//-------------------------------------------------------------------

elseif( $action == "update" )
	{
		if( $ModServerVersion != "" )
			{
				foreach( $ModAllowVersion as $i => $value )
					{
						if( version_compare( $ModAllowVersion[ $i ], $ModServerVersion, "<" ) || $ModAllowVersion[ $i ] == $ModServerVersion ) unset( $ModAllowVersion[ $i ] );
					}
				
				sort( $ModAllowVersion );
				if( count( $ModAllowVersion ) > 1 )
					{
						$NowModInstallVersion = $ModAllowVersion[0];
						$StadesInstall = implode( ",   ", $ModAllowVersion );
						$result = "<strong>:</strong>      {$StadesInstall}  .";
					}
						else
					{
						$NowModInstallVersion = end( $ModAllowVersion );
						$result = "<strong>:</strong>       {$NowModInstallVersion}";
					}
				
				$ModLastVersion = end( $ModAllowVersion );
				if( version_compare( $ModLastVersion, $ModServerVersion, ">" ) )
					{
						$RequestVersion = $_REQUEST['version'];
						if( !in_array( $RequestVersion, $ModAllowVersion ) || $RequestVersion != $NowModInstallVersion ) $RequestVersion = "";
						if( !$RequestVersion )
							{
								EchoHeadInstall();	
								opentable( true );
								tableheader( "      <a href=\"http://rezer.net/\" target=\"_blank\">Rezer.net</a>");
echo <<<HTML
<div style="padding: 5px;">
	<b>  :</b><br /><br />
	   : {$ModServerVersion}<br />
	 ,    : {$ModLastVersion}
</div>
<div class="hr_line"></div>
<div style="padding: 5px;">
	<strong> :</strong> <a href="?action=update&amp;version={$NowModInstallVersion}">  ({$ModServerVersion}   {$NowModInstallVersion})</a>
</div>
<div class="hr_line"></div>
<div style="padding: 5px;">
	{$result}
</div>
HTML;
								closetable();
								footer();
							}
								else
							{
								if( file_exists( ROOT_DIR."/{$FolderData}/{$NowModInstallVersion}.php" ) )
									{
										require( ROOT_DIR."/{$FolderData}/{$NowModInstallVersion}.php" );
										if( $_REQUEST['sql'] == "true" )
											{
												$sqlData = CharsetConvert( $_REQUEST['sqldata'] );
												$sqlData = explode( ";", $sqlData );
												if( trim( end( $sqlData ) ) == "" ) unset( $sqlData[ ( count( $sqlData ) - 1 ) ] );
												SqlQuery( $sqlData );
												
												if( is_array( $ConfigFileUpdate ) )
													{
														foreach( $ConfigFileUpdate as $UpdateFile )
															{
																SaveConfig( $UpdateFile['config'], $$UpdateFile['variable'], $UpdateFile['variable'], $UpdateFile['file'], $UpdateFile['comments'] );
															}
													}
												
												if( is_array( $CreateFileUpdate ) )
													{
														foreach( $CreateFileUpdate as $UpdateFile )
															{
																$fp = fopen( $UpdateFile['file'], "w" );
																if( $UpdateFile['value'] ) fwrite( $fp, $UpdateFile['value'] );
																fclose( $fp );
																chmod( $UpdateFile['file'], $UpdateFile['chmod'] );
															}
													}
												
												die( "  ,   ." );
											}
											
										EchoHeadInstall();	
										opentable( true );
										tableheader( "      <a href=\"http://rezer.net/\" target=\"_blank\">Rezer.net</a>");
										
										$SqlInstall = implode( "\n", $SqlDataUpdate );
										if( $config['version_id'] == "9.0" ) $JS = "<script language=\"javascript\" type=\"text/javascript\">function ShowLoading(){var Ajax = new dle_ajax; Ajax.onShow( \"\" );}function HideLoading(){var Ajax = new dle_ajax; Ajax.onHide( \"\" );}</script>";
										
										$ListEditFilesUpdate = ListInfoEditFile( $EditFilesUpdate, $NowModInstallVersion, "update" );
										if( !count( $SqlDataUpdate ) && !count( $EditFilesUpdate ) )
											$InfoUser = "<strong>  </strong>,       {$NowModInstallVersion}          .      ,      \" SQL   .\"";
										elseif( !count( $EditFilesUpdate ) )
											$InfoUser = "<strong>  </strong>,       {$NowModInstallVersion}      .           ,      \" SQL   .\"";
											
										if( $InfoUser ) $InfoUser = "<div class=\"hr_line\"></div><div style=\"padding: 5px;\">{$InfoUser}</div>";

								
echo <<<HTML
<script type="text/javascript" src="engine/classes/js/jquery.js"></script>
<script type="text/javascript" src="engine/classes/js/jqueryui.js"></script>
<script type="text/javascript" src="engine/skins/default.js"></script>
{$JS}
<script language="javascript" type="text/javascript">
	function SendSQL(){
		
		var Quest = confirm( " ,    sql ,     ?" );
		if( Quest === true )
			{
				var SqlData = document.getElementById( "sql_data" ).value;
				if( document.getElementById( "SqlResult" ).style.display == "none" ) ShowOrHide( "SqlResult" );
				$( "#SqlResult" ).html( ",  ..." );
				
				$.ajax({
					url: "{$ThisFile}",
					data: "&action=update&version={$NowModInstallVersion}&sql=true&sqldata=" + SqlData,
					success: function( data ){
						$( "#SqlResult" ).html( data );
					},
					dataType: "html",
					type: "POST"
				});
			}
	}
</script>
<div style="padding: 5px;">
	<b>  :</b><br /><br />
	   : {$ModServerVersion}<br />
	    : {$NowModInstallVersion}
</div>
<div class="hr_line"></div>
<div style="padding: 5px;">
	<strong>:</strong>      (  )    ,         "  ".
</div>
{$InfoUser}
<div class="hr_line"></div>
<div style="padding: 5px;">
	<div id="OptChange">
		<div class="dle_aTab" style="padding: 10px;">
			<a href="javascript:void(0);" onclick="ShowOrHide( 'sql_textarea' );">     ( )</a><br />
			<div id="sql_textarea" style="display: none;">
			<br /><textarea id="sql_data" style="width: 100%; height: 100px;">{$SqlInstall}</textarea><br /><br />
			 -      <br />
			{prefix} -      <br />
			 ";" -   <br />
			</div><br />
			<input type="submit" value=" SQL        " onclick="SendSQL(); return false;" class="buttons" />
			<div id="SqlResult" style="display: none; margin: 10px 0px 0px 0px; padding: 5px; border: 1px solid #cccccc; background: #F4FEF3;"></div>
		</div>
		<div class="dle_aTab" style="padding: 10px;">
			<div style="padding: 5px;" class="navigation">
				     :
			</div>
			{$ListEditFilesUpdate}
		</div>
	</div>
	<script type="text/javascript" src="engine/skins/tabs.js"></script>
	<script type="text/javascript">
	   initTabs( "OptChange", Array( " ", "  " ),0, '100%' );
	</script>
</div>
<div class="hr_line"></div>
<div style="padding: 5px;">
	<input type="button" class="buttons" onclick="if( confirm( ' ,   ?' ) === true ) window.location = '?action=update';" value="  " />
	<input type="button" class="buttons" onclick="if( confirm( ' ,        ?' ) === true ) window.location = '/{$config[admin_path]}?mod={$ModulePage}';" value="   " />
</div>
HTML;
									
										closetable();
										footer();
									}
										else
									{
										EchoBlockMaster( "      !<br /><br />&raquo; <a href=\"/{$config['admin_path']}?mod={$ModulePage}\">   </a><br />&raquo; <a href=\"?action=start\"> </a>", ": <span style=\"color: #F00;\">  !</span>", "  :" );
									}
							}
					}
						else
					{
						EchoBlockMaster( "   : {$ModServerVersion}<br /> ,    : <br /><br />&raquo; <a href=\"/{$config['admin_path']}?mod={$ModulePage}\">   </a><br />&raquo; <a href=\"?action=start\"> </a>", ": <span style=\"color: #F00;\">     ,   !</span>" );
					}
			}
				else
			{
				EchoBlockMaster( "   : <span style=\"color: #F00;\"> !</span> <br />,   : {$ModuleInstallVersion}", ": <span style=\"color: #F00;\">    ,   !</span> ( <a href=\"?action=install\"><a/>)" );
			}
	}

//-------------------------------------------------------------------
//
//				   
//
//-------------------------------------------------------------------

		else
	{

		EchoHeadInstall();	
		opentable( true );
		tableheader( "      <a href=\"http://rezer.net/\" target=\"_blank\">Rezer.net</a>" );
		
echo <<<HTML
<div style="padding: 5px;">
	<b>  </b><br /><br />
	          .
</div>
<div class="hr_line"></div>
<div style="padding: 5px; text-align: left; color: #000000;">
	 ,   . ,      :<br /><br />
	
	<a href="{$LicenseLink}" target="_blank" style="color:#03F;">{$LicenseLink}</a>
</div>
<div class="hr_line"></div>
<div style="padding: 5px;">
	<input type="checkbox" id="rules"> <label for="rules"><b> </b></label>
</div>
<div class="hr_line"></div>
<div style="padding: 5px;" class="navigation">
	<input type="button" class="buttons" value="" onclick="StartInstall();" />
</div>
<script language="Javascript">

function StartInstall(){
	
	if( document.getElementById( "rules" ).checked == false )
		{
			alert( "    !" );
		}
			else
		{
			window.location = "?action=start";
		}
}

</script>
HTML;
		
		closetable();
		footer();
	}	
	
?>