<?php

/**
 * AjaxController
 * 04/20/2012
 * @version 1.2
 * @copyright (c) 2013, Nick Gejadze
 */
class AjaxController extends NG\Controller {

    /**
     * Method acts like magic method __construct
     * Gets the configuration and initiates phpFlickr Model
     * Method Check if request is made with ajax, otherwise returns error
     * @access public
     * @return void
     */
    public function init() {
        //Load Configuration
        $this->config = \NG\Registry::get("config");
        // Disable View and Leyout
        $this->view->setLayout(false);
        $this->view->setNoRender(true);
        //if Request is not AJAX exit the page
        if (!\NG\App::isAjax()):
            exit("Access Denied");
        endif;
        //Init Flickr and assign to object
        $this->flickr = new phpFlickr($this->config['flickrApiKey']);
        //check if caching is enabled in config and set appropriate configuration
        if (isset($this->config['enableCache']) and $this->config['enableCache'] == true):
            $this->flickr->enableCache("fs", ROOT . DS . $this->config['cacheDirectory'], $this->config['cacheTime']);
        endif;
    }

    /**
     * Method sets allowDownload session to allow user download image, otherwise they would get "link expired" error
     * Gets image information from flickr and return view.
     * @access public
     * @return void
     */
    public function GetinfoAction() {
        // Allow Modal viewer to download image, see IndexController::downloadAction()
        \NG\Session::set("allowDownload", "true");
        // we do need layout but we need view, so enable lets enable it
        $this->view->setNoRender(false);
        // get requests 
        $request = \NG\Route::getRequests();
        // if photoid is requested
        if (isset($request['photoid']) and is_numeric($request['photoid'])):
            //assign variables to view
            $this->view->photo_id = $request['photoid'];
            // get photo info from flickr
            $this->view->photo_info = $this->flickr->photos_getInfo($request['photoid']);
            // get available sizes from flickr
            $this->view->available_sizes = $this->flickr->photos_getSizes($request['photoid']);
            //check if view and download is allowed in configuration
            $this->view->allowLocalImageDownload = $this->config['allowLocalImageDownload'];
            $this->view->allowLocalImageView = $this->config['allowLocalImageView'];
        // set error, wrong request
        else:
            $this->view->error = "photoid";
        endif;
    }

    /**
     * Methos is used for ajax pagination (lazyload)
     * @access public
     * @return void
     */
    public function SearchAction() {
        //we do not use layout but use the view
        $this->view->setNoRender(false);
        //get requests
        $request = \NG\Route::getRequests();
        //check keyword is requested
        if (isset($request['keyword'])):
            //define default parameters from configuration
            $licenseType = $this->config['licenseType'];
            $license = $this->config['license'];
            $sort = $this->config['sort'];
            //start page is always 1
            $page = "1";
            //if license is requested
            if (isset($request['license']) and $request['license'] == "commercial"):
                $license = "1,2,3,8";
            endif;
            // if page is requested
            if (isset($request['page']) and is_numeric($request['page'])):
                $page = $request['page'];
            endif;
            //if sort order is requested
            if (isset($request['sort'])):
                $sort = $request['sort'];
            endif;
            //init empty array
            $photos = array();
            //perform search on flickr
            $flickr_search = $this->flickr->photos_search(array(
                "text" => $request['keyword'],
                "sort" => $sort,
                "per_page" => "30",
                "license" => $license,
                "page" => $page
            ));
            //build proper array
            foreach ($flickr_search['photo'] as $key => $photo):
                $photos[] = array(
                    "ThumbUrl" => $this->flickr->buildPhotoURL($photo, "small"),
                    "authorUrl" => "http://www.flickr.com/photos/" . $photo['owner'] . "/" . $photo['id'],
                    "title" => $photo['title'],
                    "size" => "thumb",
                    "photoID" => $photo['id']
                );
            endforeach;
            //assign photo to view
            $this->view->photos = $photos;
        // if keyword is not set
        else:
            echo "Search Keyword Cant be empty";
        endif;
    }

}