<?php

/**
 * SearchController
 * 04/20/2012
 * @version 1.2
 * @copyright (c) 2013, Nick Gejadze
 */
class SearchController extends NG\Controller {

    /**
     * Method acts like magic method __construct
     * Gets the configuration and initiates phpFlickr Model
     * @access public
     * @return void
     */
    public function init() {
        //Get the configuration
        $this->config = \NG\Registry::get("config");
        // Initiate Flickr API and assign to object
        $this->flickr = new phpFlickr($this->config['flickrApiKey']);
        // Check if caching is on and initiate according to configuration
        if (isset($this->config['enableCache']) and $this->config['enableCache'] == true):
            $this->flickr->enableCache("fs", ROOT . DS . $this->config['cacheDirectory'], $this->config['cacheTime']);
        endif;
    }

    /**
     * Method is used for searching
     * @access public
     * @return void
     */
    public function IndexAction() {
        //Get all requests
        $request = \NG\Route::getRequests();
        //if keyword is requested 
        if (isset($request['keyword'])):
            //Url Decode keyword
            $request['keyword'] = urldecode($request['keyword']);
            //load Defaulf search parameters from configuration
            $licenseType = $this->config['licenseType'];
            $license = $this->config['license'];
            $sort = $this->config['sort'];
            $allowImageModal = $this->config['allowImageModal'];
            //Start page is always 1
            $page = "1";
            //if license is requested change it
            if (isset($request['license']) and $request['license'] == "commercial"):
                $licenseType = $request['license'];
                $license = "1,2,3,8";
            endif;
            //if page is requested
            if (isset($request['page']) and is_numeric($request['page'])):
                $page = $request['page'];
            endif;
            //if sorting is requested
            if (isset($request['sort'])):
                $sort = $request['sort'];
            endif;
            //init empty array
            $photos = array();
            //preform search on flickr
            $flickr_search = $this->flickr->photos_search(array(
                "text" => $request['keyword'],
                "sort" => $sort,
                "per_page" => "30",
                "license" => $license,
                "page" => $page
            ));
            //build proper array
            foreach ($flickr_search['photo'] as $key => $photo):
                $photos[] = array(
                    "ThumbUrl" => $this->flickr->buildPhotoURL($photo, "small"),
                    "authorUrl" => "http://www.flickr.com/photos/" . $photo['owner'] . "/" . $photo['id'],
                    "title" => $photo['title'],
                    "size" => "thumb",
                    "photoID" => $photo['id']
                );
            endforeach;
            //start building Pagination
            $last = $flickr_search['pages'];
            $front = $page - 2;
            $end = $page + 2;
            if ($front <= 1):
                $front = 1;
                $end = $last > 5 ? 5 : $last;
            endif;
            if ($end >= $last):
                $front = $last - 4 < 1 ? 1 : $last - 4;
                $end = $last;
            endif;
            //assign variables to view
            $this->view->front = $front;
            $this->view->end = $end;
            $this->view->title = str_replace("+", " ", $request['keyword']);
            $this->view->photos = $photos;
            $this->view->keyword = $request['keyword'];
            $this->view->license = $licenseType;
            $this->view->page = $page;
            $this->view->sort = $sort;
            $this->view->allowImageModal = $allowImageModal;
            $this->view->bodyData = 'data-keyword="' . filter_var($request['keyword'], FILTER_SANITIZE_STRING) . '" data-sort="' . filter_var($sort, FILTER_SANITIZE_STRING) . '" data-license="' . filter_var($licenseType, FILTER_SANITIZE_STRING) . '" data-page="' . filter_var($page, FILTER_SANITIZE_STRING) . '"';
        //if keyword is not requestedÏ
        else:
            $this->view->error = "Search Keyword Cant be empty";
        endif;
    }

}