<?php

require_once (ROOT . DS . 'Library' . DS . 'NG' . DS . 'Bootstrap.php');

use NG\Bootstrap as FrameworkBootstrap;

/**
 * Bootstrap
 * @package NG
 * @subpackage library
 * @version 0.1
 * @copyright (c) 2012, Nick Gejadze
 */
class Bootstrap extends FrameworkBootstrap {

    /**
     * Loads appliction.ini file ant parses to array
     * @access public
     * @return void
     */
    public function _initConfig() {
        $config = \NG\Configuration::loadConfigFile(ROOT . DS . APPDIR . DS . 'Config' . DS . 'application.ini');
        \NG\Registry::set("config", $config);
    }

    /**
     * Loads route.ini file, parses to array and adds new routes
     * @access public
     * @return void
     */
    public function _initRoute() {
        $route = \NG\Configuration::loadConfigFile(ROOT . DS . APPDIR . DS . 'Config' . DS . 'route.ini');
        \NG\Route::addRoute($route['routes']['default']);
        \NG\Route::addRoute($route['routes']['search']);
        \NG\Route::addRoute($route['routes']['searchfull']);
    }

    /**
     * loads database.ini file, parses to array and inits database connection
     */
    public function _initDB() {
        //$dbconfig = NG\Configuration::loadConfigFile(ROOT . DS . APPDIR . DS . 'Config' . DS . 'database.ini');
        //$db = new \NG\Database($dbconfig["Database"]["conname"]);
        //\NG\Registry::set("db", $db);
    }

    /**
     * Loads application.ini file, parses as array, then gets searchSuggestion and select random element
     * from array, store randomly selected phrase into registry
     * @access public
     * @return void
     */
    public function _initRandomWords() {
        $config = \NG\Configuration::loadConfigFile(ROOT . DS . APPDIR . DS . 'Config' . DS . 'application.ini');
        $array = $config['searchSuggestion'];
        $rand_key = array_rand($array);
        \NG\Registry::set("randomSearchKeyword", $array[$rand_key]);
    }

}

?>
