<?php

/**
 * IndexController
 * 04/20/2012
 * @version 1.2
 * @copyright (c) 2013, Nick Gejadze
 */
class IndexController extends NG\Controller {

    /**
     * Method acts like magic method __construct
     * Gets the configuration and initiates phpFlickr Model
     * @access public
     * @return void
     */
    public function init() {
        //Load Configuration from registry
        $this->config = \NG\Registry::get("config");
        // If Flickr API key is not set, return error
        if (!isset($this->config['flickrApiKey']) OR empty($this->config['flickrApiKey'])):
            $this->view->APIerror = "Please Enter you Flickr API key into Application/Config/application.ini file";
            exit();
        endif;
        // Initiate Flickr API and assign to object
        $this->flickr = new phpFlickr($this->config['flickrApiKey']);
        // Check if caching is on and initiate according to configuration
        if (isset($this->config['enableCache']) and $this->config['enableCache'] == true):
            $this->flickr->enableCache("fs", ROOT . DS . $this->config['cacheDirectory'], $this->config['cacheTime']);
        endif;
    }

    /**
     * Index Page, Gets random Background image Tags from configuration and performs search
     * Gets 20 image from Flickr and checks the image sizes, selects First "large" image from the array 
     * and passes to view
     * @see findLargeImage()
     * @access public
     * @return void
     */
    public function IndexAction() {
        //Checks if array of background images are defined in configuration, if so picks random Tag
        if (is_array($this->config['backgroundImage'])):
            $rand_keys = array_rand($this->config['backgroundImage']);
            $backgroundImageSearchKeyword = $this->config['backgroundImage'][$rand_keys];
        //If background image is not array
        else:
            $backgroundImageSearchKeyword = $this->config['backgroundImage'];
        endif;
        //Perform photo search on flickr with selected tag
        //license is set to non-commercial
        //page is random number from 1 to 15, this give range of 20 image * 15 pages, so random image is selected from 
        //300 images for each Tag.
        $photos = $this->flickr->photos_search(array(
            "text" => $backgroundImageSearchKeyword,
            "sort" => "interestingness-desc",
            "per_page" => "20",
            "license" => "4,5,6,7",
            "page" => rand(1, 15)
        ));
        // Foreach images (20 images in total) find first one that has "large" size and return
        $photo = $this->findLargeImage($photos['photo']);
        //assign variables to view
        //configuration
        $this->view->config = $this->config;
        //Search term for background image
        $this->view->discover = $backgroundImageSearchKeyword;
        //information for background image, user to credit author
        $this->view->photo_info = $this->flickr->photos_getInfo($photo['id']);
        //backgorund image
        $this->view->bgimg = array(
            "ThumbUrl" => $photo['source'],
            "authorUrl" => "http://www.flickr.com/photos/" . $photo['owner'] . "/" . $photo['id'],
            "title" => $photo['title'],
            "photoID" => $photo['id']
        );
    }

    /**
     * Test method to check server uptime.
     * Please note: This method is not required for application
     * @access public
     * @return void
     */
    public function statusAction() {
        //Disable Layout
        $this->view->setLayout(false);
        //Disable View
        $this->view->setNoRender(true);
        echo "ok";
    }

    /**
     * Reads image from Flickr and forces to download
     * Method checks if $_SESSION['allowDownload'] is set, this will prevent sharing of download link
     * @access public
     * @retrun void
     */
    public function downloadAction() {
        //Disable Layout
        $this->view->setLayout(false);
        //Disable View
        $this->view->setNoRender(true);
        //Get Requests from URL
        $request = \NG\Route::getRequests();
        // if image is requested and session is set
        if (isset($request['image']) and !empty($request['image']) and \NG\Session::get("allowDownload")):
            //explode image URL and Array KEY
            //you can use 'list' function to define variables, but I like explode more.
            $image_explode = explode("_", $request['image']);
            $imageID = $image_explode[0];
            $imageSizeKey = $image_explode[1];
            //check if imageid and size key are numeric values
            if (!is_numeric($imageID) OR !is_numeric($imageSizeKey)):
                echo 'Sorry, unknown request';
                exit();
            endif;
            //Get available sizes for image
            $available_sizes = $this->flickr->photos_getSizes($imageID);
            //Get image URL
            $imageURL = $available_sizes[$imageSizeKey]['source'];
            //Validate image URL structure 
            if (filter_var($imageURL, FILTER_VALIDATE_URL)):
                //Parse local url
                $parse = parse_url(\NG\Uri::baseUrl());
                //Set proper Headers for download
                header('Content-Description: File Transfer');
                header('Content-type: application/octet-stream');
                //Set custom image filename for download
                header('Content-Disposition: attachment; filename="[' . $parse['host'] . ']-' . $imageID . '_' . $imageSizeKey . '.' . pathinfo($imageURL, PATHINFO_EXTENSION) . '"');
                //read image from Flickr and return
                readfile($imageURL);
                exit();
            //wrong of broken image URL
            else:
                echo 'Sorry, unknown request';
            endif;
        //if image is not requested or session is not set
        else:
            echo 'Sorry, Download link is expired';
        endif;
    }

    public function viewAction() {
        //Disable Layout
        $this->view->setLayout(false);
        //Disable View
        $this->view->setNoRender(true);
        //Get Requests from URL
        $request = \NG\Route::getRequests();
        // if image is requested
        if (isset($request['image']) and !empty($request['image'])):
            //remove the extension, Note that framework removes extension too, so at this point there should not be a extension
            $imageURLwithoutExt = preg_replace("/\\.[^.\\s]{3,4}$/", "", $request['image']);
            //explode image URL and Array KEY
            //you can use 'list' function to define variables, but I like explode more.
            $image_explode = explode("_", $imageURLwithoutExt);
            $imageID = $image_explode[0];
            $imageSizeKey = $image_explode[1];
            // Get image available sizes from flickr
            $available_sizes = $this->flickr->photos_getSizes($imageID);
            // Get Requested image URL
            $imageURL = $available_sizes[$imageSizeKey]['source'];
            //if(filter_var($imageURL, FILTER_VALIDATE_URL)):
            //identify image extension
            $filename = basename($imageURL);
            $file_extension = strtolower(substr(strrchr($filename, "."), 1));
            //Switch content type according to image file extension
            switch ($file_extension):
                case "gif":
                    $ctype = "image/gif";
                    break;
                case "png":
                    $ctype = "image/png";
                    break;
                case "jpeg":
                case "jpg":
                    $ctype = "image/jpg";
                    break;
                default:
                    $ctype = "application/octet-stream";
            endswitch;
            //read file from flickr and return as image
            header("Content-type: " . $ctype);
            readfile($imageURL);
            exit();
        else:
            echo 'Sorry, Image not found';
        endif;
    }

    /**
     * shuffles array elements and for each element checks image size 
     * if "Large" size is found puts in $selectedPhoto variable and Returns
     * @access private
     * @param array $photos
     * @return array $selectedPhoto
     */
    private function findLargeImage($photos) {
        shuffle($photos);
        $selectedPhoto = false;
        foreach ($photos as $photo):
            if (!$selectedPhoto):
                $sizes = $this->flickr->photos_getSizes($photo['id']);
                foreach ($sizes as $size):
                    if ($size["label"] == "Large"):
                        $photo['source'] = $size['source'];
                        $selectedPhoto = $photo;
                    endif;
                endforeach;
            endif;
        endforeach;
        return $selectedPhoto;
    }

    /**
     * Terms of serviec Method
     * See view file
     * @access public
     * @return void
     */
    public function tosAction() {
        $this->view->nosearch = true;
        $this->view->page = "tos";
        $this->view->title = "Terms of Service";
    }

    /**
     * Privacy policy Method
     * See view file
     * @access public
     * @return void
     */
    public function privacyAction() {
        $this->view->nosearch = true;
        $this->view->page = "privacy";
        $this->view->title = "Privacy Policy";
    }

}

?>
