<?php

/**
 * ViewController
 * 04/20/2012
 * @version 1.2
 * @copyright (c) 2013, Nick Gejadze
 */
class ViewController extends NG\Controller {

    /**
     * Method acts like magic method __construct
     * Gets the configuration and initiates phpFlickr Model
     * @access public
     * @return void
     */
    public function init() {
        //Get the configuration
        $this->config = \NG\Registry::get("config");
        // Initiate Flickr API and assign to object
        $this->flickr = new phpFlickr($this->config['flickrApiKey']);
        // Check if caching is on and initiate according to configuration
        if (isset($this->config['enableCache']) and $this->config['enableCache'] == true):
            $this->flickr->enableCache("fs", ROOT . DS . $this->config['cacheDirectory'], $this->config['cacheTime']);
        endif;
    }

    /**
     * Method displayes image page
     * @access public
     * @return void
     */
    public function imageAction() {
        //get all requests
        $request = \NG\Route::getRequests();
        //set session to allow image download
        \NG\Session::set("allowDownload", "true");
        //is id is requested and id is numeric
        if (isset($request['id']) and is_numeric($request['id'])):
            //Set photo id for view
            $this->view->photo_id = $request['id'];
            //Get photo info(title, description, etc..) for requested id from flickr
            $this->view->photo_info = $this->flickr->photos_getInfo($request['id']);
            //remove non alphanumerical characters from image title
            $keyword = preg_replace("/[^A-Za-z0-9 ]/", " ", $this->view->photo_info['photo']['title']);
            //explode title to words array
            $keyword = explode(" ", $keyword);
            //select first word
            $keyword = $keyword[0];
            //get defualt search parameters from configuration
            $license = $this->config['license'];
            $sort = $this->config['sort'];
            //search photos on flickr with requested images titles first word
            $flickr_search = $this->flickr->photos_search(array(
                "text" => $keyword,
                "sort" => $sort,
                "per_page" => "21",
                "license" => $license,
                "page" => 1
            ));
            //rewrite to proper array
            foreach ($flickr_search['photo'] as $key => $photo):
                if ($photo['id'] != $request['id']):
                    $photos[] = array(
                        "ThumbUrl" => $this->flickr->buildPhotoURL($photo, "square"),
                        "authorUrl" => "http://www.flickr.com/photos/" . $photo['owner'] . "/" . $photo['id'],
                        "title" => $photo['title'],
                        "size" => "thumb",
                        "photoID" => $photo['id']
                    );
                endif;
            endforeach;
            //if related images are found assign to view
            if (isset($photos)):
                $this->view->relatedImages = $photos;
            endif;
            // Get All available sizes
            $this->view->title = $this->view->photo_info['photo']['title'];
            // For meta tags lets get Image Description and stip HTML Tags and non alphanumeric character
            $metaDescription = preg_replace("/[^A-Za-z0-9 ]/", " ", strip_tags($this->view->photo_info['photo']['description']));
            $metaDescriptionArray = explode(" ", $metaDescription);
            //for meta keywords, seperate image description words and if word is more then 3 characters use as keyword
            $metaKeywords = "";
            foreach ($metaDescriptionArray as $metaArray):
                if (strlen($metaArray) > 3):
                    $metaKeywords .= $metaArray . ", ";
                endif;
            endforeach;
            //assign variables to view
            // we should limit keywords to 150 characters for best SEO
            $this->view->metaKeywords = substr_replace($this->limitString($metaKeywords, 150), "", -2);
            // we should limit description to 250 characters for best SEO
            $this->view->metaDescription = preg_replace('/\s+/', ' ', $this->limitString($metaDescription, 250));
            $this->view->available_sizes = $this->flickr->photos_getSizes($request['id']);
            $this->view->allowLocalImageDownload = $this->config['allowLocalImageDownload'];
            $this->view->allowLocalImageView = $this->config['allowLocalImageView'];
        else:
            $this->view->error = "imageid";
        endif;
    }

    /**
     * limit number of characters in sentence 
     * @param string $string
     * @param int $limit
     * @return String
     */
    private function limitString($string, $limit = 100) {
        // Return early if the string is already shorter than the limit
        if (strlen($string) < $limit):
            return $string;
        endif;
        $regex = "/(.{1,$limit})\b/";
        preg_match($regex, $string, $matches);
        return $matches[1];
    }

}

?>
