$(function() {
    var url = {
        currentURL: function() {
            return window.location.href;
        },
        baseURL: function() {
            return $("base").attr('href');
        },
        isHomePage: function() {
            if (url.currentURL() == url.baseURL()) {
                return true;
            } else {
                return false;
            }
        }
    }



    var page = {
        init: function() {
            page.reorganize();
        },
        getViewportWidth: function() {
            return "undefined" != typeof window.innerWidth ? window.innerWidth : "undefined" != typeof document.documentElement && "undefined" != typeof document.documentElement.clientWidth && 0 != document.documentElement.clientWidth ? document.documentElement.clientWidth : document.getElementsByTagName("body")[0].clientWidth
        },
        determineWidth: function() {
            var a = {};
            a.width = page.getViewportWidth();
            1200 <= a.width && (a.name = "BigDesktop");
            999 < a.width && 1200 >= a.width && (a.name = "SmallDesktop");
            768 <= a.width && 999 >= a.width && (a.name = "LandscapeTablet");
            480 < a.width && 768 > a.width && (a.name = "PortraitTablet");
            480 >= a.width && (a.name = "Mobile");
            return a
        },
        reorganize: function() {
            var a = page.determineWidth();
            switch (a.name) {
                case "BigDesktop":
                case "SmallDesktop":
                    search.desktopSearch();
                    $(".leftPanel").css({
                        "height": $(window).height() - 120
                    });
                    break;
                case "LandscapeTablet":
                    search.tabletSearch();
                    $(".leftPanel").css({
                        "height": $(window).height() - 120
                    });
                    break;
                case "PortraitTablet":
                    $(".leftPanel").css({
                        "height": "100px"
                    });
                    break;
                case "Mobile":
                    $(".leftPanel").css({
                        "height": "170px"
                    });
            }
        }
    }

    var search = {
        desktopSearch: function() {
            $(window).off("scroll");
            var a = page.determineWidth();
            if (a.name == "BigDesktop" || a.name == "SmallDesktop") {
                $(".SearchExpend").remove();
                $(".full-search").affix();
                var search = $(".full-search").children();
                if (!url.isHomePage()) {
                    if($(".leftPanel").outerWidth() > 0){
                        $(".full-search").stop().removeClass("span2").animate({
                            "margin-left": ($(".leftPanel").outerWidth() - 15) + "px",
                            "width": "72%"
                        }, 200);
                    }
                }
                $(window).scroll(function() {
                    if ($(document).scrollTop() == 0) {
                        search.stop().animate({
                            "opacity": 1
                        }, 300);
                        $(".full-search").stop().animate({
                            "margin-top": 0
                        }, 200);
                    } else if ($(window).scrollTop() + $(window).height() == $(document).height()) {
                        search.stop().animate({
                            "opacity": 1
                        }, 300);
                        $(".full-search").stop().animate({
                            "margin-top": 0
                        }, 200);
                    } else if ($(document).scrollTop() > 100 && $(window).scrollTop() + $(window).height() < $(document).height()) {
                        search.stop().animate({
                            "opacity": .7
                        }, 300);
                        $(".full-search").stop().animate({
                            "margin-top": "-50px"
                        }, 100);
                    }
                });

                $(".full-search").hover(
                        function() {
                            search.stop().animate({
                                "opacity": 1
                            }, 200);
                            $(".full-search").stop().animate({
                                "margin-top": 0
                            }, 200);
                        },
                        function() {
                            if ($(document).scrollTop() !== 0) {
                                search.stop().animate({
                                    "opacity": .7
                                }, 300);
                                $(".full-search").stop().animate({
                                    "margin-top": "-50px"
                                }, 100);
                            }
                        });

            }
            $("#imageSearch").focus(function() {
                $(".full-search").stop().animate({
                    "margin-top": 0
                }, 200);
            });
        },
        tabletSearch: function() {
            $(".full-search").off("hover");
            var a = page.determineWidth();
            if (a.name == "LandscapeTablet" && !url.isHomePage()) {
                $(window).scroll(function() {
                    if ($(document).scrollTop() == 0) {
                        $(".full-search").stop().removeClass("span2").animate({
                            "margin-top": "0px",
                            "margin-left": ($(".leftPanel").outerWidth() - 14) + "px",
                            "width": "72%"
                        }, 200);
                        $(".searchTrigger").fadeOut("fast", function() {
                            $(".search-item").fadeIn();
                        });
                    } else if ($(document).scrollTop() > 0 && $(window).scrollTop() + $(window).height() < $(document).height()) {
                        $(".full-search").stop().addClass("span2").animate({
                            "margin-top": "-60px",
                            "margin-left": "-25px",
                            "width": "140px"
                        }, 200);
                        $(".search-item").fadeOut("fast", function() {
                            $(".searchTrigger").fadeIn();
                        });
                    }
                });
                $(".searchExpend").live("click", function() {
                    $("html, body").stop().animate({
                        scrollTop: 0
                    }, "slow");
                    return false;
                });
            } else if (a.name == "PortraitTablet" && !url.isHomePage()) {
                $(window).scroll(function() {
                    if ($(document).scrollTop() == 0) {
                        $(".full-search").stop().removeClass("span2").animate({
                            "margin-top": "0px",
                            "margin-left": ($(".leftPanel").outerWidth() - 14) + "px",
                            "width": "72%"
                        }, 200);
                        $(".searchTrigger").fadeOut("fast", function() {
                            $(".search-item").fadeIn();
                        });
                    } else if ($(document).scrollTop() > 0 && $(window).scrollTop() + $(window).height() < $(document).height()) {
                        $(".full-search").stop().addClass("span2").animate({
                            "margin-top": "-60px",
                            "margin-left": "-25px",
                            "width": "140px"
                        }, 200);
                        $(".search-item").fadeOut("fast", function() {
                            $(".searchTrigger").fadeIn();
                        });
                    }
                });
                $(".searchExpend").live("click", function() {
                    $("html, body").stop().animate({
                        scrollTop: 0
                    }, "slow");
                    return false;
                });
            } else if (a.name == "LandscapeTablet") {
                $(window).scroll(function() {
                    var search = $(".full-search").children();
                    if ($(document).scrollTop() == 0) {
                        search.stop().animate({
                            "opacity": 1
                        }, 300);

                    } else if ($(window).scrollTop() + $(window).height() == $(document).height()) {
                        search.stop().animate({
                            "opacity": 1
                        }, 300);

                    } else if ($(document).scrollTop() > 100 && $(window).scrollTop() + $(window).height() < $(document).height()) {
                        search.stop().animate({
                            "opacity": .7
                        }, 300);

                    }
                });
            } else if (a.name == "PortraitTablet") {
                $(".full-search").stop().removeClass("span2").animate({
                    "margin-top": "0px",
                    "margin-right": "0px",
                    "width": "50%"
                }, 200);
            }
        }
    }

    var masonryLoader = {
        init: function() {
            var $container = $('#content');
            var gutter = 12;
            var min_width = 200;
            $container.imagesLoaded(function() {
                $container.masonry({
                    itemSelector: '.box',
                    gutterWidth: gutter,
                    isAnimated: true,
                    columnWidth: function(containerWidth) {
                        var num_of_boxes = (containerWidth / min_width | 0);

                        var box_width = (((containerWidth - (num_of_boxes - 1) * gutter) / num_of_boxes) | 0);

                        if (containerWidth < min_width) {
                            box_width = containerWidth;
                        }

                        $('.box').width(box_width);
                        return box_width;
                    }
                });
            });

            $container.infinitescroll({
                navSelector: '#page-nav', // selector for the paged navigation 
                nextSelector: '#page-nav a', // selector for the NEXT link (to page 2)
                itemSelector: '.box', // selector for all items you'll retrieve            
                bufferPx: 100,
                //currPage: $("#page-nav").data("curpage"),
                path: function(index) {
                    return $("#page-nav > a").attr("href") + ($("#page-nav").data("curpage") + index);
                },
                //prefill: true,
                //debug: true,
                loading: {
                    finishedMsg: 'No more pages to load.',
                    msgText: "Loading Images, Please Wait...",
                    img: 'Assets/img/loader.gif'
                }
            },
            // trigger Masonry as a callback
            function(newElements) {
                $(".paginationWrapper").fadeOut("slow");
                var $newElems = $(newElements).css({opacity: 0});
                // ensure that images load before adding to masonry layout
                $newElems.imagesLoaded(function() {
                    // show elems now they're ready
                    $newElems.animate({opacity: 1});
                    $container.masonry('appended', $newElems, true);
                    $container.masonry({itemSelector: '.box',
                        gutterWidth: gutter,
                        isAnimated: true,
                        columnWidth: function(containerWidth) {
                            var num_of_boxes = (containerWidth / min_width | 0);

                            var box_width = (((containerWidth - (num_of_boxes - 1) * gutter) / num_of_boxes) | 0);

                            if (containerWidth < min_width) {
                                box_width = containerWidth;
                            }

                            $('.box').width(box_width);
                            return box_width;
                        }
                    });
                });
            });
        }
    }


    var options = {
        keyword: $("body").data('keyword'),
        license: $("body").data('license'),
        pageN: $("body").data('page'),
        sort: $("body").data('sort'),
        init: function() {
            $("#commercial").change(function() {
                if ($(this).is(":checked")) {
                    window.location = "/search/" + options.keyword + "/license/commercial/sort/" + options.sort + "/page/1";
                }
            });
            $("#noncommercial").change(function() {
                if ($(this).is(":checked")) {
                    window.location = "/search/" + options.keyword + "/license/nonCommercial/sort/" + options.sort + "/page/1";
                }
            });
            $("#recent,#relevance,#interestingness").change(function() {
                if ($(this).is(":checked")) {
                    window.location = "/search/" + options.keyword + "/license/" + options.license + "/sort/" + $(this).val() + "/page/1";
                }
            });
        }
    };

    var fullBg = {
        init: function($img) {
            var src = $img.attr("src");
            $.backstretch(src);
            $img.remove();

        }
    }

    jQuery.fn.center = function() {

        return this;
    }

    var app = {
        init: function() {
            page.init();
            $(window).resize(function() {
                page.reorganize();
                $("#background").css({"height": ($("#background").height() - 45) + "px"});
            });
            options.init();
            if (!url.isHomePage()) {
                $(".container").css({"position": "relative"});
            } else {
                $(window).load(function() {
                    fullBg.init($("#background"));

                    $(".full-search").css({
                        position: "absolute",
                        margin: "0px",
                        top: Math.max(0, (($(window).height() - $(".full-search").outerHeight()) / 3) +
                                $(window).scrollTop()) + "px",
                        left: Math.max(0, (($(".container").width() - $(".full-search").outerWidth()) / 2) +
                                $(window).scrollLeft()) + "px"
                    });
                    $(".item-search").css({"margin": "0px"})
                    $(window).resize(function() {
                        $(".full-search").css("top", Math.max(0, (($(window).height() - $(".full-search").outerHeight()) / 3) +
                                $(window).scrollTop()) + "px");
                        $(".full-search").css("left", Math.max(0, (($(".container").width() - $(".full-search").outerWidth()) / 2) +
                                $(window).scrollLeft()) + "px");
                    });
                });

            }
            $("#collapsed-navbar ." + $('body').attr('class')).attr('selected', 'selected');
            $("#collapsed-navbar").change(function() {
                window.location = $(this).val();
            });
            masonryLoader.init();
            $('body').tooltip({
                selector: '[rel=tooltip]',
                "placement": "bottom"
            });
            $("#fullSearch").submit(function() {
                var val = $("#imageSearch").val();
                window.location = "/" + val.replace(/\s/g, "+");
                return false;
            });
            
        }
    }

    app.init();


    var $modal = $('#full-width');

    $('.ajax').live('click', function() {
        var $this = $(this);
        $('body').modalmanager('loading');
        setTimeout(function() {
            $modal.load('/ajax/getinfo/photoid/'+$this.data('photoid'), '', function() {
                $modal.modal({"width": $(".container").width() + "px","resize":true, "modalOverflow":true});
                try{
                    FB.XFBML.parse(); 
                }catch(ex){}
            });
        }, 1000);
        return false;
    });
});