<?php 
Class SocAuth extends DB
{
	public function getRecord($state)
	{
		$result = $this->query_row("
			SELECT * FROM `" . DB_PREFIX . "socnetauth_records` 
			WHERE state='".$this->escape($state)."'");
		
		return $result;
	}
	
	public function setRecord($state, $redirect)
	{
		$this->query_run("DELETE FROM `" . DB_PREFIX . "socnetauth_records` 
			WHERE DATE_ADD(cdate, INTERVAL 15 MINUTE)<NOW()");
			
		$this->query_run("INSERT INTO `" . DB_PREFIX . "socnetauth_records` 
			SET 
				`state` = '".$this->escape($state)."',
				`redirect` = '".$this->escape($redirect)."',
				`cdate` = NOW()");
	}
	
  	public function facebook_check($id) 
	{
		if( empty($id) ) return false;
		
		$result = $this->query_row("
			SELECT * FROM `" . DB_PREFIX . "customer` 
			WHERE socnetauth_facebook_id='".$this->escape($id)."'");
			
		return $result;
	}
	
	public function vkontakte_check($id) 
	{
		if( empty($id) ) return false;
		
		$result = $this->query_row("
			SELECT * FROM `" . DB_PREFIX . "customer` 
			WHERE socnetauth_vkontakte_id='".$this->escape($id)."'");
		
		return $result;
	}
	
  	public function twitter_check($id) 
	{
		if( empty($id) ) return false;
		
		$result = $this->query_row("
			SELECT * FROM `" . DB_PREFIX . "customer` 
			WHERE socnetauth_twitter_id='".$this->escape($id)."'");
			
		return $result;
	}
	
  	public function odnoklassniki_check($id) 
	{
		if( empty($id) ) return false;
		
		$result = $this->query_row("
			SELECT * FROM `" . DB_PREFIX . "customer` 
			WHERE socnetauth_odnoklassniki_id='".$this->escape($id)."'");
			
		return $result;
	}
	
	public function facebook_preregistration($data)
	{
		/*				
			id=>100000402380563
			name=>Petrov Konstantin
			first_name=>Petrov
			last_name=>Konstantin
			link=>http://www.facebook.com/petrov.konstantin
			username=>petrov.konstantin
			email=>kin208@gmail.com
			timezone=>6
			locale=>en_US
			verified=>1
			updated_time=>2012-02-11T12:39:00+0000
		*/
		
		$this->query_run("DELETE FROM `" . DB_PREFIX . "socnetauth_preregistration` 
			WHERE DATE_ADD(cdate, INTERVAL 1 HOUR)<NOW()");
			
		$precode = md5(rand());
		
		$this->query_run("INSERT INTO `" . DB_PREFIX . "socnetauth_preregistration` 
			SET 
				`soc_id`='".(int)$data['id']."',
				`type`='facebook',
				`profile`='".$this->escape($data['link'])."',
				`firstname`='".$this->escape($data['first_name'])."',
				`lastname`='".$this->escape($data['last_name'])."',
				`email`='".$this->escape($data['email'])."',
				`precode`='".$precode."', 
				cdate=NOW()");
		
		return $precode;
	}
	
	public function vkontakte_preregistration($data)
	{
		/*				
			uid,
			first_name,
			last_name,
			nickname,
			screen_name,
			sex,
			bdate,
			city,
			country,
			timezone,
			photo			
		*/
		
		$this->query_run("DELETE FROM `" . DB_PREFIX . "socnetauth_preregistration` 
			WHERE DATE_ADD(cdate, INTERVAL 1 HOUR)<NOW()");
		
		$precode = md5(rand());
		
		$this->query_run("SET NAMES utf8");
		
		$this->query_run("INSERT INTO `" . DB_PREFIX . "socnetauth_preregistration` 
			SET 
				`soc_id`='".(int)$data['uid']."',
				`type`='vkontakte',
				`profile`='http://vk.com/id".$this->escape($data['uid'])."',
				`firstname`='".$this->escape($data['first_name'])."',
				`lastname`='".$this->escape($data['last_name'])."',
				`city`='".$this->escape($data['city'])."',
				`precode`='".$precode."',  
				cdate=NOW()");
		
		return $precode;
	}
	
	
	
	public function twitter_preregistration($data)
	{
		$ar1 = explode(" ", $data->name);
		$first_name = $ar1[0];
		$last_name = $ar1[1];
		
		$this->query_run("DELETE FROM `" . DB_PREFIX . "socnetauth_preregistration` 
			WHERE DATE_ADD(cdate, INTERVAL 1 HOUR)<NOW()");
			
		$precode = md5(rand());
		
		$this->query_run("SET NAMES utf8");
		
		$this->query_run("INSERT INTO `" . DB_PREFIX . "socnetauth_preregistration` 
			SET 
				`soc_id`='".(int)$data->id."',
				`type`='twitter',
				`profile`='https://twitter.com/".$data->screen_name."',				
				`firstname`='".$this->escape($first_name)."',
				`lastname`='".$this->escape($last_name)."',
				`precode`='".$precode."', 
				cdate=NOW()");
		
		
		
		return $precode;
		
		/*
			stdClass Object ( 
				[id] => 302692766 
				[profile_background_image_url] => http://a0.twimg.com/images/themes/theme1/bg.png 
				[id_str] => 302692766 
				[profile_link_color] => 0084B4 
				[friends_count] => 6 
				[profile_background_image_url_https] => https://si0.twimg.com/images/themes/theme1/bg.png 
				[follow_request_sent] => 
					[default_profile_image] => 1 
					[favourites_count] => 0 
					[profile_use_background_image] => 1 
					[statuses_count] => 4 
					[utc_offset] => -25200 
					[profile_text_color] => 333333 
					[profile_image_url_https] => https://si0.twimg.com/sticky/default_profile_images/default_profile_5_normal.png 
					[name] => ааОаНббаАаНбаИаН ааЕббаОаВ 
					[lang] => ru 
					[protected] => 
						[profile_sidebar_border_color] => C0DEED 
						[url] => 
							[is_translator] => 
								[default_profile] => 1 
								[description] => 
									[created_at] => Sat May 21 16:10:09 +0000 2011 
									[profile_background_tile] => 
										[profile_sidebar_fill_color] => DDEEF6 
										[following] => 
											[followers_count] => 0 
											[contributors_enabled] => 
												[time_zone] => Mountain Time (US & Canada) 
												[listed_count] => 0 
												[profile_background_color] => C0DEED 
												[location] => 
													[notifications] => 
														[status] => 
															stdClass Object ( 
																				[coordinates] => 
																					[place] => 
																						[retweet_count] => 0 
																						[geo] => 
																							[retweeted] => 
																								[created_at] => Thu Feb 09 17:32:12 +0000 2012 
																								[in_reply_to_screen_name] => 
																									[truncated] => 
																										[in_reply_to_status_id_str] => 
																											[in_reply_to_status_id] => 
																												[in_reply_to_user_id_str] => 
																													[id_str] => 167662092491571200 
																													[contributors] => 
																														[in_reply_to_user_id] => 
																															[possibly_sensitive_editable] => 1 
																																[possibly_sensitive] => 
																																	[favorited] => 
																																		[source] => Mobile Web 
																																		[id] => 167662092491571200 
																																		[text] => TEST2 http://t.co/dPp1xP9D ) 
																																		[verified] => 
																																			[geo_enabled] => 
																																				[screen_name] => kep208 
																																				[profile_image_url] => http://a0.twimg.com/sticky/default_profile_images/default_profile_5_normal.png 
		) 
		*/
	}
	
	public function odnoklassniki_preregistration($data)
	{
		/*
			uid - user ID
			birthday - date of birth
			age - user`s age
			first_name - user`s name
			last_name - user`s last name
			name - composition of first and last name to render
			has_email - true/false has or not e-mail
			gender - gender
			pic_1 - profile small icon (50x50)
			pic_2 - profile small picture (128x128)
		*/
		
		
		$this->query_run("DELETE FROM `" . DB_PREFIX . "socnetauth_preregistration` 
			WHERE DATE_ADD(cdate, INTERVAL 1 HOUR)<NOW()");
			
		$precode = md5(rand());
		
		$this->query_run("SET NAMES utf8");
		
		$this->query_run("INSERT INTO `" . DB_PREFIX . "socnetauth_preregistration` 
			SET 
				`soc_id`='".(int)$data['uid']."',
				`type`='odnoklassniki',
				`firstname`='".$this->escape($data['first_name'])."',
				`lastname`='".$this->escape($data['last_name'])."',
				`precode`='".$precode."', 
				cdate=NOW()");
		
		return $precode;
	}
	
	
	public function get_config_param($param_name)
	{
		$row = $this->query_row("SELECT * FROM `" . DB_PREFIX . "setting` 
		WHERE `group`='socnetauth' AND `key`='".$param_name."'");
		
		return $row['value'];
	}
	
}

?>