<?php
class ControllerModuleSocnetauth extends Controller {
	private $error = array(); 
	
	public function install()
	{
		$this->load->model('module/socnetauth');
		$this->model_module_socnetauth->createTables();
	}
	
	public function uninstall()
	{
		$this->load->model('module/socnetauth');
		$this->model_module_socnetauth->dropTables();
	}
	
	
	public function index() {   
		$this->load->language('module/socnetauth');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('setting/setting');
				
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('socnetauth', $this->request->post);		
			
			$this->cache->delete('product');
			
			$this->session->data['success'] = $this->language->get('text_success');
			
			
			if( !empty($this->request->post['stay']) )
			{
				$this->redirect($this->url->link('module/socnetauth', 'token=' . $this->session->data['token'].'&mess=save', 'SSL'));
			}
			else
			{
				$this->redirect($this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'));
			}
		}
				
		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_enabled'] = $this->language->get('text_enabled');
		$this->data['text_disabled'] = $this->language->get('text_disabled');
		
		$this->data['tab_help'] = $this->language->get('tab_help');
		//============================================
		
		$this->data['text_content_top'] = $this->language->get('text_content_top');
		$this->data['text_content_bottom'] = $this->language->get('text_content_bottom');		
		$this->data['text_column_left'] = $this->language->get('text_column_left');
		$this->data['text_column_right'] = $this->language->get('text_column_right');
		
		$this->data['entry_layout'] = $this->language->get('entry_layout');
		$this->data['entry_status'] = $this->language->get('entry_status');
		$this->data['entry_sort_order'] = $this->language->get('entry_sort_order');
		
		$this->data['button_add_module'] = $this->language->get('button_add_module');
		$this->data['button_remove'] = $this->language->get('button_remove');
		
		
		$this->data['entry_odnoklassniki_status'] = $this->language->get('entry_odnoklassniki_status');
		$this->data['entry_vkontakte_status'] = $this->language->get('entry_vkontakte_status');
		$this->data['entry_twitter_status'] = $this->language->get('entry_twitter_status');
		$this->data['entry_facebook_status'] = $this->language->get('entry_facebook_status');
		$this->data['entry_status'] = $this->language->get('entry_status');
		$this->data['entry_popup'] = $this->language->get('entry_popup');
		
		$this->data['text_description'] = $this->language->get('text_description');
		
		$this->data['entry_facebook'] = $this->language->get('entry_facebook');
		$this->data['entry_facebook_appid'] = $this->language->get('entry_facebook_appid');
		$this->data['entry_facebook_appsecret'] = $this->language->get('entry_facebook_appsecret');
		$this->data['entry_facebook_link'] = $this->language->get('entry_facebook_link');
		
		$this->data['entry_twitter'] = $this->language->get('entry_twitter');
		$this->data['entry_twitter_consumer_key'] = $this->language->get('entry_twitter_consumer_key');
		$this->data['entry_twitter_consumer_secret'] = $this->language->get('entry_twitter_consumer_secret');
		
		$this->data['entry_vkontakte'] = $this->language->get('entry_vkontakte');
		$this->data['entry_vkontakte_appid'] = $this->language->get('entry_vkontakte_appid');
		$this->data['entry_vkontakte_appsecret'] = $this->language->get('entry_vkontakte_appsecret');
		
		$this->data['text_vkontakte_instruction'] = $this->language->get('text_vkontakte_instruction');
		$this->data['text_facebook_instruction'] = $this->language->get('text_facebook_instruction');
		$this->data['text_twitter_instruction'] = $this->language->get('text_twitter_instruction');
		$this->data['text_odnoklassniki_instruction'] = $this->language->get('text_odnoklassniki_instruction');
		
		if( !empty( $this->request->get['mess'] ) )
		{
			$this->data['success'] = $this->language->get('text_success');
		}
		else
		{
			$this->data['success'] = '';
		}
		
		$this->data['entry_odnoklassniki'] = $this->language->get('entry_odnoklassniki');
		$this->data['entry_odnoklassniki_application_id'] = $this->language->get('entry_odnoklassniki_application_id');
		$this->data['entry_odnoklassniki_public_key'] = $this->language->get('entry_odnoklassniki_public_key');
		$this->data['entry_odnoklassniki_secret_key'] = $this->language->get('entry_odnoklassniki_secret_key');
		
		$this->data['entry_generator_notice'] = $this->language->get('entry_generator_notice');
		$this->data['entry_generator_header'] = $this->language->get('entry_generator_header');
		$this->data['entry_generator_socnet'] = $this->language->get('entry_generator_socnet');
		$this->data['entry_generator_size'] = $this->language->get('entry_generator_size');
		$this->data['entry_generator_otstup'] = $this->language->get('entry_generator_otstup');
		$this->data['entry_generator_type'] = $this->language->get('entry_generator_type');
		$this->data['entry_generator_hover'] = $this->language->get('entry_generator_hover');
		$this->data['entry_generator_kvadrat'] = $this->language->get('entry_generator_kvadrat');
		$this->data['entry_generator_hline'] = $this->language->get('entry_generator_hline');
		$this->data['entry_generator_vline'] = $this->language->get('entry_generator_vline');

		$this->data['button_generate'] = $this->language->get('button_generate');
		$this->data['entry_generator_code'] = $this->language->get('entry_generator_code');
		
		$this->data['entry_generator_view'] = $this->language->get('entry_generator_view');
		
		$this->data['error_generate_nosize'] = $this->language->get('error_generate_nosize');
		$this->data['error_generate_nosocnet'] = $this->language->get('error_generate_nosocnet');
		
		$this->data['text_help'] = $this->language->get('text_help');
		
		$this->data['tab_help'] = $this->language->get('tab_help');
		$this->data['tab_general'] = $this->language->get('tab_general');
		$this->data['tab_facebook'] = $this->language->get('tab_facebook');
		$this->data['tab_vkontakte'] = $this->language->get('tab_vkontakte');
		$this->data['tab_twitter'] = $this->language->get('tab_twitter');
		$this->data['tab_odnoklassniki'] = $this->language->get('tab_odnoklassniki');
		
		$this->data['text_popup_notice'] = $this->language->get('text_popup_notice');
		
		$this->data['button_save_go'] = $this->language->get('button_save_go');
		$this->data['button_save_stay'] = $this->language->get('button_save_stay');
		$this->data['button_cancel'] = $this->language->get('button_cancel');
		
		//============================================
		
 		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		
		if (isset($this->error['image'])) {
			$this->data['error_image'] = $this->error['image'];
		} else {
			$this->data['error_image'] = array();
		}
		
  		$this->data['breadcrumbs'] = array();

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/home', 'token=' . $this->session->data['token'], 'SSL'),       		
      		'separator' => false
   		);

   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_module'),
			'href'      => $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => ' :: '
   		);
		
   		$this->data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title'),
			'href'      => $this->url->link('module/socnetauth', 'token=' . $this->session->data['token'], 'SSL'),
      		'separator' => ' :: '
   		);
		
		$this->data['action'] = $this->url->link('module/socnetauth', 'token=' . $this->session->data['token'], 'SSL');
		
		$this->data['cancel'] = $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL');
		
		
		$this->data['socnetauth_module'] = array();
		
		if (isset($this->request->post['socnetauth_module'])) {
			$this->data['socnetauth_module'] = $this->request->post['socnetauth_module'];
		} elseif ($this->config->get('socnetauth_module')) { 
			$this->data['socnetauth_module'] = $this->config->get('socnetauth_module');
		}
		
		$this->load->model('design/layout');
		
		$this->data['layouts'] = $this->model_design_layout->getLayouts();

		
		//========================================
		
		if (isset($this->request->post['socnetauth_status'])) {
			$this->data['socnetauth_status'] = $this->request->post['socnetauth_status'];
		} elseif ($this->config->get('socnetauth_status')) { 
			$this->data['socnetauth_status'] = $this->config->get('socnetauth_status');
		} else {
			$this->data['socnetauth_status'] = '';
		}
		
		if (isset($this->request->post['socnetauth_vkontakte_status'])) {
			$this->data['socnetauth_vkontakte_status'] = $this->request->post['socnetauth_vkontakte_status'];
		} elseif ($this->config->get('socnetauth_vkontakte_status')) { 
			$this->data['socnetauth_vkontakte_status'] = $this->config->get('socnetauth_vkontakte_status');
		} else {
			$this->data['socnetauth_vkontakte_status'] = '';
		}
		
		if (isset($this->request->post['socnetauth_facebook_status'])) {
			$this->data['socnetauth_facebook_status'] = $this->request->post['socnetauth_facebook_status'];
		} elseif ($this->config->get('socnetauth_facebook_status')) { 
			$this->data['socnetauth_facebook_status'] = $this->config->get('socnetauth_facebook_status');
		} else {
			$this->data['socnetauth_facebook_status'] = '';
		}
		
		if (isset($this->request->post['socnetauth_twitter_status'])) {
			$this->data['socnetauth_twitter_status'] = $this->request->post['socnetauth_twitter_status'];
		} elseif ($this->config->get('socnetauth_twitter_status')) { 
			$this->data['socnetauth_twitter_status'] = $this->config->get('socnetauth_twitter_status');
		} else {
			$this->data['socnetauth_twitter_status'] = '';
		}
		
		if (isset($this->request->post['socnetauth_odnoklassniki_status'])) {
			$this->data['socnetauth_odnoklassniki_status'] = $this->request->post['socnetauth_odnoklassniki_status'];
		} elseif ($this->config->get('socnetauth_odnoklassniki_status')) { 
			$this->data['socnetauth_odnoklassniki_status'] = $this->config->get('socnetauth_odnoklassniki_status');
		} else {
			$this->data['socnetauth_odnoklassniki_status'] = '';
		}
		
		if (isset($this->request->post['socnetauth_facebook_appid'])) {
			$this->data['socnetauth_facebook_appid'] = $this->request->post['socnetauth_facebook_appid'];
		} elseif ($this->config->get('socnetauth_facebook_appid')) { 
			$this->data['socnetauth_facebook_appid'] = $this->config->get('socnetauth_facebook_appid');
		} else {
			$this->data['socnetauth_facebook_appid'] = '';
		}
		
		if (isset($this->request->post['socnetauth_facebook_appid'])) {
			$this->data['socnetauth_facebook_appid'] = $this->request->post['socnetauth_facebook_appid'];
		} elseif ($this->config->get('socnetauth_facebook_appid')) { 
			$this->data['socnetauth_facebook_appid'] = $this->config->get('socnetauth_facebook_appid');
		} else {
			$this->data['socnetauth_facebook_appid'] = '';
		}
		
		if (isset($this->request->post['socnetauth_facebook_appsecret'])) {
			$this->data['socnetauth_facebook_appsecret'] = $this->request->post['socnetauth_facebook_appsecret'];
		} elseif ($this->config->get('socnetauth_facebook_appsecret')) { 
			$this->data['socnetauth_facebook_appsecret'] = $this->config->get('socnetauth_facebook_appsecret');
		} else {
			$this->data['socnetauth_facebook_appsecret'] = '';
		}
		
		//-------
		
		if (isset($this->request->post['socnetauth_twitter_consumer_key'])) {
			$this->data['socnetauth_twitter_consumer_key'] = $this->request->post['socnetauth_twitter_consumer_key'];
		} elseif ($this->config->get('socnetauth_twitter_consumer_key')) { 
			$this->data['socnetauth_twitter_consumer_key'] = $this->config->get('socnetauth_twitter_consumer_key');
		} else {
			$this->data['socnetauth_twitter_consumer_key'] = '';
		}
		
		if (isset($this->request->post['socnetauth_twitter_consumer_secret'])) {
			$this->data['socnetauth_twitter_consumer_secret'] = $this->request->post['socnetauth_twitter_consumer_secret'];
		} elseif ($this->config->get('socnetauth_twitter_consumer_secret')) { 
			$this->data['socnetauth_twitter_consumer_secret'] = $this->config->get('socnetauth_twitter_consumer_secret');
		} else {
			$this->data['socnetauth_twitter_consumer_secret'] = '';
		}
		
		//-------
		
		if (isset($this->request->post['socnetauth_vkontakte_appid'])) {
			$this->data['socnetauth_vkontakte_appid'] = $this->request->post['socnetauth_vkontakte_appid'];
		} elseif ($this->config->get('socnetauth_vkontakte_appid')) { 
			$this->data['socnetauth_vkontakte_appid'] = $this->config->get('socnetauth_vkontakte_appid');
		} else {
			$this->data['socnetauth_vkontakte_appid'] = '';
		}
		
		if (isset($this->request->post['socnetauth_vkontakte_appsecret'])) {
			$this->data['socnetauth_vkontakte_appsecret'] = $this->request->post['socnetauth_vkontakte_appsecret'];
		} elseif ($this->config->get('socnetauth_vkontakte_appsecret')) { 
			$this->data['socnetauth_vkontakte_appsecret'] = $this->config->get('socnetauth_vkontakte_appsecret');
		} else {
			$this->data['socnetauth_vkontakte_appsecret'] = '';
		}
		
		//--------
		
		if (isset($this->request->post['socnetauth_odnoklassniki_application_id'])) {
			$this->data['socnetauth_odnoklassniki_application_id'] = $this->request->post['socnetauth_odnoklassniki_application_id'];
		} elseif ($this->config->get('socnetauth_odnoklassniki_application_id')) { 
			$this->data['socnetauth_odnoklassniki_application_id'] = $this->config->get('socnetauth_odnoklassniki_application_id');
		} else {
			$this->data['socnetauth_odnoklassniki_application_id'] = '';
		}
		
		if (isset($this->request->post['socnetauth_odnoklassniki_public_key'])) {
			$this->data['socnetauth_odnoklassniki_public_key'] = $this->request->post['socnetauth_odnoklassniki_public_key'];
		} elseif ($this->config->get('socnetauth_odnoklassniki_public_key')) { 
			$this->data['socnetauth_odnoklassniki_public_key'] = $this->config->get('socnetauth_odnoklassniki_public_key');
		} else {
			$this->data['socnetauth_odnoklassniki_public_key'] = '';
		}
		
		if (isset($this->request->post['socnetauth_odnoklassniki_secret_key'])) {
			$this->data['socnetauth_odnoklassniki_secret_key'] = $this->request->post['socnetauth_odnoklassniki_secret_key'];
		} elseif ($this->config->get('socnetauth_odnoklassniki_secret_key')) { 
			$this->data['socnetauth_odnoklassniki_secret_key'] = $this->config->get('socnetauth_odnoklassniki_secret_key');
		} else {
			$this->data['socnetauth_odnoklassniki_secret_key'] = '';
		}
		
		//========================================		
		
		$this->template = 'module/socnetauth.tpl';
		$this->children = array(
			'common/header',
			'common/footer'
		);
				
		$this->response->setOutput($this->render());
	}
	
	private function validate() {
		if (!$this->user->hasPermission('modify', 'module/socnetauth')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
		if( !empty( $this->request->post['socnetauth_vkontakte_appid'] ) )
		{
			$this->request->post['socnetauth_vkontakte_appid'] = trim($this->request->post['socnetauth_vkontakte_appid']);
		}
		
		if( !empty( $this->request->post['socnetauth_vkontakte_appsecret'] ) )
		{
			$this->request->post['socnetauth_vkontakte_appsecret'] = trim($this->request->post['socnetauth_vkontakte_appsecret']);
		}
		
		if( !empty( $this->request->post['socnetauth_facebook_appid'] ) )
		{
			$this->request->post['socnetauth_facebook_appid'] = trim($this->request->post['socnetauth_facebook_appid']);
		}
		
		if( !empty( $this->request->post['socnetauth_facebook_appsecret'] ) )
		{
			$this->request->post['socnetauth_facebook_appsecret'] = trim($this->request->post['socnetauth_facebook_appsecret']);
		}
		
		if( !empty( $this->request->post['socnetauth_twitter_consumer_key'] ) )
		{
			$this->request->post['socnetauth_twitter_consumer_key'] = trim($this->request->post['socnetauth_twitter_consumer_key']);
		}
		
		if( !empty( $this->request->post['socnetauth_twitter_consumer_secret'] ) )
		{
			$this->request->post['socnetauth_twitter_consumer_secret'] = trim($this->request->post['socnetauth_twitter_consumer_secret']);
		}
		
		if( !empty( $this->request->post['socnetauth_odnoklassniki_application_id'] ) )
		{
			$this->request->post['socnetauth_odnoklassniki_application_id'] = trim($this->request->post['socnetauth_odnoklassniki_application_id']);
		}
		
		if( !empty( $this->request->post['socnetauth_odnoklassniki_public_key'] ) )
		{
			$this->request->post['socnetauth_odnoklassniki_public_key'] = trim($this->request->post['socnetauth_odnoklassniki_public_key']);
		}
		
		if( !empty( $this->request->post['socnetauth_odnoklassniki_secret_key'] ) )
		{
			$this->request->post['socnetauth_odnoklassniki_secret_key'] = trim($this->request->post['socnetauth_odnoklassniki_secret_key']);
		}
		
		
		if( !empty( $this->request->post['socnetauth_module'] ) )
		{
			$this->request->post['socnetauth_module'] = $this->request->post['socnetauth_module'];
		}
		else
		{
			$this->request->post['socnetauth_module'] = '';
		}
		
		if (!$this->error) {
			return true;
		} else {
			return false;
		}	
	}
}
?>