<?
require_once('../config.php');
require_once('lib/db.php');
require_once('lib/socnetauth.php');
session_start();

$SocAuth = new SocAuth();

if( !$SocAuth->get_config_param('socnetauth_status') )
{
	header("Location: ".$_SERVER['HTTP_REFERER']);
	exit();
}



$IS_DEBUG = 0;

if( !empty($_GET['first']) )
{
	$APPLICATION_ID = $SocAuth->get_config_param('socnetauth_odnoklassniki_application_id');
	$REDIRECT_URI = 'http://'.$_SERVER['HTTP_HOST'].'/socnetauth/odnoklassniki.php';
	$CURRENT_URI = $_SERVER['HTTP_REFERER'];
		
	$STATE = 'odnoklassniki_socnetauth_'.rand();
	$SocAuth->setRecord($STATE, $CURRENT_URI);
		
	setcookie("od_state", $STATE);
		
	$url = 'http://www.odnoklassniki.ru/oauth/authorize?client_id='.
	$APPLICATION_ID.'&response_type=code&redirect_uri='.$REDIRECT_URI;
	
	header("Location: ".$url);
}



if( !empty( $_GET['code'] ) && !empty( $_COOKIE['od_state'] ) &&
	$recordData = $SocAuth->getRecord( $_COOKIE['od_state'] ) )
{
	$CODE = $_GET['code'];
	
	$CURRENT_URI = $recordData['redirect'];
	$REDIRECT_URI = 'http://'.$_SERVER['HTTP_HOST'].'/socnetauth/odnoklassniki.php';
	$CLIENT_ID = $SocAuth->get_config_param('socnetauth_odnoklassniki_application_id');
	$CLIENT_SECRET = $SocAuth->get_config_param('socnetauth_odnoklassniki_secret_key');
	$CLIENT_PUBLIC = $SocAuth->get_config_param('socnetauth_odnoklassniki_public_key');
	
	//code={code}&redirect_uri=http://mysite.com/oklogin&grant_type=authorization_code&client_id={client_id}&client_secret={secret_key}
	
	$POSTURL  = 'http://api.odnoklassniki.ru/oauth/token.do';
	$POSTVARS = 'code='.$CODE.'&redirect_uri='.$REDIRECT_URI.'&grant_type=authorization_code'.
	'&client_id='.$CLIENT_ID.'&client_secret='.$CLIENT_SECRET;
	
	$ch = curl_init($POSTURL);
	curl_setopt($ch, CURLOPT_POST      ,1);
	curl_setopt($ch, CURLOPT_POSTFIELDS    , $POSTVARS);
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION  ,1);
	curl_setopt($ch, CURLOPT_HEADER      ,0);  // DO NOT RETURN HTTP HEADERS
	curl_setopt($ch, CURLOPT_RETURNTRANSFER  ,1);  // RETURN THE CONTENTS OF THE CALL
	$response = curl_exec($ch);
	curl_close($ch);
 
	if( $IS_DEBUG ) echo $response."<hr>";
	
	$data = json_decode($response, true);
	
	if( !empty($data['access_token']) )
	{
		$SIGN = md5('application_key='.$CLIENT_PUBLIC.'method=users.getCurrentUser'.md5($data['access_token'].$CLIENT_SECRET));
		
		$graph_url = "http://api.odnoklassniki.ru/fb.do?method=users.getCurrentUser".
		"&access_token=".$data['access_token'].
		"&application_key=".$CLIENT_PUBLIC.
		"&sig=".$SIGN;
		
		if( $IS_DEBUG ) echo $graph_url."<hr>";
		
		if( extension_loaded('curl') )
		{
			$c = curl_init($graph_url);
			curl_setopt($c, CURLOPT_RETURNTRANSFER, true);
			$json = curl_exec($c);
			curl_close($c);
		}
		else
		{
			$json = file_get_contents($graph_url);
		}
		
		if( $IS_DEBUG ) echo $json;
		
		$userdata = json_decode($json, TRUE);
		/*
			uid - user ID
			birthday - date of birth
			age - user`s age
			first_name - user`s name
			last_name - user`s last name
			name - composition of first and last name to render
			has_email - true/false has or not e-mail
			gender - gender
			pic_1 - profile small icon (50x50)
			pic_2 - profile small picture (128x128)
		*/
		
				
		if( $customer = $SocAuth->odnoklassniki_check($userdata['uid']) )
		{			
			$_SESSION['customer_id'] = $customer['customer_id'];
					
			if( $IS_DEBUG ) exit('RES1|'.$REDIRECT_URI);
					
			header("Location: ".$CURRENT_URI ); 
		}
		else
		{
			$precode = $SocAuth->odnoklassniki_preregistration($userdata);
				
			if( $IS_DEBUG ) exit('RES2');
			
			header('Location: /index.php?route=socnetauth/registration&precode='.$precode.'&redirect_uri='.urlencode($CURRENT_URI) ); 
		}
	}
}

?>