<?php

if ( !function_exists( 'optionsframework_init' ) ) {
	define( 'OPTIONS_FRAMEWORK_DIRECTORY', get_template_directory_uri() . '/theme_options/' );
	require_once dirname( __FILE__ ) . '/theme_options/options-framework.php';
}
load_theme_textdomain('options_framework_theme', get_template_directory() . '/theme_options/languages');

$tempdir = get_template_directory();
require_once($tempdir .'/inc/functions/shortcodes.php');

if ( !function_exists( 'lt_theme_setup' ) ) {
  function lt_theme_setup(){
    
	/* Включение поддержки миниатюр */ 
	add_theme_support( 'post-thumbnails' );
	set_post_thumbnail_size( 170, 150, true );
	add_image_size( 'slider-thumbnail', 850, 350, true );
	add_image_size( 'post-widget-thumbnail', 80, 80, true );	
    
	/* Произвольное меню */  
    register_nav_menu( 'top', 'Верхнее меню' );
    
	/* Удаление стилей галереи */
	add_filter( 'use_default_gallery_style', '__return_false' );
	
  }
}
add_action('after_setup_theme', 'lt_theme_setup');

/*------------------------------------------------------------------------------*/
/*	Галерея WordPress
/*------------------------------------------------------------------------------*/

/* Добавление класса */
function add_class_img_gallery($link) {
  global $post;
  return str_replace('<a href', '<a class="prettyPhoto" href', $link);
}
add_filter('wp_get_attachment_link', 'add_class_img_gallery');

/*------------------------------------------------------------------------------*/
/*	Ширина основного контента (изображения, видео)
/*------------------------------------------------------------------------------*/

if ( ! isset( $content_width ) )
	$content_width = 850;

/*------------------------------------------------------------------------------*/
/*	Загрузка скриптов и стилей
/*------------------------------------------------------------------------------*/

function lt_load_scripts_styles(){ 
	if ( is_home() ){
	  if (of_get_option('slider_on') == '1') 
	  wp_enqueue_script('flexslider', get_template_directory_uri() . '/js/jquery.flexslider-min.js', array('jquery'), '2.1');
	}   
	if ( is_singular() ) {
      if (of_get_option('lightbox') == '1') {
	  wp_enqueue_script('pretty-photo', get_template_directory_uri() . '/js/pretty_photo/jquery.prettyPhoto.js', array('jquery'), '3.1.5');
      wp_enqueue_style('pretty_photo_style', get_template_directory_uri() . '/js/pretty_photo/prettyPhoto.css' , '', '1.0', 'all');	
      } 
	  wp_enqueue_script('fitvids', get_template_directory_uri() . '/js/jquery.fitvids.js', array('jquery'), '1.0');
	}
	wp_enqueue_script('jquery-tools', get_template_directory_uri() . '/js/jquery.tools.min.js', array('jquery'), '1.2.7');
	wp_enqueue_script('script-lt', get_template_directory_uri() . '/js/script.js', array('jquery'), '1.0');
	
	if ( is_single() && comments_open() && get_option( 'thread_comments' ) ){ 
	  wp_enqueue_script( 'comment-reply' );
	}

	wp_enqueue_style('adapt-style', get_stylesheet_uri(), '', '1.2', 'all');
}
add_action( 'wp_enqueue_scripts', 'lt_load_scripts_styles' );

/*------------------------------------------------------------------------------*/
/*	Использование шорткода в виджете
/*------------------------------------------------------------------------------*/

add_filter('widget_text', 'do_shortcode');

/*------------------------------------------------------------------------------*/
/*	Удаление версии WordPress
/*------------------------------------------------------------------------------*/

remove_action('wp_head', 'wp_generator' );

/*------------------------------------------------------------------------------*/
/*	Удаление rel, title c ссылок категорий в записях
/*------------------------------------------------------------------------------*/

function lt_the_category( $result ) {
  $result = preg_replace('/title=\"(.*?)\"/', '', $result);
  $result = str_replace('rel="category tag"', '', $result);
  return $result;
}
add_filter('the_category', 'lt_the_category');

/*------------------------------------------------------------------------------*/
/*	Сокращение слов в записи
/*------------------------------------------------------------------------------*/

if ( !function_exists( 'lt_excerpt_length' ) ) {
  function lt_excerpt_length( $length ) {
    $excerpt_opt = of_get_option('excerpt_options');
    return $excerpt_opt;
  }
}
add_filter( 'excerpt_length', 'lt_excerpt_length', 999 );

if ( !function_exists( 'lt_excerpt_more' ) ) {
  function lt_excerpt_more( $excerpt ) {
	return str_replace( '[&hellip;]', '&hellip;', $excerpt );
  }
}  
add_filter( 'wp_trim_excerpt', 'lt_excerpt_more' );

/*------------------------------------------------------------------------------*/
/*	Заголовок (title) в <head>
/*------------------------------------------------------------------------------*/

if ( !function_exists( 'cp_wp_title' ) ) {
 function cp_wp_title( $title ) {
  global $wp_locale, $paged, $page;
  
    if ( is_feed() )
	  return $title;
	
	$m = get_query_var('m');
	$year = get_query_var('year');
	$monthnum = get_query_var('monthnum');
	$day = get_query_var('day');
	$search = get_query_var('s');	
	$t_sep = ' | ';

    // Front page
    if ( is_home() || is_front_page() )
	  $title = get_bloginfo( 'name' );
		
	// If there is a post
	if ( is_single() || ( is_home() && !is_front_page() ) || ( is_page() && !is_front_page() ) ) {
	  $title = single_post_title( '', false );
	}

	// If there's a category or tag
	if ( is_category() || is_tag() ) {
	  $title = single_term_title( '', false );
	}

	// If there's a taxonomy
	if ( is_tax() ) {
	  $term = get_queried_object();
	  $tax = get_taxonomy( $term->taxonomy );
	  $title = single_term_title( $tax->labels->name . $t_sep, false );
	}

	// If there's an author
	if ( is_author() ) {
      $author = get_queried_object();
	  $title = $author->display_name;
	}

	// If there's a post type archive
	if ( is_post_type_archive() )
	  $title = post_type_archive_title( '', false );	

	// If there's a month
	if ( is_archive() && !empty($m) ) {
		$my_year = substr($m, 0, 4);
		$my_month = $wp_locale->get_month(substr($m, 4, 2));
		$my_day = intval(substr($m, 6, 2));
		$title = $my_year . ( $my_month ? $t_sep . $my_month : '' ) . ( $my_day ? $t_sep . $my_day : '' );
	}

	// If there's a year
	if ( is_archive() && !empty($year) ) {
		$title = $year;
		if ( !empty($monthnum) )
			$title .= $t_sep . $wp_locale->get_month($monthnum);
		if ( !empty($day) )
			$title .= $t_sep . zeroise($day, 2);
	}	  
	  
	// If it's a search strip_tags
	if ( is_search() ) {
	  /* translators: 1: separator, 2: search phrase */
	  $title = sprintf(__('Search Results %1$s %2$s'), '|', strip_tags($search));
	}	  

	// If it's a 404 page
	if ( is_404() ) {
	  $title = __('Page not found');
	}		  

    // Add a page number if necessary
    if ( $paged >= 2 || $page >= 2 )
	  $title = "$title" . sprintf( __( ' | Страница %s' ), max( $paged, $page ) );

    return $title;
 }
}
add_filter( 'wp_title', 'cp_wp_title', 10, 2 );

/*------------------------------------------------------------------------------*/
/*	Постраничная навигация
/*------------------------------------------------------------------------------*/

if ( !function_exists( 'lt_pagination' ) ) {
  function lt_pagination() {
    global $wp_query;
    $big = 999999999;
    echo paginate_links( array(
	 'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
	 'format' => '?paged=%#%',
	 'current' => max( 1, get_query_var('paged') ),
	 'total' => $wp_query->max_num_pages,
	 'prev_text' => '« Предыдущая',
	 'next_text' => 'Следующая »'
    ));
  }
}

/*------------------------------------------------------------------------------*/
/*	Типы записей
/*------------------------------------------------------------------------------*/

function lt_create_post_types() {
    $labels_slider = array(
        'name' => 'Слайдер',
        'singular_name' => 'Слайдер',
        'add_new' => 'Добавить слайд',
        'add_new_item' => 'Добавить слайд',
        'edit' => 'Редактировать',
        'edit_item' => 'Редактировать',
    );
	$args_slider = array(
		'labels' => $labels_slider,
        'public' => true,
        'query_var' => true,
		'rewrite' => true,
        'menu_position' => 8,
		'show_in_nav_menus' => false,
        'supports' => array('title', 'thumbnail')
	); 
	register_post_type( 'slider', $args_slider );	  
}
add_action('init', 'lt_create_post_types');

/*------------------------------------------------------------------------------*/
/*	Мета поля - Слайдер
/*------------------------------------------------------------------------------*/

function lt_slider_meta_box() {
  add_meta_box( 'example_meta', 'Ссылка на веб-страницу', 'lt_slider_meta_callback', 'slider', 'normal', 'high' );
}
add_action( 'add_meta_boxes', 'lt_slider_meta_box' );


function lt_slider_meta_callback( $post ) {
  wp_nonce_field( basename( __FILE__ ), 'lt_slider_nonce' );
  $lt_slider_stored_meta = get_post_meta( $post->ID );
?>
 
  <p>
    <input type="text" name="lt-slider-link-url" id="lt-slider-link-url" value="<?php echo $lt_slider_stored_meta['lt-slider-link-url'][0]; ?>" style="width: 100%;" />
  </p> 
  
<?php
}

function lt_slider_meta_save( $post_id ) {
  $is_autosave = wp_is_post_autosave( $post_id );
  $is_revision = wp_is_post_revision( $post_id );
  $is_valid_nonce = ( isset( $_POST[ 'lt_slider_nonce' ] ) && wp_verify_nonce( $_POST[ 'lt_slider_nonce' ], basename( __FILE__ ) ) ) ? 'true' : 'false';
 
  if ( $is_autosave || $is_revision || !$is_valid_nonce ) {
    return;
  }
 
  if( isset( $_POST[ 'lt-slider-link-url' ] ) ) {
    update_post_meta( $post_id, 'lt-slider-link-url', sanitize_text_field( $_POST[ 'lt-slider-link-url' ] ) );
  }
 
}
add_action( 'save_post', 'lt_slider_meta_save' );

/*------------------------------------------------------------------------------*/
/*	Комментарии
/*------------------------------------------------------------------------------*/

function lt_comment($comment, $args, $depth) {  
    $GLOBALS['comment'] = $comment; ?>
	<li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">
	  <div id="comment-<?php comment_ID(); ?>" class="comment">
	    <?php echo get_avatar($comment,$size='60'); ?>
		<div class="comment-author vcard">
		  <?php printf(__('<span class="fn">%s</span>'), get_comment_author_link()) ?>
		</div>
		<div class="comment-meta">
		  <?php printf(__('%1$s в %2$s &ndash; '), get_comment_date(),  get_comment_time()) ?>
		  <?php comment_reply_link( array_merge( $args, array( 'reply_text' => 'Ответить', 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>
          <?php edit_comment_link(__('(Edit)'),' &ndash; ','') ?>
		</div>
		<?php if ( $comment->comment_approved == '0' ) : ?>
		  <p class="comment-awaiting-moderation">Ваш комментарий ожидает модерации.</p>
		<?php endif; ?>
		<div class="comment-content">
		  <?php comment_text(); ?>
		</div>
	  </div>
  <?php 
}

function lt_list_pings($comment, $args, $depth) {
    $GLOBALS['comment'] = $comment; ?>
    <li id="comment-<?php comment_ID(); ?>"><?php comment_author_link(); ?>
<?php 
}

/*------------------------------------------------------------------------------*/
/*	Позиции для виджетов
/*------------------------------------------------------------------------------*/

function lt_sidebars_init() { 
	register_sidebar(array(
        'name' => 'Боковая колонка - Главная страница',
		'id' => 'home-sidebar',
		'description' => 'Отображается на главной странице. Расположение справа или слева в зависимости от настроек темы.',
        'before_widget' => '<div class="wg-s %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<div class="wg-s-t">',
        'after_title' => '</div>',
    ));
	register_sidebar(array(
        'name' => 'Верхняя область - Главная страница',
		'id' => 'top-home',
		'description' => 'Отображается на главной странице. Расположение в верхней области страницы.',
        'before_widget' => '<div class="wg-pr %2$s">',
        'after_widget' => '<div class="clear"></div></div>',
        'before_title' => '<div class="wg-pr-t">',
        'after_title' => '</div>',
    ));
	register_sidebar(array(
        'name' => 'Нижняя область - Главная страница',
		'id' => 'bottom-home',
		'description' => 'Отображается на главной странице. Расположение в нижней области страницы.',
        'before_widget' => '<div class="wg-pr %2$s">',
        'after_widget' => '<div class="clear"></div></div>',
        'before_title' => '<div class="wg-pr-t">',
        'after_title' => '</div>',
    ));	
	register_sidebar(array(
        'name' => 'Боковая колонка - Блог',
		'id' => 'main-sidebar',
		'description' => 'Отображается на странице рубрики, метки, архива, автора, поиска. Расположение справа или слева в зависимости от настроек темы.',
        'before_widget' => '<div class="wg-s %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<div class="wg-s-t">',
        'after_title' => '</div>',
    ));
	register_sidebar(array(
        'name' => 'Верхняя область - Блог',
		'id' => 'top',
		'description' => 'Отображается на странице рубрики, метки, архива, автора, поиска. Расположение в верхней области страницы.',        
		'before_widget' => '<div class="wg-pr %2$s">',
        'after_widget' => '<div class="clear"></div></div>',
        'before_title' => '<div class="wg-pr-t">',
        'after_title' => '</div>',
    ));	
	register_sidebar(array(
        'name' => 'Нижняя область - Блог',
		'id' => 'bottom',
		'description' => 'Отображается на странице рубрики, метки, архива, автора, поиска. Расположение в нижней области страницы.',    
        'before_widget' => '<div class="wg-pr %2$s">',
        'after_widget' => '<div class="clear"></div></div>',
        'before_title' => '<div class="wg-pr-t">',
        'after_title' => '</div>',
    ));
	register_sidebar(array(
        'name' => 'Боковая колонка - Запись блога',
		'id' => 'entry-sidebar',
		'description' => 'Отображается в записи блога. Расположение справа или слева в зависимости от настроек темы.',
        'before_widget' => '<div class="wg-s %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<div class="wg-s-t">',
        'after_title' => '</div>',
    ));	
	register_sidebar(array(
        'name' => 'Верхняя область - Запись блога',
		'id' => 'top-entry',
		'description' => 'Отображается в записи блога. Расположение в верхней области страницы.',  		
        'before_widget' => '<div class="wg-pr %2$s">',
        'after_widget' => '<div class="clear"></div></div>',
        'before_title' => '<div class="wg-pr-t">',
        'after_title' => '</div>',
    ));	
	register_sidebar(array(
        'name' => 'Нижняя область - Запись блога',
		'id' => 'bottom-entry',
		'description' => 'Отображается в записи блога. Расположение в нижней области страницы.', 
        'before_widget' => '<div class="wg-pr %2$s">',
        'after_widget' => '<div class="clear"></div></div>',
        'before_title' => '<div class="wg-pr-t">',
        'after_title' => '</div>',
    ));
	register_sidebar(array(
        'name' => 'Боковая колонка - Страница',
		'id' => 'page-sidebar',
		'description' => 'Отображается на странице. Расположение справа или слева в зависимости от настроек темы.',		
        'before_widget' => '<div class="wg-s %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<div class="wg-s-t">',
        'after_title' => '</div>',
    ));	
	register_sidebar(array(
        'name' => 'Верхняя область - Страница',
		'id' => 'top-page',
		'description' => 'Отображается на странице. Расположение в верхней области страницы.',  			
        'before_widget' => '<div class="wg-pr %2$s">',
        'after_widget' => '<div class="clear"></div></div>',
        'before_title' => '<div class="wg-pr-t">',
        'after_title' => '</div>',
    ));	
	register_sidebar(array(
        'name' => 'Нижняя область - Страница',
		'id' => 'bottom-page',
        'description' => 'Отображается на странице. Расположение в нижней области страницы.', 		
        'before_widget' => '<div class="wg-pr %2$s">',
        'after_widget' => '<div class="clear"></div></div>',
        'before_title' => '<div class="wg-pr-t">',
        'after_title' => '</div>',
    ));	
	register_sidebar(array(
        'name' => 'Нижняя левая колонка',
		'id' => 'bottom-left',
        'description' => 'Отображается на всех страницах. Расположение в нижней области страницы слева.', 		
        'before_widget' => '<div class="wg-b-l %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<div class="wg-b-t">',
        'after_title' => '</div>',
    ));
	register_sidebar(array(
        'name' => 'Нижняя центральная колонка',
        'description' => 'Отображается на всех страницах. Расположение в нижней области страницы по центру.', 
		'id' => 'bottom-center',
        'before_widget' => '<div class="wg-b-c %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<div class="wg-b-t">',
        'after_title' => '</div>',
    ));	
	register_sidebar(array(
        'name' => 'Нижняя правая колонка',
		'id' => 'bottom-right',
        'description' => 'Отображается на всех страницах. Расположение в нижней области страницы справа.',         
		'before_widget' => '<div class="wg-b-r %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<div class="wg-b-t">',
        'after_title' => '</div>',
    ));	
	register_sidebar(array(
        'name' => 'Нижняя область - Подвал',
		'id' => 'footer',
        'description' => 'Отображается на всех страницах. Расположение в самой нижней области страницы. Предназначена для счетчиков, копирайта и т.д.', 		
        'before_widget' => '<div class="wg-f %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<div class="wg-f-t">',
        'after_title' => '</div>',
    ));
}
add_action( 'widgets_init', 'lt_sidebars_init' );

/*------------------------------------------------------------------------------*/
/*	Виджеты
/*------------------------------------------------------------------------------*/

/* 
*  Виджет WordPress "Облако меток" 
*  Изменение размера текста max и min
*/

function lt_widget_tag_cloud_args( $args ) {
  $args['largest'] = 18;
  $args['smallest'] = 14;
  $args['unit'] = 'px';
  return $args;
}
add_filter( 'widget_tag_cloud_args', 'lt_widget_tag_cloud_args' );

/* 
*  Виджет WordPress "Рубрики" 
*  Удаление атрибута title
*  Изменение счетчика записей
*/

function lt_list_categories( $output ) {
  $output = preg_replace('/title=\"(.*?)\"/', '', $output);
  $output = str_replace('(', '<span class="cat-count"> ', $output);
  $output = str_replace(')', ' </span>', $output);
  return $output;
}
add_filter('wp_list_categories','lt_list_categories');

/* Подключение виджетов Livethemes */

$incdirwg = get_template_directory() . '/inc/widgets/';
require_once($incdirwg .'posts-lt.php');
require_once($incdirwg .'text-lt.php');

?>