<!DOCTYPE html>
<!-- Design by LiveThemes (http://livethemes.ru/) -->
<!--[if IE 7 ]><html class="ie7" <?php language_attributes();?>><![endif]-->
<!--[if IE 8 ]><html class="ie8" <?php language_attributes();?>><![endif]-->
<!--[if IE 9 ]><html class="ie9" <?php language_attributes();?>><![endif]-->
<!--[if (gt IE 9)|!(IE)]><!--><html <?php language_attributes();?>><!--<![endif]-->
<head>
<meta charset="<?php bloginfo('charset'); ?>">	
<meta name="viewport" content="width=device-width">
<title><?php wp_title(); ?></title>
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
<?php if (of_get_option('favicon') != '') { ?>
<link rel="shortcut icon" href="<?php echo of_get_option('favicon'); ?>" type="image/x-icon">
<?php } else { ?>
<link rel="shortcut icon" href="<?php echo get_template_directory_uri(); ?>/images/favicon.png" type="image/x-icon">   
<?php } ?> 
<!--[if lt IE 9]>
  <script src="<?php echo get_template_directory_uri(); ?>/js/html5shiv.js" type="text/javascript"></script>
<![endif]-->
<?php wp_head(); ?>
<style type="text/css">
  body { background: <?php echo of_get_option('bg_color_body'); ?><?php if (of_get_option('bg_image_body_on') =='1') { ?><?php if (of_get_option('bg_image_body_full') == '') { ?> url(<?php if (of_get_option('bg_image_body_my') == ''){ ?><?php echo get_template_directory_uri(); ?>/images/bg.png<?php } else {  ?><?php echo of_get_option('bg_image_body_my'); ?><?php }?>) top <?php echo of_get_option('bg_image_body_position'); ?> <?php echo of_get_option('bg_image_body_repeat'); ?><?php }?><?php }?>; }
  a { color: <?php echo of_get_option('link_color'); ?>; }
  a:hover { color: <?php echo of_get_option('link_color_hover'); ?>; }
  h1, h2, h3, h4, h5, h6, #comments-title { color: <?php echo of_get_option('text_color_heading'); ?>; }
  h1.entry-title { color: <?php echo of_get_option('color_e_t'); ?>; font-size: <?php echo of_get_option('font_size_e_t_2'); ?>px; font-weight: <?php echo of_get_option('font_weight_e_t_2'); ?>; }
  h2.entry-title, h2.entry-title a, .p-cat { color: <?php echo of_get_option('link_color_e_t'); ?>; font-size: <?php echo of_get_option('font_size_e_t'); ?>px; font-weight: <?php echo of_get_option('font_weight_e_t'); ?>; }
  h2.entry-title a:hover { color: <?php echo of_get_option('link_color_hover_e_t'); ?>; }
  .p-cat, .p-cat a { color: <?php echo of_get_option('link_color_cat'); ?>; }
  .p-cat a:hover { color: <?php echo of_get_option('link_color_hover_cat'); ?>; }
  #header { background: <?php echo of_get_option('bg_h'); ?><?php if (of_get_option('bg_image_h') !='') { ?> url(<?php echo of_get_option('bg_image_h'); ?>) top <?php echo of_get_option('bg_image_h_position'); ?> <?php echo of_get_option('bg_image_h_repeat'); ?><?php }?>; box-shadow: <?php echo of_get_option('h_shadow_size'); ?>px <?php echo of_get_option('h_shadow_size'); ?>px <?php echo of_get_option('h_shadow_size'); ?>px <?php echo of_get_option('h_shadow_color'); ?>; }
  #primary, #respond input, #respond textarea { color: <?php echo of_get_option('text_color'); ?>; font-size: <?php echo of_get_option('font_size'); ?>px; }
  #primary .wg-pr-t, #primary .title-text-wg { color: <?php echo of_get_option('text_color_wg_pr_t'); ?>; font-size: <?php echo of_get_option('font_size_wg_pr_t'); ?>px; font-weight: <?php echo of_get_option('font_weight_wg_pr_t'); ?>; }  
  #slider, .wg-pr, .meta-desc, .page-nav .page-numbers,
  .post, .type-page, .blog .post, .blog .type-page { box-shadow: <?php echo of_get_option('pr_shadow_size'); ?>px <?php echo of_get_option('pr_shadow_size'); ?>px <?php echo of_get_option('pr_shadow_size'); ?>px <?php echo of_get_option('pr_shadow_color'); ?>; }       
  .entry-details { color: <?php echo of_get_option('text_color_e_d'); ?>; font-size: <?php echo of_get_option('font_size_e_d'); ?>px; font-weight: <?php echo of_get_option('font_weight_e_d'); ?>; }
  .entry-details a { color: <?php echo of_get_option('link_color_e_d'); ?>; }
  .entry-details a:hover { color: <?php echo of_get_option('link_color_hover_e_d'); ?>; }
  .more-link a { color: <?php echo of_get_option('text_color_more_link'); ?>; font-size: <?php echo of_get_option('font_size_more_link'); ?>px; font-weight: <?php echo of_get_option('font_weight_more_link'); ?>; }  
  #sidebar { color: <?php echo of_get_option('text_color_s'); ?>; font-size: <?php echo of_get_option('font_size_s'); ?>px; }
  #sidebar a { color: <?php echo of_get_option('link_color_s'); ?>; }
  #sidebar a:hover { color: <?php echo of_get_option('link_color_hover_s'); ?>; }
  #sidebar .wg-s-t, #sidebar .title-text-wg { color: <?php echo of_get_option('text_color_wg_s_t'); ?>; font-size: <?php echo of_get_option('font_size_wg_s_t'); ?>px; font-weight: <?php echo of_get_option('font_weight_wg_s_t'); ?>; }
  .wg-s { box-shadow: <?php echo of_get_option('s_shadow_size'); ?>px <?php echo of_get_option('s_shadow_size'); ?>px <?php echo of_get_option('s_shadow_size'); ?>px <?php echo of_get_option('s_shadow_color'); ?>; }  
  .top-menu a { color: <?php echo of_get_option('link_color_top_nav'); ?>; }
  .top-menu a:hover, .top-menu li:hover a.sublist, .top-menu li.current-menu-item a { color: <?php echo of_get_option('link_color_hover_top_nav'); ?>; }
  .top-menu ul, .top-menu { background: <?php echo of_get_option('bg_top_nav_child'); ?>; }  
  .top-menu ul a { color: <?php echo of_get_option('link_color_top_nav_child'); ?>; }
  .top-menu ul a:hover, .top-menu ul li.current-menu-item a { color: <?php echo of_get_option('link_color_hover_top_nav_child'); ?>; }
  .menu a { color: <?php echo of_get_option('link_color_s_nav'); ?> !important; border: 1px solid <?php echo of_get_option('border_color_s_nav'); ?>; }
  .menu a:hover, .menu a.sublist-close, .menu li.current-menu-item > a { color: <?php echo of_get_option('link_color_hover_s_nav'); ?> !important; }
  .menu ul a { color: <?php echo of_get_option('link_color_s_nav_2'); ?> !important; }
  .menu ul a:hover, .menu ul li.current-menu-item a { color: <?php echo of_get_option('link_color_hover_s_nav_2'); ?> !important; }    
  #bottom { color: <?php echo of_get_option('text_color_b'); ?>; font-size: <?php echo of_get_option('font_size_b'); ?>px; }
  #bottom a { color: <?php echo of_get_option('link_color_b'); ?>; }
  #bottom a:hover { color: <?php echo of_get_option('link_color_hover_b'); ?>; }
  #bottom .wg-b-t, #bottom .title-text-wg { color: <?php echo of_get_option('text_color_wg_b_t'); ?>; font-size: <?php echo of_get_option('font_size_wg_b_t'); ?>px; font-weight: <?php echo of_get_option('font_weight_wg_b_t'); ?>; }
  .bottom-con { box-shadow: <?php echo of_get_option('b_shadow_size'); ?>px <?php echo of_get_option('b_shadow_size'); ?>px <?php echo of_get_option('b_shadow_size'); ?>px <?php echo of_get_option('b_shadow_color'); ?>; }  
  #footer { background: <?php echo of_get_option('bg_f'); ?>; color: <?php echo of_get_option('text_color_f'); ?>; font-size: <?php echo of_get_option('font_size_f'); ?>px; box-shadow: <?php echo of_get_option('f_shadow_size'); ?>px <?php echo of_get_option('f_shadow_size'); ?>px <?php echo of_get_option('f_shadow_size'); ?>px <?php echo of_get_option('f_shadow_color'); ?>; }
  #footer a { color: <?php echo of_get_option('link_color_f'); ?>; }
  #footer a:hover { color: <?php echo of_get_option('link_color_hover_f'); ?>; }
</style> 
</head>
<?php $s_options = of_get_option('sidebar'); ?>
<body <?php body_class($s_options); ?>>

<div id="wrap">
  <div id="header">
    <?php if (of_get_option('logo') != '') { ?>
      <div id="logo"><a href="<?php echo home_url('/'); ?>"><img src="<?php echo of_get_option('logo'); ?>" alt=""></a></div>
    <?php } elseif (of_get_option('logo_text')) { ?>
      <div id="logo-text"><a href="<?php echo home_url('/'); ?>"><?php echo of_get_option('logo_text'); ?></a></div>
    <?php } else { ?>
      <div id="logo"><a href="<?php echo home_url('/'); ?>"><img src="<?php echo get_template_directory_uri(); ?>/images/logo.png" alt=""></a></div>
    <?php } ?> 

    <?php wp_nav_menu( array(
	  'container' => 'div', 
	  'container_id' => 'top-nav',
	  'menu_class' => 'top-menu', 
	  'depth' => 0,
	  'theme_location' => 'top',
	  'fallback_cb'     => false
	 )); 
    ?>
  <div class="clear"></div>
  </div>  

  <div id="container">
  