<?php

/*---------------------------------------------------------------------
    
	Plugin Name: LT Posts Widget
    Plugin URI: http://livethemes.ru/
	Description: Вывод последних записей.
    Version: 1.0
    Author: Livethemes
    Author URI: http://livethemes.ru/  
	
---------------------------------------------------------------------*/
 
add_action( 'widgets_init', 'lt_posts_widget' );

function lt_posts_widget() {
	register_widget( 'LT_posts_wg' );
} 

/*---------------------------------------------------------------------*/
/*  Constructor
/*---------------------------------------------------------------------*/

class LT_posts_wg extends WP_Widget {

  function LT_posts_wg() {
    $widget_ops = array( 
	  'classname' => 'lt_posts_wg', 
	  'description' => 'Вывод последних записей' 
	);
	$this->WP_Widget( 'lt_posts_wg', 'Записи LT', $widget_ops );
  }
  
/*---------------------------------------------------------------------*/
/*  Widget form creation
/*---------------------------------------------------------------------*/    

  function widget($args, $instance) {		
    extract( $args );
	
    $title = apply_filters('widget_title', $instance['title'] );
	$number = esc_attr($instance['number']);
	$category_id = esc_attr($instance['category_id']);	
	$sortby = esc_attr($instance['sortby']);
	
  echo $before_widget;
  if ( $title )
    echo $before_title . $title . $after_title; 
  ?>	

<?php
/*---------------------------------------------------------------------*/
/*  Widget display
/*---------------------------------------------------------------------*/   
?>  

  <?php
    $args = array(
      'post_status' => 'publish',
      'ignore_sticky_posts' => 1,
	  'posts_per_page' => $number,
	  'cat' => $category_id,
	  'orderby' => $sortby
    );
    $LTposts = new WP_Query($args);
	while ($LTposts->have_posts()) : $LTposts->the_post(); 
  ?>   
    <div class="posts-wg"> 
	  <?php if( has_post_thumbnail() ) { ?>	
		<div class="p-thumb-wg">
		  <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail('post-widget-thumbnail'); ?></a>
		</div> 
      <?php }?> 
      <div<?php if( has_post_thumbnail() ) { ?> class="p-r-wg"<?php }?>>  
		<a class="p-title-wg" href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
		<div class="p-date-wg">
		  <?php echo get_the_date('d.m.Y'); ?>
		</div>
	  </div>
    </div>  
	<?php endwhile; ?>
	<?php wp_reset_query();?>				
    <div class="clear"></div>  

  <?php 
	echo $after_widget;
  }

/*---------------------------------------------------------------------*/
/*  Widget update
/*---------------------------------------------------------------------*/ 

  function update($new_instance, $old_instance) {				
    $instance = $old_instance;
	$instance['title'] = strip_tags($new_instance['title']);
	$instance['number'] = strip_tags( $new_instance['number'] );
	$instance['category_id'] = strip_tags( $new_instance['category_id'] );
	$instance['sortby'] = strip_tags( $new_instance['sortby'] );

	return $instance;
  }
  
/*---------------------------------------------------------------------*/
/*  Widget defaults
/*---------------------------------------------------------------------*/ 
  
  function form($instance) {				
    $defaults = array( 
	  'title' => '',
	  'number' => '5',
	  'category_id' => '',
	  'sortby' => 'date'
	);
	$instance = wp_parse_args( (array) $instance, $defaults );
  ?> 

<?php
/*---------------------------------------------------------------------*/
/*  Back-end widget form
/*---------------------------------------------------------------------*/   
?>    

  <p>
    <label style="color: #618e00;" for="<?php echo $this->get_field_id( 'title' ); ?>">Заголовок</label>
    <input class="widefat" style="margin-top: 3px;" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $instance['title']; ?>" />
  </p>

  <p>
    <label style="color: #618e00;" for="<?php echo $this->get_field_id('category_id'); ?>">Категории</label>
    <input class="widefat" style="margin-top: 3px; width:96.5%;" id="<?php echo $this->get_field_id('category_id'); ?>" name="<?php echo $this->get_field_name('category_id'); ?>" type="text" value="<?php echo $instance['category_id']; ?>" />
    <br />
    <small>ID категорий, разделённые запятыми</small>
  </p> 

  <p>
    <label style="color: #618e00;" for="<?php echo $this->get_field_id('sortby'); ?>">Фильтр</label>
    <select style="margin-top: 3px;" name="<?php echo $this->get_field_name('sortby'); ?>" id="<?php echo $this->get_field_id('sortby'); ?>" class="widefat">
	  <option value="date"<?php selected( $instance['sortby'], 'date' ); ?>>Дата добавления</option>
	  <option value="comment_count"<?php selected( $instance['sortby'], 'comment_count' ); ?>>Количество комментариев</option>
	  <option value="rand"<?php selected( $instance['sortby'], 'rand' ); ?>>Случайно</option>
    </select>
  </p>   
   
  <p>
    <label style="color: #618e00;" for="<?php echo $this->get_field_id('number'); ?>">Количество записей</label>
    <select id="<?php echo $this->get_field_id('number'); ?>" name="<?php echo $this->get_field_name('number'); ?>">
    <?php for ($i=1;$i<=20;$i++) {
      echo '<option value="'.$i.'"';
      if ($i==$instance['number']) echo ' selected="selected"';
      echo '>'.$i.'</option>';
    } ?>
    </select>
  </p>  

  <?php 
  }
}
?>