<?php

/*---------------------------------------------------------------------
    
	Plugin Name: LT Text Widget
    Plugin URI: http://livethemes.ru/
	Description: Произвольный текст или HTML-код с возможностью задавать цвет фона блока и цвет текста.
    Version: 1.0
    Author: Livethemes
    Author URI: http://livethemes.ru/  
	
---------------------------------------------------------------------*/

add_action( 'widgets_init', 'lt_text_widget' );

function lt_text_widget() {
	register_widget( 'LT_text_wg' );
} 

/*---------------------------------------------------------------------*/
/*  Constructor
/*---------------------------------------------------------------------*/

class LT_text_wg extends WP_Widget {

  function LT_text_wg() {
    $widget_ops = array( 
	  'classname' => 'lt_text_wg', 
	  'description' => 'Произвольный текст или HTML-код с возможностью задавать цвет фона блока и цвет текста' 
	);
	$control_ops = array(
	  'width' => 400, 
	  'height' => 300
	);
	$this->WP_Widget( 'lt_text_wg', 'Текст LT', $widget_ops, $control_ops );
  }

  function widget($args, $instance) {		
    extract( $args );
	
    $title = apply_filters('widget_title', $instance['title'] );
	$con_bl = apply_filters( 'widget_textarea', empty( $instance['con_bl'] ) ? '' : $instance['con_bl'], $instance );
	$color_title_bl = esc_attr($instance['color_title_bl']);
	$bg_title_bl = esc_attr($instance['bg_title_bl']);
	$color_text_bl = esc_attr($instance['color_text_bl']);
	$bg_bl = esc_attr($instance['bg_bl']);
				
  echo $before_widget;
  ?>

<?php
/*---------------------------------------------------------------------*/
/*  Widget display
/*---------------------------------------------------------------------*/   
?>   
  <div class="text-wg" style="background: #<?php echo $bg_bl; ?>; color: #<?php echo $color_text_bl; ?>;">
    <?php if (($title)!=""){ ?>
	  <div class="title-text-wg" style="background: #<?php echo $bg_title_bl; ?>; color: #<?php echo $color_title_bl; ?> !important;">
	    <?php echo $title; ?>
	  </div>
	<?php }?>
	<?php echo !empty( $instance['filter'] ) ? wpautop( $con_bl ) : $con_bl; ?>
  <div class="clear"></div>
  </div>

  <?php 
	echo $after_widget;
  }

/*---------------------------------------------------------------------*/
/*  Widget update
/*---------------------------------------------------------------------*/

  function update( $new_instance, $old_instance ) {
	$instance = $old_instance;
	$instance['title'] = strip_tags($new_instance['title']);
	$instance['color_title_bl'] = strip_tags($new_instance['color_title_bl']);
	$instance['bg_title_bl'] = strip_tags($new_instance['bg_title_bl']);
	$instance['color_text_bl'] = strip_tags($new_instance['color_text_bl']);
	$instance['bg_bl'] = strip_tags($new_instance['bg_bl']);
	if ( current_user_can('unfiltered_html') )
	  $instance['con_bl'] =  $new_instance['con_bl'];
	else
	  $instance['con_bl'] = stripslashes( wp_filter_post_kses( addslashes($new_instance['con_bl']) ) );
	$instance['filter'] = isset($new_instance['filter']);

	return $instance;
  }

/*---------------------------------------------------------------------*/
/*  Widget defaults
/*---------------------------------------------------------------------*/ 

  function form($instance) {				
    $defaults = array(
      'title' => '',
	  'color_title_bl' => 'fffffe',
	  'bg_title_bl' => 'ff7e00',
	  'color_text_bl' => 'fffffe',
	  'bg_bl' => 'ffa100',
	);
	$instance = wp_parse_args( (array) $instance, $defaults );		
    ?>
	
<?php
/*---------------------------------------------------------------------*/
/*  Back-end widget form
/*---------------------------------------------------------------------*/   
?> 	

  <div style="background: #fff; margin-bottom: 10px; padding: 10px; border: 1px solid #e1e1e1; -webkit-border-radius: 4px; -moz-border-radius: 4px; border-radius: 4px;">		
    <p>
      <label style="font-weight: bold;" for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('Title') ?></label>
      <input class="widefat" style="margin-top: 2px; background: #<?php echo $instance['bg_title_bl']; ?>; color: #<?php echo $instance['color_title_bl']; ?>; border: 0;" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $instance['title']; ?>" />
    </p>

    <p>
      <label for="<?php echo $this->get_field_id('color_title_bl'); ?>"><?php _e('Цвет текста заголовка'); ?></label>
      <input class="widefat" style="float: right; width:30%; background: #<?php echo $instance['bg_title_bl']; ?>; color: #<?php echo $instance['color_title_bl']; ?>; border: 0;" id="<?php echo $this->get_field_id('color_title_bl'); ?>" name="<?php echo $this->get_field_name('color_title_bl'); ?>" type="text" value="<?php echo $instance['color_title_bl']; ?>" />
    </p>

    <p>
      <label for="<?php echo $this->get_field_id('bg_title_bl'); ?>"><?php _e('Цвет фона заголовка'); ?></label>
      <input class="widefat" style="float: right; width:30%; background: #<?php echo $instance['bg_title_bl']; ?>; color: #<?php echo $instance['color_title_bl']; ?>; border: 0;" id="<?php echo $this->get_field_id('bg_title_bl'); ?>" name="<?php echo $this->get_field_name('bg_title_bl'); ?>" type="text" value="<?php echo $instance['bg_title_bl']; ?>" />
    </p>
  </div>

  <div style="background: #fff; margin-bottom: 10px; padding: 10px; border: 1px solid #e1e1e1; -webkit-border-radius: 4px; -moz-border-radius: 4px; border-radius: 4px;">	
    <p>
      <label style="font-weight: bold;" for="<?php echo $this->get_field_id('con_bl'); ?>"><?php _e('Текст/HTML-код'); ?></label><br/>
      <textarea class="widefat" rows="16" cols="20" style="margin-top: 2px; background: #<?php echo $instance['bg_bl']; ?>; color: #<?php echo $instance['color_text_bl']; ?>; border: 0;" id="<?php echo $this->get_field_id('con_bl'); ?>" name="<?php echo $this->get_field_name('con_bl'); ?>"><?php echo $instance['con_bl']; ?></textarea>
    </p>

    <p>
      <label for="<?php echo $this->get_field_id('color_text_bl'); ?>"><?php _e('Цвет текста:'); ?></label>
      <input class="widefat" style="float: right; width:30%; background: #<?php echo $instance['bg_bl']; ?>; color: #<?php echo $instance['color_text_bl']; ?>; border: 0;" name="<?php echo $this->get_field_name('color_text_bl'); ?>" type="text" value="<?php echo $instance['color_text_bl']; ?>" />
    </p>

    <p>
      <label for="<?php echo $this->get_field_id('bg_bl'); ?>"><?php _e('Цвет фона блока:'); ?></label>
      <input class="widefat" style="float: right; width:30%; background: #<?php echo $instance['bg_bl']; ?>; color: #<?php echo $instance['color_text_bl']; ?>; border: 0;" name="<?php echo $this->get_field_name('bg_bl'); ?>" type="text" value="<?php echo $instance['bg_bl']; ?>" />
    </p>
	
	<p>
      <input id="<?php echo $this->get_field_id('filter'); ?>" name="<?php echo $this->get_field_name('filter'); ?>" type="checkbox" <?php checked(isset($instance['filter']) ? $instance['filter'] : 0); ?> />&nbsp;<label for="<?php echo $this->get_field_id('filter'); ?>">Автоматически добавлять абзацы</label>
    </p>
  </div>

  <?php 
  }
}
?>