<?php
/**
 * A unique identifier is defined to store the options in the database and reference them from the theme.
 * By default it uses the theme name, in lowercase and without spaces, but this can be changed if needed.
 * If the identifier changes, it'll appear as if the options have been reset.
 */

function optionsframework_option_name() {

	// This gets the theme name from the stylesheet
	$themename = wp_get_theme();
	$themename = preg_replace("/\W/", "_", strtolower($themename) );

	$optionsframework_settings = get_option( 'optionsframework' );
	$optionsframework_settings['id'] = $themename;
	update_option( 'optionsframework', $optionsframework_settings );
}

/**
 * Defines an array of options that will be used to generate the settings page and be saved in the database.
 * When creating the 'id' fields, make sure to use all lowercase and no spaces.
 *
 * If you are making your theme translatable, you should replace 'options_framework_theme'
 * with the actual text domain for your theme.  Read more:
 * http://codex.wordpress.org/Function_Reference/load_theme_textdomain
 */

function optionsframework_options() {

	// Test data
	$test_array = array(
		'one' => __('One', 'options_framework_theme'),
		'two' => __('Two', 'options_framework_theme'),
		'three' => __('Three', 'options_framework_theme'),
		'four' => __('Four', 'options_framework_theme'),
		'five' => __('Five', 'options_framework_theme')
	);

	// Multicheck Array
	$multicheck_array = array(
		'one' => __('French Toast', 'options_framework_theme'),
		'two' => __('Pancake', 'options_framework_theme'),
		'three' => __('Omelette', 'options_framework_theme'),
		'four' => __('Crepe', 'options_framework_theme'),
		'five' => __('Waffle', 'options_framework_theme')
	);

	// Multicheck Defaults
	$multicheck_defaults = array(
		'one' => '1',
		'five' => '1'
	);

	// Background Defaults
	$background_defaults = array(
		'color' => '',
		'image' => '',
		'repeat' => 'repeat',
		'position' => 'top center',
		'attachment'=>'scroll' );

	// Typography Defaults
	$typography_defaults = array(
		'size' => '15px',
		'face' => 'georgia',
		'style' => 'bold',
		'color' => '#bada55' );
		
	// Typography Options
	$typography_options = array(
		'sizes' => array( '6','12','14','16','20' ),
		'faces' => array( 'Helvetica Neue' => 'Helvetica Neue','Arial' => 'Arial' ),
		'styles' => array( 'normal' => 'Normal','bold' => 'Bold' ),
		'color' => false
	);

	// Pull all the categories into an array
	$options_categories = array();
	$options_categories_obj = get_categories();
	foreach ($options_categories_obj as $category) {
		$options_categories[$category->cat_ID] = $category->cat_name;
	}
	
	// Pull all tags into an array
	$options_tags = array();
	$options_tags_obj = get_tags();
	foreach ( $options_tags_obj as $tag ) {
		$options_tags[$tag->term_id] = $tag->name;
	}


	// Pull all the pages into an array
	$options_pages = array();
	$options_pages_obj = get_pages('sort_column=post_parent,menu_order');
	$options_pages[''] = 'Выберите страницу:';
	foreach ($options_pages_obj as $page) {
		$options_pages[$page->ID] = $page->post_title;
	}

	// If using image radio buttons, define a directory path
	$imagepath =  get_template_directory_uri() . '/images/';

	$options = array();
	
/*------------------------------------------------------------------------------*/
/*	Основные настройки
/*------------------------------------------------------------------------------*/	

	$options[] = array(
		'name' => 'Основные настройки',
		'type' => 'heading');

	$options[] = array(
		'name' => 'Логотип',
		'desc' => 'Ссылка на файл изображения (JPEG, PNG, GIF)',
		'id' => 'logo',
		'type' => 'upload');
		
	$options[] = array(
		'desc' => 'Текст',
		'id' => 'logo_text',
		'std' => '',
		'type' => 'text');	

	$options[] = array(
		'name' => 'Иконка favicon',
		'desc' => 'Ссылка на файл изображения 16x16px (JPEG, PNG, GIF)',
		'id' => 'favicon',
		'type' => 'upload');
		
/*------------------------------------------------------------------------------*/
/*	Внешний вид
/*------------------------------------------------------------------------------*/	

	$options[] = array(
		'name' => 'Внешний вид',
		'type' => 'heading');

	$options[] = array(
		'name' => 'Фоновое изображение',
		'desc' => 'Включить',
		'id' => 'bg_image_body_on',
		'std' => '1',
		'type' => 'checkbox');
		
	$options[] = array(
		'desc' => 'Растянуть на весь экран',
		'id' => 'bg_image_body_full',
		'std' => '0',
		'type' => 'checkbox');		
	
	$options[] = array(
		'desc' => 'Файл изображения (JPEG, PNG, GIF)',
		'id' => 'bg_image_body_my',
		'type' => 'upload');
		
	$options[] = array(
	    'desc' => 'Повтор фона',
		'id' => 'bg_image_body_repeat',
		'std' => 'repeat',
		'type' => 'select',
        'options' => array(
		  'repeat' => 'Повторяется по горизонтали и вертикали',
		  'repeat-x' => 'Повторяется только по горизонтали',
		  'repeat-y' => 'Повторяется только по вертикали',
		  'no-repeat' => 'Без повторений')
	);

	$options[] = array(
	    'desc' => 'Позиция фона',
		'id' => 'bg_image_body_position',
		'std' => 'left',
		'type' => 'select',
        'options' => array(
		  'left' => 'Слева',
		  'center' => 'По центру',
		  'right' => 'Справа')
	);		
	
	$options[] = array(
		'name' => 'Цвет фона',
		'id' => 'bg_color_body',
		'std' => '#f4f4f4',
		'type' => 'color' );

/*  Header 
------------------------------------- */	

	$options[] = array(
		'name' => 'Шапка (Header)',
		'desc' => 'Цвет фона',
		'id' => 'bg_h',
		'std' => '#212841',
		'type' => 'color' );
		
	$options[] = array(
		'desc' => 'Файл изображения (JPEG, PNG, GIF)',
		'id' => 'bg_image_h',
		'type' => 'upload');	
		
	$options[] = array(
	    'desc' => 'Повтор фона',
		'id' => 'bg_image_h_repeat',
		'std' => 'repeat',
		'type' => 'select',
        'options' => array(
		  'repeat' => 'Повторяется по горизонтали и вертикали',
		  'repeat-x' => 'Повторяется только по горизонтали',
		  'repeat-y' => 'Повторяется только по вертикали',
		  'no-repeat' => 'Без повторений')
	);

	$options[] = array(
	    'desc' => 'Позиция фона',
		'id' => 'bg_image_h_position',
		'std' => 'left',
		'type' => 'select',
        'options' => array(
		  'left' => 'Слева',
		  'center' => 'По центру',
		  'right' => 'Справа')
	);	
	
	$options[] = array(
		'desc' => '<h4 class="heading-2">Настройки тени</h4>',
		'type' => 'info');		

	$options[] = array(
		'desc' => 'Цвет',
		'id' => 'h_shadow_color',
		'std' => '#b6b6b6',
		'type' => 'color' );	

	$options[] = array(
		'desc' => 'Размер тени в px',
		'id' => 'h_shadow_size',
		'std' => '4',
		'type' => 'text' );	
		
/*  Top Menu 
------------------------------------- */		
		
	$options[] = array(
		'name' => 'Верхнее меню',
		'desc' => 'Цвет ссылок',
		'id' => 'link_color_top_nav',
		'std' => '#f9f9f9',
		'type' => 'color' );
		
	$options[] = array(
		'desc' => 'Цвет ссылок при наведении',
		'id' => 'link_color_hover_top_nav',
		'std' => '#a0b1bf',
		'type' => 'color' );
		
	$options[] = array(
		'desc' => '<h4 class="heading-2">Дочерние пункты</h4>',
		'type' => 'info');		

	$options[] = array(
		'desc' => 'Цвет фона',
		'id' => 'bg_top_nav_child',
		'std' => '#1c2238',
		'type' => 'color' );
		
	$options[] = array(
		'desc' => 'Цвет ссылок',
		'id' => 'link_color_top_nav_child',
		'std' => '#f9f9f9',
		'type' => 'color' );
		
	$options[] = array(
		'desc' => 'Цвет ссылок при наведении',
		'id' => 'link_color_hover_top_nav_child',
		'std' => '#a0b1bf',
		'type' => 'color' );		

/*  Sidebar Menu 
------------------------------------- */		
		
	$options[] = array(
	    'name' => 'Меню отображаемое через виджет "Произвольное меню"',
		'desc' => 'Цвет ссылок',
		'id' => 'link_color_s_nav',
		'std' => '#888888',
		'type' => 'color' );
		
	$options[] = array(
		'desc' => 'Цвет ссылок при наведении',
		'id' => 'link_color_hover_s_nav',
		'std' => '#444444',
		'type' => 'color' );
		
	$options[] = array(
		'desc' => 'Цвет границы',
		'id' => 'border_color_s_nav',
		'std' => '#e1e1e1',
		'type' => 'color' );		

	$options[] = array(
		'desc' => '<h4 class="heading-2">Дочерние пункты</h4>',
		'type' => 'info');		
		
	$options[] = array(
		'desc' => 'Цвет ссылок',
		'id' => 'link_color_s_nav_2',
		'std' => '#888888',
		'type' => 'color' );
		
	$options[] = array(
		'desc' => 'Цвет ссылок при наведении',
		'id' => 'link_color_hover_s_nav_2',
		'std' => '#444444',
		'type' => 'color' );			
		
/*  Primary Style
------------------------------------- */

	$options[] = array(
		'name' => 'Основной контент',
		'desc' => 'Цвет текста',
		'id' => 'text_color',
		'std' => '#666666',
		'type' => 'color' );	
		
	$options[] = array(
		'desc' => 'Цвет заголовков h1, h2, h3, h4, h5, h6',
		'id' => 'text_color_heading',
		'std' => '#444444',
		'type' => 'color' );		
		
	$options[] = array(
		'desc' => 'Цвет ссылок',
		'id' => 'link_color',
		'std' => '#495e83',
		'type' => 'color' );
		
	$options[] = array(
		'desc' => 'Цвет ссылок при наведении',
		'id' => 'link_color_hover',
		'std' => '#888888',
		'type' => 'color' );
		
	$options[] = array(
		'desc' => 'Размер шрифта в px',
		'id' => 'font_size',
		'std' => '14',
		'type' => 'text' );	
		
	$options[] = array(
		'desc' => '<h4 class="heading-2">Заголовки виджетов</h4>',
		'type' => 'info');	
		
    $options[] = array(
		'id' => 'text_color_wg_pr_t',
		'std' => '#6ba800',
		'type' => 'color' );
		
	$options[] = array(
		'desc' => 'Размер шрифта в px',
		'id' => 'font_size_wg_pr_t',
		'std' => '18',
		'type' => 'text' );	

	$options[] = array(
	    'desc' => 'Насыщенность шрифта',
		'id' => 'font_weight_wg_pr_t',
		'std' => 'normal',
		'type' => 'select',
        'options' => array(
		  'normal' => 'Нормальный',
		  'bold' => 'Полужирный')
	);	
	
	$options[] = array(
		'desc' => '<h4 class="heading-2">Настройки тени</h4>',
		'type' => 'info');		
	
	$options[] = array(
		'desc' => 'Цвет',
		'id' => 'pr_shadow_color',
		'std' => '#d6d6d6',
		'type' => 'color' );	

	$options[] = array(
		'desc' => 'Размер тени в px',
		'id' => 'pr_shadow_size',
		'std' => '4',
		'type' => 'text' );		
	
/*  Sidebar Style 
------------------------------------- */
		
    $options[] = array(
	    'name' => 'Боковая колонка',
		'desc' => 'Цвет текста',
		'id' => 'text_color_s',
		'std' => '#666666',
		'type' => 'color' );

	$options[] = array(
		'desc' => 'Цвет ссылок',
		'id' => 'link_color_s',
		'std' => '#495e83',
		'type' => 'color' );
		
	$options[] = array(
		'desc' => 'Цвет ссылок при наведении',
		'id' => 'link_color_hover_s',
		'std' => '#888888',
		'type' => 'color' );

	$options[] = array(
		'desc' => 'Размер шрифта в px',
		'id' => 'font_size_s',
		'std' => '14',
		'type' => 'text' );					
		
	$options[] = array(
		'desc' => '<h4 class="heading-2">Заголовки виджетов</h4>',
		'type' => 'info');	
		
    $options[] = array(
		'id' => 'text_color_wg_s_t',
		'std' => '#6ba800',
		'type' => 'color' );
		
	$options[] = array(
		'desc' => 'Размер шрифта в px',
		'id' => 'font_size_wg_s_t',
		'std' => '18',
		'type' => 'text' );	

	$options[] = array(
	    'desc' => 'Насыщенность шрифта',
		'id' => 'font_weight_wg_s_t',
		'std' => 'normal',
		'type' => 'select',
        'options' => array(
		  'normal' => 'Нормальный',
		  'bold' => 'Полужирный')
	); 
	
	$options[] = array(
		'desc' => '<h4 class="heading-2">Настройки тени</h4>',
		'type' => 'info');		
	
	$options[] = array(
		'desc' => 'Цвет',
		'id' => 's_shadow_color',
		'std' => '#d6d6d6',
		'type' => 'color' );	

	$options[] = array(
		'desc' => 'Размер тени в px',
		'id' => 's_shadow_size',
		'std' => '4',
		'type' => 'text' );		
	
/*  Bottom Style 
------------------------------------- */ 
		
	$options[] = array(
        'name' => 'Нижняя левая колонка, Нижняя центральная колонка, Нижняя правая колонка',	
		'desc' => 'Цвет текста',
		'id' => 'text_color_b',
		'std' => '#666666',
		'type' => 'color' );		

	$options[] = array(
		'desc' => 'Цвет ссылок',
		'id' => 'link_color_b',
		'std' => '#495e83',
		'type' => 'color' );
		
	$options[] = array(
		'desc' => 'Цвет ссылок при наведении',
		'id' => 'link_color_hover_b',
		'std' => '#888888',
		'type' => 'color' );		
		
	$options[] = array(
		'desc' => 'Размер шрифта в px',
		'id' => 'font_size_b',
		'std' => '14',
		'type' => 'text' );	

	$options[] = array(
		'desc' => '<h4 class="heading-2">Заголовки виджетов</h4>',
		'type' => 'info');	
		
	$options[] = array(
		'desc' => 'Цвет заголовков виджетов',
		'id' => 'text_color_wg_b_t',
		'std' => '#6ba800',
		'type' => 'color' );
		
	$options[] = array(
		'desc' => 'Размер шрифта в px',
		'id' => 'font_size_wg_b_t',
		'std' => '18',
		'type' => 'text' );	

	$options[] = array(
	    'desc' => 'Насыщенность шрифта',
		'id' => 'font_weight_wg_b_t',
		'std' => 'normal',
		'type' => 'select',
        'options' => array(
		  'normal' => 'Нормальный',
		  'bold' => 'Полужирный')
	); 	
	
	$options[] = array(
		'desc' => '<h4 class="heading-2">Настройки тени</h4>',
		'type' => 'info');		

	$options[] = array(
		'desc' => 'Цвет',
		'id' => 'b_shadow_color',
		'std' => '#d6d6d6',
		'type' => 'color' );	

	$options[] = array(
		'desc' => 'Размер тени в px',
		'id' => 'b_shadow_size',
		'std' => '4',
		'type' => 'text' );		

/*  Footer Style 
------------------------------------- */	
		
	$options[] = array(
		'name' => 'Подвал (Footer)',
		'desc' => 'Цвет фона',
		'id' => 'bg_f',
		'std' => '#212841',
		'type' => 'color' );		
		
	$options[] = array(
		'desc' => 'Цвет текста',
		'id' => 'text_color_f',
		'std' => '#f9f9f9',
		'type' => 'color' );		
		
	$options[] = array(
		'desc' => 'Цвет ссылок',
		'id' => 'link_color_f',
		'std' => '#a0b1bf',
		'type' => 'color' );

	$options[] = array(
		'desc' => 'Цвет ссылок при наведении',
		'id' => 'link_color_hover_f',
		'std' => '#f9f9f9',
		'type' => 'color' );

	$options[] = array(
		'desc' => 'Размер шрифта в px',
		'id' => 'font_size_f',
		'std' => '14',
		'type' => 'text' );	

	$options[] = array(
		'desc' => '<h4 class="heading-2">Настройки тени</h4>',
		'type' => 'info');	
		
	$options[] = array(
		'desc' => 'Цвет',
		'id' => 'f_shadow_color',
		'std' => '#b6b6b6',
		'type' => 'color' );	

	$options[] = array(
		'desc' => 'Размер тени в px',
		'id' => 'f_shadow_size',
		'std' => '4',
		'type' => 'text' );			
		
/*------------------------------------------------------------------------------*/
/*	Настройки макета
/*------------------------------------------------------------------------------*/	

	$options[] = array(
		'name' => 'Настройки макета',
		'type' => 'heading' );
		
	$options[] = array(
		'name' => "Боковая колонка",
		'id' => "sidebar",
		'std' => "r_s",
		'type' => "images",
		'options' => array(
			'l_s' => $imagepath . 'theme_options/2cl.png',
			'r_s' => $imagepath . 'theme_options/2cr.png')
	);	

	$options[] = array(	
		'name' => 'Главная страница',
		'id' => 'home_post_on',
		'std' => 'home_post_options',
		'type' => 'radio',
        'options' => array(
		  'home_post_standart' => 'Стандартные записи',
		  'home_page' => 'Статическая страница',
		  'home_post_options' => 'Записи с дополнительными настройками и без постраничной навигации')
	);

	$options[] = array(
		'desc' => '<h4 class="heading-2" style="margin-top: 0;">Статическая страница</h4>',
		'type' => 'info');		

	$options[] = array(
		'desc' => 'Выбор страницы',
		'id' => 'home_page_id',
		'type' => 'select',
		'options' => $options_pages);		

	$options[] = array(
		'desc' => '<h4 class="heading-2" style="margin-top: 0;">Записи</h4>',
		'type' => 'info');	

	$options[] = array(
		'desc' => 'Количество записей',
		'id' => 'home_post_num',
		'std' => '5',
		'type' => 'text');
		
	$options[] = array(
		'desc' => 'ID категорий, разделённые запятыми. По умолчанию 0 все категории.',
		'id' => 'home_post_category_id',
		'std' => '0',
		'type' => 'text');	

	$options[] = array(
		'desc' => 'Сортировка',
		'id' => 'home_post_order',
		'std' => 'date',
		'type' => 'select',
        'options' => array(
		  'date' => 'Дата добавления',
		  'comment_count' => 'Количество комментариев',
		  'rand' => 'Случайно')
	);	
	
	$options[] = array(
	    'name' => "Заголовок и описание",
		'desc' => 'Рубрики',
		'id' => 'cat_desc_on',
		'std' => '1',
		'type' => 'checkbox');	
		
	$options[] = array(
		'desc' => 'Метки',
		'id' => 'tags_desc_on',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'desc' => 'Страницы',
		'id' => 'page_desc_on',
		'std' => '1',
		'type' => 'checkbox');
		
    $options[] = array(
		'name' => 'Нижняя левая колонка, Нижняя центральная колонка, Нижняя правая колонка',
		'desc' => 'Включить',
		'id' => 'blocks_bottom_on',
		'std' => '1',
		'type' => 'checkbox');			

	$options[] = array(
	    'name' => "Постраничная навигация",
		'desc' => 'Включить',
		'id' => 'pagination_on',
		'std' => '1',
		'type' => 'checkbox');	

/*------------------------------------------------------------------------------*/
/*	Записи
/*------------------------------------------------------------------------------*/			
	
	$options[] = array(
		'name' => 'Записи',
		'type' => 'heading' );
		
	$options[] = array(
		'desc' => '<h4 class="heading">Главная страница, страница рубрики, метки, архива, автора, поиска</h4>',
		'type' => 'info');	

	$options[] = array(
		'desc' => '<h4 class="heading-2" style="margin-top: 0;">Заголовки записей</h4>',
		'type' => 'info');	
		
	$options[] = array(
	    'desc' => 'Цвет ссылки',
		'id' => 'link_color_e_t',
		'std' => '#495e83',
		'type' => 'color' );
		
	$options[] = array(
	    'desc' => 'При наведении',
		'id' => 'link_color_hover_e_t',
		'std' => '#888888',
		'type' => 'color' );
		
	$options[] = array(
		'desc' => 'Размер шрифта в px',
		'id' => 'font_size_e_t',
		'std' => '22',
		'type' => 'text' );	

	$options[] = array(
	    'desc' => 'Насыщенность шрифта',
		'id' => 'font_weight_e_t',
		'std' => 'normal',
		'type' => 'select',
        'options' => array(
		  'normal' => 'Нормальный',
		  'bold' => 'Полужирный')
	);	
	
	$options[] = array(
		'desc' => '<h4 class="heading-2" style="margin-top: 0;">Категории</h4>',
		'type' => 'info');	

	$options[] = array(
		'desc' => 'Включить',
		'id' => 'cat_on',
		'std' => '1',
		'type' => 'checkbox');			
		
	$options[] = array(
	    'desc' => 'Цвет ссылки',
		'id' => 'link_color_cat',
		'std' => '#dd9907',
		'type' => 'color' );
		
	$options[] = array(
	    'desc' => 'При наведении',
		'id' => 'link_color_hover_cat',
		'std' => '#888888',
		'type' => 'color' );	

	$options[] = array(
		'desc' => '<h4 class="heading-2">Информационный блок (дата, количество комментариев)</h4>',
		'type' => 'info');	
		
	$options[] = array(
		'desc' => 'Включить',
		'id' => 'entry_details_on',
		'std' => '1',
		'type' => 'checkbox');	

	$options[] = array(
		'desc' => '',
		'type' => 'info');	

	$options[] = array(
		'desc' => 'Цвет текста',
		'id' => 'text_color_e_d',
		'std' => '#888888',
		'type' => 'color' );
		
	$options[] = array(
		'desc' => 'Цвет ссылок',
		'id' => 'link_color_e_d',
		'std' => '#6ba800',
		'type' => 'color' );	
	
	$options[] = array(
		'desc' => 'Цвет ссылок при наведении',
		'id' => 'link_color_hover_e_d',
		'std' => '#888888',
		'type' => 'color' );
		
	$options[] = array(
		'desc' => 'Размер шрифта в px',
		'id' => 'font_size_e_d',
		'std' => '13',
		'type' => 'text' );	

	$options[] = array(
	    'desc' => 'Насыщенность шрифта',
		'id' => 'font_weight_e_d',
		'std' => 'normal',
		'type' => 'select',
        'options' => array(
		  'normal' => 'Нормальный',
		  'bold' => 'Полужирный')
	);	
	
	$options[] = array(
		'desc' => '<h4 class="heading-2">Количество слов в записи</h4>',
		'type' => 'info');

	$options[] = array(
		'id' => 'excerpt_options',
		'std' => '40',
		'type' => 'text' );			
	
	$options[] = array(
		'desc' => '<h4 class="heading-2">Кнопка "Читать далее..."</h4>',
		'type' => 'info');	
		
	$options[] = array(
		'desc' => 'Включить',
		'id' => 'more_link_on',
		'std' => '1',
		'type' => 'checkbox');	

	$options[] = array(
		'desc' => 'Текст ссылки',
		'id' => 'text_more_link',
		'std' => 'Читать далее...',
		'type' => 'text' );		

	$options[] = array(
		'desc' => 'Цвет текста',
		'id' => 'text_color_more_link',
		'std' => '#6ba800',
		'type' => 'color' );	
		
	$options[] = array(
		'desc' => 'Размер шрифта в px',
		'id' => 'font_size_more_link',
		'std' => '13',
		'type' => 'text' );			

	$options[] = array(
	    'desc' => 'Насыщенность шрифта',
		'id' => 'font_weight_more_link',
		'std' => 'bold',
		'type' => 'select',
        'options' => array(
		  'normal' => 'Нормальный',
		  'bold' => 'Полужирный')
	);			

	$options[] = array(
	    'name' => 'Страница записи',
		'desc' => 'Информационный блок (дата, категории, теги, количество комментариев)',
		'id' => 'entry_details_2_on',
		'std' => '1',
		'type' => 'checkbox');

	$options[] = array(
		'desc' => 'Комментарии',
		'id' => 'comments_on',
		'std' => '1',
		'type' => 'checkbox');
		
	$options[] = array(
		'desc' => 'Навигация',
		'id' => 'nav_post_on',
		'std' => '1',
		'type' => 'checkbox');		

	$options[] = array(
		'desc' => '<h4 class="heading-2">Заголовок записи</h4>',
		'type' => 'info');	

	$options[] = array(
		'desc' => 'Включить',
		'id' => 'e_t_2_on',
		'std' => '1',
		'type' => 'checkbox');			
		
	$options[] = array(
		'id' => 'color_e_t',
		'std' => '#444444',
		'type' => 'color' );		
		
	$options[] = array(
		'desc' => 'Размер шрифта в px',
		'id' => 'font_size_e_t_2',
		'std' => '22',
		'type' => 'text' );	

	$options[] = array(
	    'desc' => 'Насыщенность шрифта',
		'id' => 'font_weight_e_t_2',
		'std' => 'normal',
		'type' => 'select',
        'options' => array(
		  'normal' => 'Нормальный',
		  'bold' => 'Полужирный')
	);
	
	$options[] = array(
		'desc' => '<h4 class="heading-2">Лайтбокс (Галерея WordPress)</h4>',
		'type' => 'info');		
	
	$options[] = array(
		'desc' => 'Включить',
		'id' => 'lightbox',
		'std' => '1',
		'type' => 'checkbox');	

	$options[] = array(
		'desc' => '<h4 class="heading-2">Похожие записи</h4>',
		'type' => 'info');			

	$options[] = array(
		'desc' => 'Включить',
		'id' => 'related_post_on',
		'std' => '1',
		'type' => 'checkbox');	
		
	$options[] = array(
		'desc' => 'Заголовок',
		'id' => 'related_post_heading',
		'std' => 'Похожие записи',
		'type' => 'text');

	$options[] = array(
		'desc' => 'Количество записей',
		'id' => 'related_post_num',
		'std' => '5',
		'type' => 'text');					

/*------------------------------------------------------------------------------*/
/*	Слайдер
/*------------------------------------------------------------------------------*/			
		
	$options[] = array(
		'name' => 'Слайдер',
		'type' => 'heading' );		
		
	$options[] = array(
		'desc' => 'Включить',
		'id' => 'slider_on',
		'std' => '1',
		'type' => 'checkbox');	
		
	$options[] = array(
	    'name' => 'Записи блога',
		'desc' => 'Включить',
		'id' => 'slider_post_on',
		'std' => '0',
		'type' => 'checkbox');		
		
	$options[] = array(
		'desc' => 'Количество записей',
		'id' => 'sl_num_post',
		'std' => '5',
		'type' => 'text');			
		
	$options[] = array(
		'desc' => 'Категории',
		'desc' => 'ID категорий, разделённые запятыми. По умолчанию 0 все категории.',
		'id' => 'sl_id_cat',
		'std' => '0',
		'type' => 'text');	

	$options[] = array(
		'desc' => 'Сортировка',
		'id' => 'sl_order_cat',
		'std' => 'date',
		'type' => 'select',
        'options' => array(
		  'date' => 'Дата добавления',
		  'comment_count' => 'Количество комментариев',
		  'rand' => 'Случайно')
	);					
		
	$options[] = array(
		'name' => 'Слайд-шоу',
		'desc' => 'Анимация',
		'id' => 'sl_animation',
		'std' => 'fade',
		'type' => 'select',
        'options' => array(
		  'fade' => 'Fade',
		  'slide' => 'Slide')
	);	
	
	$options[] = array(
		'desc' => 'Скорость анимации (800-5000)',
		'id' => 'animation_speed',
		'std' => '900',
		'type' => 'text');
	
	$options[] = array(
		'desc' => 'Скорость слайд-шоу (1000-15000)',
		'id' => 'slideshow_speed',
		'std' => '5000',
		'type' => 'text');
		
	$options[] = array(
		'desc' => 'Текст',
		'id' => 'caption_on',
		'std' => '1',
		'type' => 'checkbox');				

	return $options;
}